/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.internal.build.LazyBuildParticipant;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.TaskTag;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.RemoteIndexProcessStateHelper;
import com.aptana.index.core.build.BuildContext;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.pandora.index.service.BuildRequest;
import com.pandora.index.service.IRemoteBuildService;
import com.pandora.index.service.IndexServicePlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.BundleActivator;

public class BuildRemoteParticipant {
    static BuildRemoteParticipant buildRemoteParticipant;
    private static Kryo kryo;

    static {
        kryo = new Kryo();
        kryo.setClassLoader(BuildRemoteParticipant.class.getClassLoader());
        kryo.setAutoReset(true);
    }

    public static BuildRemoteParticipant getInstance() {
        if (buildRemoteParticipant == null) {
            buildRemoteParticipant = new BuildRemoteParticipant();
        }
        return buildRemoteParticipant;
    }

    public List<IBuildParticipant> buildFile(List<IBuildParticipant> allParticipants, BuildContext context, SubMonitor monitor) {
        if (!RemoteIndexProcessStateHelper.isRunning() || allParticipants == null || allParticipants.isEmpty()) {
            return allParticipants;
        }
        try {
            List<IBuildParticipant> localBuildParticipants = this.filterNotNeedRemoteBuild(context, allParticipants);
            if (localBuildParticipants.size() == allParticipants.size()) {
                return allParticipants;
            }
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            BuildRequest request = new BuildRequest();
            request.setCharset(context.getCharset());
            request.setIndexURI(context.getURI());
            request.setNeedSleep(context.isNeedSleep());
            request.setReconcile(context.isReconcile());
            request.setHighPriority(context.isReconcile() || context.isHighPriority());
            request.setContentType(context.getContentType());
            request.setSave(context.isSave());
            request.setCaseSensitive(TaskTag.isCaseSensitive());
            request.setRawTagNames(TaskTag.getRawTagNames());
            request.setRawTagPriorities(TaskTag.getRawTagPriorities());
            if (context.isReconcile()) {
                request.setContents(context.getContents());
            }
            if (context.getProject() != null) {
                request.setProjectURI(context.getProject().getLocationURI());
            }
            request.setOpenManualValidator(context.isOpenManualValidator());
            IRemoteBuildService buildService = this.getRemoteBuildService();
            sub.subTask("Remote " + this.getIndexingMessage(request.getProjectURI(), request.getIndexURI()));
            byte[] bytes = buildService.build(request);
            if (sub.isCanceled()) {
                return Collections.EMPTY_LIST;
            }
            if (bytes != null && bytes.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                Input input = new Input((InputStream)bais);
                Object obj = kryo.readClassAndObject(input);
                input.close();
                if (obj instanceof Map) {
                    Map result = (Map)obj;
                    Set keySet = result.keySet();
                    for (String key : keySet) {
                        if (sub.isCanceled()) {
                            return Collections.EMPTY_LIST;
                        }
                        Object problemObject = result.get(key);
                        if (!(problemObject instanceof Collection)) continue;
                        try {
                            Collection problemCollection = (Collection)problemObject;
                            context.putProblems(key, problemCollection);
                        }
                        catch (ClassCastException classCastException) {}
                    }
                }
            }
            return localBuildParticipants;
        }
        catch (Exception e) {
            if (e instanceof RemoteException && !(e.getCause() instanceof SocketTimeoutException)) {
                RemoteIndexProcessStateHelper.setState((int)0);
            }
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            return allParticipants;
        }
    }

    private IRemoteBuildService getRemoteBuildService() throws Exception {
        return IndexServicePlugin.getDefault().getRemoteBuildService((BundleActivator)IndexPlugin.getDefault());
    }

    protected String getIndexingMessage(URI containerURI, URI uri) {
        String relativePath = null;
        relativePath = containerURI != null ? containerURI.relativize(uri).toString() : uri.toString();
        return MessageFormat.format("Building {0}", relativePath);
    }

    public List<IBuildParticipant> filterNotNeedRemoteBuild(final BuildContext context, List<IBuildParticipant> participants) {
        return CollectionsUtil.filter(participants, (IFilter)new IFilter<IBuildParticipant>(){

            public boolean include(IBuildParticipant item) {
                if (item instanceof AbstractRemoteBuildParticipant) {
                    return !((AbstractRemoteBuildParticipant)item).needBuildFile(context);
                }
                if (item instanceof LazyBuildParticipant && ((LazyBuildParticipant)item).getParticipant() instanceof AbstractRemoteBuildParticipant) {
                    AbstractRemoteBuildParticipant participant = (AbstractRemoteBuildParticipant)((LazyBuildParticipant)item).getParticipant();
                    return !participant.needBuildFile(context);
                }
                return true;
            }
        });
    }
}

