/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class BuildFileManager {
    private static BuildFileManager buildFileManager;
    private HashMap<String, HashSet<IFile>> highPriorityIFiles = new HashMap();
    private HashMap<String, HashSet<IFile>> allIFiles = new HashMap();
    private HashMap<String, HashSet<IFile>> buildedIFiles = new HashMap();

    public static BuildFileManager getInstance() {
        if (buildFileManager == null) {
            buildFileManager = new BuildFileManager();
        }
        return buildFileManager;
    }

    public void initHighPriorityIFiles() {
        final LinkedHashSet aEditors = new LinkedHashSet();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] editorReferences;
                IWorkbenchWindow workbenchWindow = BuildPathCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow == null) {
                    return;
                }
                IWorkbenchPage page = workbenchWindow.getActivePage();
                if (page == null) {
                    return;
                }
                IEditorPart editor = page.getActiveEditor();
                if (editor != null) {
                    aEditors.add(editor);
                }
                if ((editorReferences = page.getEditorReferences()) != null) {
                    IEditorReference[] iEditorReferenceArray = editorReferences;
                    int n = editorReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference editorReference = iEditorReferenceArray[n2];
                        IEditorPart part = editorReference.getEditor(false);
                        if (part != null) {
                            aEditors.add(part);
                        }
                        ++n2;
                    }
                }
            }
        });
        for (IEditorPart iEditorPart : aEditors) {
            IFile iFile = BuildFileManager.getIFile(iEditorPart);
            this.addHighPriorityFile(iFile);
        }
    }

    private static IFile getIFile(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile iFile = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            iFile = fileEditorInput.getFile();
        }
        return iFile;
    }

    public void clearProjectFiles(IProject project) {
        if (project == null) {
            return;
        }
        String key = this.getKey(project);
        this.highPriorityIFiles.remove(key);
        this.allIFiles.remove(key);
        this.buildedIFiles.remove(key);
    }

    private String getKey(IProject project) {
        return project.getLocationURI().toString();
    }

    public void addProjectIFiles(IProject project, Collection<IFile> buildFiles) {
        if (project == null || buildFiles == null) {
            return;
        }
        if (this.allIFiles == null) {
            this.allIFiles = new HashMap();
        }
        String key = this.getKey(project);
        HashSet<IFile> allFiles = null;
        allFiles = this.allIFiles.containsKey(key) ? this.allIFiles.get(key) : new HashSet<IFile>();
        allFiles.addAll(buildFiles);
        this.allIFiles.put(key, allFiles);
    }

    public void addProjectHighPriorityIFiles(IProject project, List<IFile> files) {
        if (project == null || files == null) {
            return;
        }
        if (this.highPriorityIFiles == null) {
            this.highPriorityIFiles = new HashMap();
        }
        String key = this.getKey(project);
        HashSet<IFile> allFiles = null;
        allFiles = this.highPriorityIFiles.containsKey(key) ? this.highPriorityIFiles.get(key) : new HashSet<IFile>();
        allFiles.addAll(files);
        this.highPriorityIFiles.put(key, allFiles);
    }

    public List<IFile> getProjectHighPriorityIFiles(IProject project) {
        if (project == null) {
            return null;
        }
        String key = this.getKey(project);
        HashSet<Object> allFiles = null;
        allFiles = this.highPriorityIFiles.containsKey(key) ? this.highPriorityIFiles.get(key) : new HashSet();
        IFile[] fs = new IFile[allFiles.size()];
        return Arrays.asList(allFiles.toArray(fs));
    }

    public List<IFile> getProjectNoBuildIFiles(IProject project) {
        if (project == null) {
            return null;
        }
        String key = this.getKey(project);
        HashSet<Object> allFiles = null;
        allFiles = this.allIFiles.containsKey(key) ? this.allIFiles.get(key) : new HashSet();
        IFile[] fs = new IFile[allFiles.size()];
        return Arrays.asList(allFiles.toArray(fs));
    }

    public void addProjectBuildedIFiles(IProject project, List<IFile> files) {
        HashSet<IFile> aFiles;
        if (project == null || files == null) {
            return;
        }
        if (this.buildedIFiles == null) {
            this.buildedIFiles = new HashMap();
        }
        String key = this.getKey(project);
        HashSet<Object> allFiles = null;
        allFiles = this.buildedIFiles.containsKey(key) ? this.buildedIFiles.get(key) : new HashSet();
        HashSet<IFile> highPriorityFiles = this.highPriorityIFiles.get(key);
        if (highPriorityFiles != null) {
            highPriorityFiles.removeAll(files);
            this.highPriorityIFiles.put(key, highPriorityFiles);
        }
        if ((aFiles = this.allIFiles.get(key)) != null) {
            aFiles.removeAll(files);
            this.allIFiles.put(key, aFiles);
        }
        allFiles.addAll(files);
        this.buildedIFiles.put(key, allFiles);
    }

    public void addProjectBuildedIFile(IProject project, IFile file) {
        HashSet<IFile> aFiles;
        if (project == null || file == null) {
            return;
        }
        if (this.buildedIFiles == null) {
            this.buildedIFiles = new HashMap();
        }
        String key = this.getKey(project);
        HashSet<Object> allFiles = null;
        allFiles = this.buildedIFiles.containsKey(key) ? this.buildedIFiles.get(key) : new HashSet();
        HashSet<IFile> highPriorityFiles = this.highPriorityIFiles.get(key);
        if (highPriorityFiles != null) {
            highPriorityFiles.remove(file);
            this.highPriorityIFiles.put(key, highPriorityFiles);
        }
        if ((aFiles = this.allIFiles.get(key)) != null) {
            aFiles.remove(file);
            this.allIFiles.put(key, aFiles);
        }
        allFiles.add(file);
        this.buildedIFiles.put(key, allFiles);
    }

    public void addProjectHighPriorityIFiles(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        IFile iFile = BuildFileManager.getIFile(editor);
        this.addHighPriorityFile(iFile);
    }

    private void addHighPriorityFile(IFile iFile) {
        if (iFile == null) {
            return;
        }
        if (this.isBuilded(iFile) || iFile.getProject() == null || iFile.getProject().getLocationURI() == null) {
            return;
        }
        String key = this.getKey(iFile.getProject());
        HashSet<IFile> aFiles = this.allIFiles.get(key);
        if (aFiles != null && !aFiles.contains(iFile)) {
            return;
        }
        HashSet<Object> allFiles = null;
        allFiles = this.highPriorityIFiles.containsKey(key) ? this.highPriorityIFiles.get(key) : new HashSet();
        if (!allFiles.contains(iFile)) {
            allFiles.add(iFile);
            this.highPriorityIFiles.put(key, allFiles);
        }
    }

    private IPath getIPath(URI uri) {
        IPath path = Path.fromOSString((String)uri.getPath());
        return path;
    }

    private IFile getIFile(IPath ipath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(ipath);
        return file;
    }

    public void addJSReferencesHighPriorityIFile(URI resolved) {
        if (resolved == null) {
            return;
        }
        try {
            IPath path = this.getIPath(resolved);
            if (path == null) {
                return;
            }
            IFile file = this.getIFile(path);
            if (file == null) {
                return;
            }
            this.addHighPriorityFile(file);
        }
        catch (Throwable throwable) {}
    }

    public boolean isBuilded(IFile file) {
        String key;
        if (file == null) {
            return true;
        }
        if (file.getProject() == null) {
            return true;
        }
        if (file.getProject().getLocationURI() == null) {
            return true;
        }
        if (this.buildedIFiles == null) {
            this.buildedIFiles = new HashMap();
        }
        if (this.buildedIFiles.containsKey(key = this.getKey(file.getProject()))) {
            HashSet<IFile> allFiles = this.buildedIFiles.get(key);
            return allFiles.contains(file);
        }
        return false;
    }
}

