/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.RequiredBuildParticipant;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.build.BuildContext;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.index.service.BuildRequest;
import com.pandora.index.service.ILocalBuildService;
import com.pandora.index.service.IndexServicePlugin;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleActivator;

public abstract class AbstractRemoteBuildParticipant
extends RequiredBuildParticipant {
    @Override
    public boolean isRequired() {
        return false;
    }

    public void buildStart(BuildRequest request) {
    }

    public abstract boolean needBuildFile(BuildContext var1);

    public boolean needValidatorBuildFile(BuildContext context) {
        return context != null && (context.isFullBuild() || context.isSave() || context.isOpenManualValidator());
    }

    public boolean needTaskDetectorBuildFile(BuildContext context) {
        return context != null && (context.isFullBuild() || context.isSave());
    }

    public boolean isEnabled() {
        return false;
    }

    public void addResult(Map<String, Collection<IProblem>> resultMap, Collection<IProblem> problems, String key) {
        Collection<IProblem> results;
        if (resultMap == null) {
            resultMap = new HashMap<String, Collection<IProblem>>();
        }
        if ((results = resultMap.get(key)) == null) {
            results = problems;
        } else {
            results.addAll(problems);
        }
        resultMap.put(key, results);
    }

    @Override
    public boolean isEnabled(IBuildParticipant.BuildType type) {
        if (this.isRequired()) {
            return true;
        }
        if (type == IBuildParticipant.BuildType.RECONCILE) {
            return false;
        }
        if (!PlatformUtil.isMainProcess()) {
            try {
                ILocalBuildService localBuildService = this.getLocalBuildService();
                return localBuildService.getPreferenceBoolean(this.getPreferenceNode(), this.getId(), type == IBuildParticipant.BuildType.BUILD);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return this.getPreferenceBoolean(this.getEnablementPreferenceKey(type));
        }
        return false;
    }

    public ILocalBuildService getLocalBuildService() throws Exception {
        return IndexServicePlugin.getDefault().getLocalBuildService((BundleActivator)BuildPathCorePlugin.getDefault());
    }

    @Override
    public List<String> getFilters() {
        if (this.isRequired()) {
            return Collections.emptyList();
        }
        String rawFilters = "";
        if (!PlatformUtil.isMainProcess()) {
            try {
                ILocalBuildService localBuildService = this.getLocalBuildService();
                rawFilters = localBuildService.getPreferenceString(this.getPreferenceNode(), this.getId(), false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            rawFilters = this.getPreferenceString(this.getFiltersPreferenceKey());
        }
        if (StringUtil.isEmpty((String)rawFilters)) {
            return Collections.emptyList();
        }
        return Arrays.asList(filterSplitter.split(rawFilters));
    }
}

