/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.buildpath.core;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.IBuildPathContributor;
import com.aptana.buildpath.core.IBuildPathListener;
import com.aptana.buildpath.core.Messages;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ConfigurationElementDispatcher;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.osgi.framework.Bundle;

public class BuildPathManager {
    private static final String PROJECT_BUILD_PATH_PROPERTY_NAME = "projectBuildPath";
    private static final String NAME_AND_PATH_DELIMITER = "\t";
    private static final String BUILD_PATH_ENTRY_DELIMITER = "\u0000";
    private static final String BUILD_PATHS_ID = "buildPaths";
    private static final String ELEMENT_BUILD_PATH = "buildPath";
    private static final String ELEMENT_CONTRIBUTOR = "contributor";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_CLASS = "class";
    private static BuildPathManager instance;
    public Properties properties = BuildPathManager.loadConfig();
    private Set<BuildPathEntry> buildPaths;
    private List<IBuildPathContributor> contributors;
    private Set<IBuildPathListener> fListeners = null;

    public static synchronized BuildPathManager getInstance() {
        if (instance == null) {
            instance = new BuildPathManager();
            instance.loadExtension();
        }
        return instance;
    }

    private BuildPathManager() {
    }

    public static Properties loadConfig() {
        InputStream in = null;
        Properties p = new Properties();
        try {
            try {
                in = BuildPathManager.class.getResourceAsStream("jquerymd5.properties");
                if (in != null) {
                    p.load(in);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return p;
    }

    public void addBuildPath(BuildPathEntry entry) {
        if (entry != null) {
            if (this.buildPaths == null) {
                this.buildPaths = new HashSet<BuildPathEntry>();
            }
            this.buildPaths.add(entry);
        }
    }

    public void addBuildPath(IProject project, BuildPathEntry entry) {
        Set<BuildPathEntry> buildPaths;
        if (project != null && entry != null && !(buildPaths = this.getBuildPaths(project)).contains(entry)) {
            buildPaths.add(entry);
            this.setBuildPaths(project, buildPaths);
        }
    }

    public void addBuildPath(String displayName, URI path) {
        if (!StringUtil.isEmpty((String)displayName) && path != null) {
            this.addBuildPath(new BuildPathEntry(displayName, path));
        }
    }

    protected void addContributor(IBuildPathContributor contributor) {
        if (contributor != null) {
            if (this.contributors == null) {
                this.contributors = new ArrayList<IBuildPathContributor>();
            }
            this.contributors.add(contributor);
        }
    }

    public void removeBuildPathContributor(IProject project, List<BuildPathEntry> list) {
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (BuildPathEntry buildPathEntry : list) {
            uriList.add(buildPathEntry.getPath());
        }
        IndexPlugin.getDefault().getIndexManager().removeBuildPathContributor(project, uriList);
    }

    protected QualifiedName getBuildPathPropertyName() {
        return new QualifiedName("com.aptana.buildpath.core", PROJECT_BUILD_PATH_PROPERTY_NAME);
    }

    public Set<BuildPathEntry> getBuildPaths() {
        HashSet<BuildPathEntry> result = new HashSet<BuildPathEntry>();
        if (this.buildPaths != null) {
            result.addAll(this.buildPaths);
        }
        result.addAll(this.getDynamicBuildPaths());
        return result;
    }

    public Set<BuildPathEntry> getBuildPaths(URI projectURI) {
        File file = new File(projectURI);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(file.getName());
        return this.getBuildPaths(project);
    }

    public Set<BuildPathEntry> getBuildPaths(IProject project) {
        HashSet<BuildPathEntry> result;
        block12: {
            result = new HashSet<BuildPathEntry>();
            if (project == null || !project.exists()) {
                return result;
            }
            try {
                try {
                    String[] entries;
                    String property = project.getPersistentProperty(this.getBuildPathPropertyName());
                    if (property == null) break block12;
                    String[] stringArray = entries = property.split(BUILD_PATH_ENTRY_DELIMITER);
                    int n = entries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        String[] nameAndPath = entry.split(NAME_AND_PATH_DELIMITER);
                        if (nameAndPath.length >= 2) {
                            String name = nameAndPath[0];
                            String uri = nameAndPath[1];
                            try {
                                Set<BuildPathEntry> buildPathEntrys = this.getBuildPaths();
                                boolean isAdd = false;
                                for (BuildPathEntry buildPathEntry : buildPathEntrys) {
                                    if (!buildPathEntry.getDisplayName().equals(name)) continue;
                                    result.add(buildPathEntry);
                                    isAdd = true;
                                    break;
                                }
                                if (!isAdd) {
                                    URI path = new URI(uri);
                                    result.add(new BuildPathEntry(name, path));
                                }
                            }
                            catch (Exception e) {
                                String message = MessageFormat.format(Messages.BuildPathManager_UnableToConvertURI, uri, PROJECT_BUILD_PATH_PROPERTY_NAME, project.getName());
                                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (Throwable)e);
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    String message = MessageFormat.format(Messages.BuildPathManager_UnableToRetrievePersistenceProperty, PROJECT_BUILD_PATH_PROPERTY_NAME, project.getName());
                    IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (Throwable)e);
                    this.setBuildPaths(project, result);
                }
            }
            finally {
                this.setBuildPaths(project, result);
            }
        }
        return result;
    }

    private Set<BuildPathEntry> getDynamicBuildPaths() {
        Set<BuildPathEntry> result;
        if (this.contributors != null) {
            result = new HashSet();
            for (IBuildPathContributor contributor : this.contributors) {
                List<BuildPathEntry> files = contributor.getBuildPathEntries();
                if (files == null) continue;
                result.addAll(files);
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    public boolean hasBuildPath(BuildPathEntry entry) {
        return this.getBuildPaths().contains(entry);
    }

    public boolean hasBuildPath(IProject project, BuildPathEntry entry) {
        boolean result = false;
        if (project != null && entry != null) {
            Set<BuildPathEntry> buildPathSet = this.getBuildPaths(project);
            result = buildPathSet.contains(entry);
        }
        return result;
    }

    private void loadExtension() {
        ConfigurationElementDispatcher dispatcher = new ConfigurationElementDispatcher(new IConfigurationElementProcessor[]{new BuildPathProcessor(), new ContributorProcessor()});
        EclipseUtil.processConfigurationElements((String)"com.aptana.buildpath.core", (String)BUILD_PATHS_ID, (IConfigurationElementProcessor)dispatcher);
    }

    public void removeBuildPath(BuildPathEntry entry) {
        if (entry != null && this.buildPaths != null) {
            this.buildPaths.remove(entry);
        }
    }

    public void removeBuildPath(IProject project, BuildPathEntry entry) {
        Set<BuildPathEntry> entries;
        if (project != null && entry != null && (entries = this.getBuildPaths(project)).contains(entry)) {
            entries.remove(entry);
            this.setBuildPaths(project, entries);
        }
    }

    public void removeBuildPath(String displayName, URI path) {
        if (!StringUtil.isEmpty((String)displayName) && path != null) {
            this.removeBuildPath(new BuildPathEntry(displayName, path));
        }
    }

    public void setBuildPaths(URI projectURI, Collection<BuildPathEntry> entries) {
        File file = new File(projectURI);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(file.getName());
        this.setBuildPaths(project, entries);
    }

    public void setBuildPaths(IProject project, Collection<BuildPathEntry> entries) {
        if (project != null && entries != null && project.exists()) {
            ArrayList<String> nameAndPaths = new ArrayList<String>();
            for (BuildPathEntry entry : entries) {
                String nameAndPath = String.valueOf(entry.getDisplayName()) + NAME_AND_PATH_DELIMITER + entry.getPath();
                nameAndPaths.add(nameAndPath);
            }
            String value = StringUtil.join((String)BUILD_PATH_ENTRY_DELIMITER, nameAndPaths);
            try {
                project.setPersistentProperty(this.getBuildPathPropertyName(), value);
            }
            catch (CoreException e) {
                String message = MessageFormat.format(Messages.BuildPathManager_UnableToSetPersistenceProperty, PROJECT_BUILD_PATH_PROPERTY_NAME, project.getName());
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (Throwable)e);
            }
        }
        this.fireBuildPathChanged(project, entries, null);
    }

    public void fireBuildPathChanged(IProject project, Collection<BuildPathEntry> newEntries, Collection<BuildPathEntry> oldEntries) {
        if (CollectionsUtil.isNotEmpty(this.fListeners)) {
            for (IBuildPathListener listener : this.fListeners) {
                listener.buildPathChanged(project, newEntries, oldEntries);
            }
        }
    }

    public void addBuildPathListener(IBuildPathListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new HashSet<IBuildPathListener>();
        }
        this.fListeners.add(listener);
    }

    private class BuildPathProcessor
    implements IConfigurationElementProcessor {
        private BuildPathProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            IExtension extension = element.getDeclaringExtension();
            String pluginId = extension.getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)pluginId);
            String name = element.getAttribute(BuildPathManager.ATTR_NAME);
            String resource = element.getAttribute(BuildPathManager.ATTR_PATH);
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(resource), null);
            URI localFileURI = ResourceUtil.resourcePathToURI((URL)url);
            if (localFileURI != null) {
                BuildPathManager.this.addBuildPath(name, localFileURI);
            } else {
                String message = MessageFormat.format(Messages.BuildPathManager_UnableToConvertURLToURI, url.toString(), BuildPathManager.ELEMENT_BUILD_PATH, BuildPathManager.BUILD_PATHS_ID, pluginId);
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)message);
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{BuildPathManager.ELEMENT_BUILD_PATH});
        }
    }

    private class ContributorProcessor
    implements IConfigurationElementProcessor {
        private ContributorProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            try {
                Object contributor = element.createExecutableExtension(BuildPathManager.ATTR_CLASS);
                if (contributor instanceof IBuildPathContributor) {
                    BuildPathManager.this.addContributor((IBuildPathContributor)contributor);
                } else {
                    IExtension extension = element.getDeclaringExtension();
                    String pluginId = extension.getNamespaceIdentifier();
                    String message = MessageFormat.format(Messages.BuildPathManager_PathContributorIsWrongType, contributor.getClass().getName(), BuildPathManager.ELEMENT_CONTRIBUTOR, BuildPathManager.BUILD_PATHS_ID, pluginId);
                    IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)message);
                }
            }
            catch (CoreException coreException) {
                IExtension extension = element.getDeclaringExtension();
                String pluginId = extension.getNamespaceIdentifier();
                String message = MessageFormat.format(Messages.BuildPathManager_UnableToCreatePathContributor, BuildPathManager.ELEMENT_CONTRIBUTOR, BuildPathManager.BUILD_PATHS_ID, pluginId);
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)message);
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{BuildPathManager.ELEMENT_CONTRIBUTOR});
        }
    }
}

