/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile.externalcommand.preferences;

import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.precompile.externalcommand.command.ExternalCommand;
import com.pandora.precompile.externalcommand.command.ExternalCommandManager;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExternalCommandDetailsInDialog
extends TitleAreaDialog {
    private final int SEARCH_ID = 999;
    private Text inFileText;
    private Text argsText;
    private Text pathText;
    private Text workDirText;
    private final ExternalCommand toEditorCommand;
    private ExternalCommand result;

    public ExternalCommandDetailsInDialog(Shell parentShell, ExternalCommand command) {
        super(parentShell);
        this.toEditorCommand = command;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u9884\u7f16\u8bd1\u5668\u914d\u7f6e");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).create());
        Label lblNewLabel_1 = new Label(container, 0);
        lblNewLabel_1.setText("\u6587\u4ef6\u540e\u7f00:");
        lblNewLabel_1.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.inFileText = new Text(container, 2048);
        this.inFileText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label tmp = new Label(container, 0);
        tmp.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        tmp = new Label(container, 0);
        tmp.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        tmp = new Label(container, 0);
        tmp.setText("\u4f8b: .css ,\u591a\u4e2a\u540e\u7f00\u540d\u53ef\u4f7f\u7528\u9017\u53f7\u5206\u9694\uff0c\u5982\uff1a.css,.js");
        tmp.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        Label lblNewLabel_2 = new Label(container, 0);
        lblNewLabel_2.setText("\u89e6\u53d1\u547d\u4ee4\u5730\u5740:");
        lblNewLabel_2.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.pathText = new Text(container, 2048);
        this.pathText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Button fileButton = new Button(container, 0);
        fileButton.setText("...");
        fileButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExternalCommandDetailsInDialog.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.exe;*.bat;*.cmd;*.com", "*.*"});
                String dir = dialog.open();
                if (dir == null || dir.trim().equals("")) {
                    return;
                }
                ExternalCommandDetailsInDialog.this.pathText.setText(dir);
            }
        });
        lblNewLabel_2 = new Label(container, 0);
        lblNewLabel_2.setText("\u5de5\u4f5c\u76ee\u5f55:");
        lblNewLabel_2.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.workDirText = new Text(container, 2048);
        this.workDirText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.workDirText.setMessage("\u4e0d\u586b\u5199\u65f6\uff0c\u9ed8\u8ba4\u4e3a\u8c03\u7528\u9884\u7f16\u8bd1\u5668\u65f6\u6267\u884c\u4fdd\u5b58\u547d\u4ee4\u7684\u6587\u6863\u6240\u5728\u76ee\u5f55");
        fileButton = new Button(container, 0);
        fileButton.setText("...");
        fileButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ExternalCommandDetailsInDialog.this.getShell());
                String dir = dialog.open();
                if (dir == null || dir.trim().equals("")) {
                    return;
                }
                ExternalCommandDetailsInDialog.this.workDirText.setText(dir);
            }
        });
        Label lblNewLabel_3 = new Label(container, 0);
        lblNewLabel_3.setText("\u547d\u4ee4\u53c2\u6570:");
        lblNewLabel_3.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.argsText = new Text(container, 2048);
        this.argsText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        tmp = new Label(container, 0);
        tmp.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        tmp = new Label(container, 0);
        tmp.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Text text = new Text(container, 74);
        text.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        text.setText("\u73af\u5883\u53d8\u91cf\u8bf4\u660e:\r\n      %FileName%\uff1a\u8c03\u7528\u9884\u7f16\u8bd1\u5668\u65f6\u6267\u884c\u4fdd\u5b58\u547d\u4ee4\u7684\u6587\u6863\u7684\u6587\u4ef6\u540d\uff0c\u5982newfile.js\r\n      %FileBaseName%\uff1a\u6587\u6863\u4e0d\u5e26\u540e\u7f00\u7684\u6587\u4ef6\u540d\uff0c\u5982newfile\r\n      %FileDirName%\uff1a\u6587\u6863\u6240\u5728\u76ee\u5f55\u7684\u540d\u79f0\r\n      %ProjectDir%\uff1a\u6587\u6863\u6240\u5728\u9879\u76ee\u7684\u76ee\u5f55\r\n\u4e3e\u4f8b:\r\n      \u5e0c\u671b\u624b\u52a8\u4fdd\u5b58a.js\u65f6\uff0c\u5728\u5176\u540c\u7ea7\u76ee\u5f55\u901a\u8fc7uglifyjs\u81ea\u52a8\u538b\u7f29\u4e3aa.min.js\r\n      \u89e6\u53d1\u547d\u4ee4\u5730\u5740\u8f93\u5165\u5e94\u4e3a: uglifyjs.cmd\u7684\u7edd\u5bf9\u8def\u5f84\r\n      \u547d\u4ee4\u53c2\u6570\u5e94\u4e3a: %FileName% -o %FileBaseName%.min.js");
        this.setCommandInfo();
        this.addListeners();
        return area;
    }

    private void setCommandInfo() {
        ExternalCommand command = this.getCommand();
        if (command != null) {
            this.inFileText.setText(command.getInFileExtension());
            if (command.getArgs() != null) {
                this.argsText.setText(command.getArgs());
            }
            if (command.getPath() != null) {
                this.pathText.setText(command.getPath());
            }
            if (command.getWorkDir() != null) {
                this.workDirText.setText(command.getWorkDir());
            }
        }
    }

    protected ExternalCommand getCommand() {
        return this.toEditorCommand;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.validate();
        }
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        this.result = this.getCommand();
        if (this.result == null) {
            this.result = new ExternalCommand();
        }
        if (this.result != null) {
            this.result.setInFileExtension(this.inFileText.getText());
            this.result.setPath(this.pathText.getText());
            this.result.setArgs(this.argsText.getText());
            this.result.setWorkDir(this.workDirText.getText());
        }
        super.okPressed();
    }

    public ExternalCommand getResult() {
        return this.result;
    }

    protected void addListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalCommandDetailsInDialog.this.validate();
            }
        };
        this.inFileText.addModifyListener(modifyListener);
        this.pathText.addModifyListener(modifyListener);
        this.workDirText.addModifyListener(modifyListener);
    }

    private void validate() {
        boolean valid = this.isValid();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(valid);
        }
    }

    private boolean isValid() {
        boolean canSearch = true;
        String message = null;
        if (StringUtil.isBlank((String)this.inFileText.getText())) {
            message = "\u8bf7\u6307\u5b9a\u6587\u4ef6\u540e\u7f00\u540d";
            canSearch = false;
        } else if (!this.inFileText.getText().matches(",*\\.\\w+(,*\\.\\w+)*,*")) {
            message = "\u6587\u4ef6\u540e\u7f00\u540d\u683c\u5f0f\u4e0d\u6b63\u786e";
        } else if (StringUtil.isBlank((String)this.pathText.getText())) {
            message = "\u8bf7\u6307\u5b9a\u547d\u4ee4\u8def\u5f84";
        }
        this.getButton(999).setEnabled(canSearch);
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 999, "\u667a\u80fd\u5b8c\u6210(&A)", false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalCommandDetailsInDialog.this.searchPath();
            }
        });
        button.setToolTipText("\u6839\u636e\u8f93\u5165\u7684\u540e\u7f00\u540d\u5728\u5f53\u524d\u7cfb\u7edf\u7684\u73af\u5883\u53d8\u91cf\u4e2d\uff0c\u67e5\u627e\u5df2\u5b89\u88c5\u7684\u53ef\u7528\u7a0b\u5e8f\uff0c\u5e76\u81ea\u52a8\u586b\u5199\u76f8\u5173\u4fe1\u606f");
        this.createButton(parent, 0, String.valueOf(IDialogConstants.OK_LABEL) + "(&O)", true);
        this.createButton(parent, 1, String.valueOf(IDialogConstants.CANCEL_LABEL) + "(&C)", false);
    }

    private void searchPath() {
        List<ExternalCommand> defs = ExternalCommandManager.getInstance().getDefaultExternalCommands();
        String inFile = this.inFileText.getText();
        if (StringUtil.isNotBlank((String)inFile)) {
            inFile = inFile.split(",")[0];
            HashMap<String, String> defPathMap = new HashMap<String, String>();
            for (ExternalCommand def : defs) {
                if (!def.getInFileExtension().contains(inFile)) continue;
                String path = def.getPath();
                if (PlatformUtil.isMac() && path != null && (path.endsWith(".cmd") || path.endsWith(".bat"))) {
                    path = path.substring(0, path.length() - 4);
                }
                defPathMap.put(path, def.getArgs());
            }
            Set defPaths = defPathMap.keySet();
            for (String defPath : defPaths) {
                IPath path = ExecutableUtil.find((String)defPath, (boolean)false, null, (IPath)ResourcesPlugin.getWorkspace().getRoot().getFullPath());
                if (path == null) continue;
                this.pathText.setText(path.toOSString());
                if (StringUtil.isNotBlank((String)((String)defPathMap.get(defPath)))) {
                    this.argsText.setText((String)defPathMap.get(defPath));
                }
                return;
            }
        }
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    public boolean isHelpAvailable() {
        return false;
    }
}

