/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile.externalcommand.command;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.epl.IMemento;
import com.aptana.core.epl.XMLMemento;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.precompile.PreCompileActivator;
import com.pandora.precompile.externalcommand.command.ExternalCommand;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class ExternalCommandManager {
    public static final String STATE_FILENAME = "externalcommands";
    public static final String DEFAULT_FILENAME = "config/default_externalcommands.xml";
    private static final String ELEMENT_ROOT = "externalcommands";
    private static final String ELEMENT_COMMAND = "externalcommand";
    private static ExternalCommandManager externalCommandManager = new ExternalCommandManager();
    private List<ExternalCommand> allExternalCommands = new ArrayList<ExternalCommand>();
    private List<ExternalCommand> defExternalCommands = new ArrayList<ExternalCommand>();
    private File configFile;
    private boolean hasLoaded = false;

    private ExternalCommandManager() {
    }

    public static ExternalCommandManager getInstance() {
        if (!ExternalCommandManager.externalCommandManager.hasLoaded) {
            externalCommandManager.loadState();
        }
        return externalCommandManager;
    }

    public List<ExternalCommand> getAllExternalCommands() {
        return this.allExternalCommands;
    }

    public List<ExternalCommand> getEnabledExternalCommands() {
        return CollectionsUtil.filter(this.allExternalCommands, (IFilter)new IFilter<ExternalCommand>(){

            public boolean include(ExternalCommand item) {
                return item != null && item.isEnable() && StringUtil.isNotBlank((String)item.getPath());
            }
        });
    }

    public Set<ExternalCommand> getDefaultExternalCommandsClone() {
        List list = CollectionsUtil.map(this.defExternalCommands, (IMap)new IMap<ExternalCommand, ExternalCommand>(){

            public ExternalCommand map(ExternalCommand item) {
                try {
                    return (ExternalCommand)BeanUtils.cloneBean((Object)item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return new HashSet<ExternalCommand>(list);
    }

    public List<ExternalCommand> getDefaultExternalCommands() {
        return this.defExternalCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalCommands(ExternalCommand externalCommand) {
        List<ExternalCommand> list = this.allExternalCommands;
        synchronized (list) {
            if (!this.allExternalCommands.contains(externalCommand)) {
                this.allExternalCommands.remove(externalCommand);
            }
            this.allExternalCommands.add(externalCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDefaultExternalCommands() {
        List<ExternalCommand> list = this.allExternalCommands;
        synchronized (list) {
            this.allExternalCommands.clear();
            this.addDefaultExternalCommands();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultExternalCommands() {
        List<ExternalCommand> list = this.allExternalCommands;
        synchronized (list) {
            this.addExternalCommands(new ExternalCommand(true, ".css"));
            this.addExternalCommands(new ExternalCommand(true, ".coffee"));
            this.addExternalCommands(new ExternalCommand(true, ".haml"));
            this.addExternalCommands(new ExternalCommand(true, ".js"));
            this.addExternalCommands(new ExternalCommand(true, ".less"));
            this.addExternalCommands(new ExternalCommand(true, ".sass,.scss"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalCommands(ExternalCommand externalCommand) {
        List<ExternalCommand> list = this.allExternalCommands;
        synchronized (list) {
            this.allExternalCommands.remove(externalCommand);
        }
    }

    public synchronized void loadState() {
        if (this.hasLoaded) {
            return;
        }
        this.hasLoaded = true;
        File xmlFile = this.getConfigFile();
        if (!xmlFile.exists()) {
            try {
                File[] oldFiles = xmlFile.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("externalcommands.");
                    }
                });
                if (oldFiles != null && oldFiles.length > 0) {
                    FileUtils.copyFile((File)oldFiles[0], (File)xmlFile);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
            }
        }
        this.loadState(xmlFile, this.allExternalCommands);
        try {
            URL url = FileLocator.find((Bundle)PreCompileActivator.getDefault().getBundle(), (IPath)new Path(DEFAULT_FILENAME), null);
            this.loadState(new File(FileLocator.toFileURL((URL)url).getFile()), this.defExternalCommands);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
        }
        if (this.allExternalCommands.isEmpty()) {
            try {
                this.addDefaultExternalCommands();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
            }
        }
    }

    private void loadState(File file, List<ExternalCommand> list) {
        block7: {
            if (file.exists()) {
                FileReader reader = null;
                try {
                    try {
                        reader = new FileReader(file);
                        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                        IMemento[] iMementoArray = memento.getChildren(ELEMENT_COMMAND);
                        int n = iMementoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemento child = iMementoArray[n2];
                            list.add(new ExternalCommand(child));
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                        IOUtils.closeQuietly((Reader)reader);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveState() {
        block9: {
            File path = this.getConfigFile();
            XMLMemento memento = XMLMemento.createWriteRoot((String)"externalcommands");
            List<ExternalCommand> list = this.allExternalCommands;
            synchronized (list) {
                for (ExternalCommand externalCommand : this.allExternalCommands) {
                    IMemento child = memento.createChild(ELEMENT_COMMAND);
                    externalCommand.saveState(child);
                }
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path);
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                    IOUtils.closeQuietly((Writer)writer);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private File getConfigFile() {
        if (this.configFile == null) {
            this.configFile = PreCompileActivator.getDefault().getStateLocation().append("externalcommands").addFileExtension("xml").makeAbsolute().toFile();
        }
        return this.configFile;
    }
}

