/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile.externalcommand;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import com.pandora.precompile.PreCompileActivator;
import com.pandora.precompile.PreCompileProblem;
import com.pandora.precompile.compiler.AbstractCompiler;
import com.pandora.precompile.externalcommand.command.ExternalCommand;
import com.pandora.precompile.externalcommand.command.ExternalCommandManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ExternalCommandCompiler
extends AbstractCompiler {
    public static final String VAR_ProjectDir = "%ProjectDir%";
    public static final String VAR_FileDirName = "%FileDirName%";
    public static final String VAR_FileName = "%FileName%";
    public static final String VAR_FileNameWithoutExtension = "%FileBaseName%";
    public static final String VAR_FullPath = "%FULLPATH%";

    @Override
    public boolean match(IFile file) {
        List<ExternalCommand> enables = ExternalCommandManager.getInstance().getEnabledExternalCommands();
        for (ExternalCommand externalCommand : enables) {
            if (!externalCommand.match(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<PreCompileProblem> compiler(IFile file) throws CoreException {
        List<ExternalCommand> enables = ExternalCommandManager.getInstance().getEnabledExternalCommands();
        ArrayList<PreCompileProblem> errors = new ArrayList<PreCompileProblem>();
        if (!file.exists()) {
            return errors;
        }
        IContainer parent = file.getParent();
        IProject project = file.getProject();
        String varFileName = file.getName();
        String varFileDirName = project.getName();
        String varFileNameWithoutExtension = file.getName().substring(0, file.getName().lastIndexOf("."));
        String varFullpath = file.getLocation().toFile().getAbsolutePath();
        String varProjectdir = project.getLocation().toFile().getAbsolutePath();
        Map varValueMap = CollectionsUtil.newMap((Object[])new String[]{VAR_ProjectDir, varProjectdir, VAR_FileDirName, varFileDirName, VAR_FileName, varFileName, VAR_FileNameWithoutExtension, varFileNameWithoutExtension, VAR_FullPath, varFullpath});
        for (ExternalCommand externalCommand : enables) {
            String workDir;
            boolean match = externalCommand.match(file);
            if (!match) continue;
            String exePath = externalCommand.getPath();
            boolean isJava = false;
            if (exePath != null) {
                String tmp = exePath.trim().toLowerCase();
                isJava = tmp.endsWith(".jar");
                if (isJava && tmp.indexOf("java -jar ") < 0) {
                    exePath = PlatformUtil.isWindows() ? "cmd /c java -jar \"" + exePath + "\"" : "java -jar \"" + exePath + "\"";
                }
                for (String var : varValueMap.keySet()) {
                    exePath = exePath.replace(var, (CharSequence)varValueMap.get(var));
                }
            }
            if (StringUtil.isNotBlank((String)(workDir = externalCommand.getWorkDir()))) {
                for (String var : varValueMap.keySet()) {
                    workDir = workDir.replace(var, (CharSequence)varValueMap.get(var));
                }
            } else {
                workDir = parent.getLocation().toFile().getAbsolutePath();
            }
            Object[] args = new String[]{};
            if (StringUtil.isNotBlank((String)externalCommand.getArgs())) {
                String argStr = externalCommand.getArgs();
                for (String var : varValueMap.keySet()) {
                    argStr = argStr.replace(var, (CharSequence)varValueMap.get(var));
                }
                args = argStr.split(" ");
            }
            HashSet<IFile> files = new HashSet<IFile>();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = objectArray[n2];
                if (!StringUtil.isBlank((String)arg)) {
                    try {
                        IFile ifile = null;
                        if (arg.startsWith(varProjectdir)) {
                            ifile = project.getFile(arg.substring(varProjectdir.length()));
                        } else if (parent == project) {
                            ifile = project.getFile(arg);
                        } else if (parent instanceof IFolder) {
                            ifile = ((IFolder)parent).getFile(arg);
                        }
                        if (ifile != null) {
                            files.add(ifile);
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                    }
                }
                ++n2;
            }
            IStatus s = null;
            if (!isJava) {
                if (PlatformUtil.isMac()) {
                    HashMap<String, String> env = new HashMap<String, String>(System.getenv());
                    String path = (String)env.get("PATH");
                    path = String.valueOf(path) + ":/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/sbin".replace(':', File.pathSeparatorChar);
                    env.put("PATH", path);
                    s = ProcessUtil.runInBackground((String)exePath, (IPath)new Path(workDir), env, (String[])args);
                } else {
                    s = ProcessUtil.runInBackground((String)exePath, (IPath)new Path(workDir), System.getenv(), (String[])args);
                }
            } else {
                List command = CollectionsUtil.newList((Object[])args);
                command.add(0, exePath);
                try {
                    Process process = Runtime.getRuntime().exec(StringUtil.join((String)" ", (Collection)command), null, new File(file.getParent().getLocation().toOSString()));
                    s = ProcessUtil.processResult((Process)process);
                }
                catch (Exception e) {
                    s = new Status(4, "com.pandora.precompile", e.getMessage(), (Throwable)e);
                }
            }
            if (!s.isOK()) {
                errors.add(new PreCompileProblem(s.getMessage().replaceAll("\u001b\\[\\d*m", "")));
                continue;
            }
            for (IFile ifile : files) {
                if (ifile.exists()) continue;
                try {
                    ifile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                }
            }
        }
        return errors;
    }

    @Override
    public void delete(IFile file) throws CoreException {
    }

    protected final IFile getPreCompiledFile(IFile file, String outFileName) {
        String newName = outFileName.replace(VAR_FileName, file.getName()).replace(VAR_FileNameWithoutExtension, file.getName().substring(0, file.getName().lastIndexOf(".")));
        return file.getParent().getFile((IPath)new Path(newName));
    }
}

