/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile.compiler;

import com.aptana.core.logging.IdeLog;
import com.aptana.scripting.ui.ScriptingConsole;
import com.pandora.core.CoreActivator;
import com.pandora.core.utils.RegistryUtils;
import com.pandora.precompile.IFilePreCompiler;
import com.pandora.precompile.PreCompileActivator;
import com.pandora.precompile.PreCompileProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public class AutoPreCompiler {
    private static List<IFilePreCompiler> compilers = new ArrayList<IFilePreCompiler>();
    private static AutoPreCompiler autoPreCompiler = null;
    private static boolean inited;

    private AutoPreCompiler() {
    }

    public static AutoPreCompiler getInstance() {
        if (autoPreCompiler == null) {
            autoPreCompiler = new AutoPreCompiler();
        }
        return autoPreCompiler;
    }

    private void initRegistryForStats() {
        if (compilers.isEmpty()) {
            try {
                List lists = RegistryUtils.getEp(IFilePreCompiler.class, (String)"com.pandora.precompile.filecompile", (String)"compiler", (String)"class");
                if (lists != null && !lists.isEmpty()) {
                    compilers.addAll(lists);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CoreActivator.getDefault(), (Throwable)e);
            }
        }
    }

    public void buildFile(IFile file) {
        if (!inited) {
            inited = true;
            this.initRegistryForStats();
        }
        if (!file.exists()) {
            this.deleteFile(file);
        } else {
            this.compileFile(file);
        }
    }

    public int getCompilerSize() {
        return compilers != null ? compilers.size() : 0;
    }

    private void deleteFile(IFile file) {
        for (IFilePreCompiler fileCompiler : compilers) {
            try {
                if (!fileCompiler.match(file)) continue;
                fileCompiler.delete(file);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                this.console(true, "\u5220\u9664(" + file.getFullPath().toOSString() + ")\u81ea\u52a8\u7f16\u8bd1\u751f\u6210\u7684\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
            }
        }
    }

    private void compileFile(IFile file) {
        for (IFilePreCompiler fileCompiler : compilers) {
            try {
                Collection<PreCompileProblem> result;
                if (!fileCompiler.match(file) || (result = fileCompiler.compiler(file)) == null || result.isEmpty()) continue;
                this.console(true, "\u81ea\u52a8\u7f16\u8bd1(" + file.getFullPath().toOSString() + ")\u5931\u8d25\uff1a");
                this.console(false, this.format(result));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                this.console(true, "\u81ea\u52a8\u7f16\u8bd1(" + file.getFullPath().toOSString() + ")\u5931\u8d25\uff1a");
                this.console(false, e.getMessage());
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
            }
        }
    }

    private void console(boolean isError, String message) {
        ScriptingConsole.getInstance().activate();
        if (isError) {
            ScriptingConsole.getInstance().getErrorConsoleStream().println(message);
        } else {
            ScriptingConsole.getInstance().getOutputConsoleStream().println(message);
        }
    }

    private String format(Collection<PreCompileProblem> warnings) {
        if (warnings == null || warnings.isEmpty()) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (PreCompileProblem warning : warnings) {
            if (warning.isFormat()) {
                s.append("   on line ").append(warning.getLine()).append(", column ").append(warning.getCharacter()).append(": ");
            }
            s.append(warning.getMessage()).append("\r\n");
        }
        return s.toString();
    }
}

