/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.internal.save.EditorSaveEvent;
import com.aptana.editor.common.internal.save.EditorSaveManager;
import com.aptana.editor.common.internal.save.IEditorSaveListener;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.precompile.PreCompileActivator;
import com.pandora.precompile.compiler.AutoPreCompiler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStartup;

public class Startup
implements IStartup {
    public void earlyStartup() {
        Job job = new Job("load ExternalCommand Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.pandora.precompile");
                    boolean added = prefs.getBoolean("addDefaultExternalTools", false);
                    if (!added) {
                        Startup.this.addDefaultExternalTools();
                        prefs.putBoolean("addDefaultExternalTools", true);
                        prefs.flush();
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        this.addFileChangeListener();
    }

    private void addFileChangeListener() {
        EditorSaveManager.getInstance().addEditorSaveListener(new IEditorSaveListener(){

            public void editorSaveEvent(EditorSaveEvent event) {
                IFile file;
                IEditorInput input;
                Object source;
                if (event.getKind() == 2 && (source = event.getSource()) instanceof IEditorPart && (input = ((IEditorPart)source).getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()).exists()) {
                    Job build = new Job("\u4fdd\u5b58\u89e6\u53d1\u5668"){

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask("\u6b63\u5728\u7f16\u8bd1", 2);
                            monitor.worked(1);
                            AutoPreCompiler.getInstance().buildFile(file);
                            monitor.setTaskName("\u6b63\u5728\u7f16\u8bd1" + file.getFullPath());
                            monitor.worked(1);
                            return Status.OK_STATUS;
                        }
                    };
                    build.setRule((ISchedulingRule)new AutoPreCompileJobRule());
                    build.schedule();
                }
            }
        });
    }

    private void addDefaultExternalTools() {
        ILaunchConfigurationWorkingCopy wc;
        String name;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            name = "\u793a\u4f8b-\u663e\u793a\u6587\u4ef6\u8def\u5f84";
            if (!manager.isExistingLaunchConfigurationName(name)) {
                wc = configType.newInstance(null, manager.generateLaunchConfigurationName(name));
                wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "echo");
                wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "\u6587\u4ef6\u540d:  ${resource_name} \n& echo \u6587\u4ef6\u8def\u5f84:  ${resource_loc} \n& echo \u6587\u4ef6\u6240\u5728\u76ee\u5f55:  ${container_loc} \n& echo \u6587\u4ef6\u6240\u5728\u9879\u76ee\u8def\u5f84:  ${project_loc}");
                wc.setAttribute("org.eclipse.ui.externaltools.ATTR_COMMAND_ID", "org.eclipse.ui.externaltools." + System.currentTimeMillis());
                if (PlatformUtil.isWindows()) {
                    wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "GB2312");
                }
                wc.doSave();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
        }
        try {
            name = "\u793a\u4f8b-\u6253\u5f00\u6587\u4ef6\u6240\u5728\u76ee\u5f55";
            if (!manager.isExistingLaunchConfigurationName(name)) {
                wc = configType.newInstance(null, manager.generateLaunchConfigurationName(name));
                if (PlatformUtil.isWindows()) {
                    wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "C:\\WINDOWS\\system32\\explorer.exe");
                    wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "/select,\"${resource_loc}\"");
                    wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", "GB2312");
                } else {
                    wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", "/usr/bin/open");
                    wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", "-R ${resource_loc}");
                }
                wc.setAttribute("org.eclipse.ui.externaltools.ATTR_COMMAND_ID", "org.eclipse.ui.externaltools." + System.currentTimeMillis());
                wc.doSave();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
        }
    }

    private class AutoPreCompileJobRule
    implements ISchedulingRule {
        private AutoPreCompileJobRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule || rule instanceof IResource;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (this == rule) {
                return true;
            }
            return rule instanceof AutoPreCompileJobRule;
        }
    }
}

