/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.haml;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.MultiCharacterRule;
import com.aptana.editor.common.text.rules.SingleCharacterRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.haml.internal.HAMLElementScanner;
import com.aptana.editor.haml.internal.HAMLSubPartitionScanner;
import com.aptana.editor.haml.internal.RubyAttributesSourceConfiguration;
import com.aptana.editor.haml.internal.text.rules.HAMLElementRule;
import com.aptana.editor.haml.internal.text.rules.HAMLEscapeRule;
import com.aptana.editor.haml.internal.text.rules.HAMLSingleLineRule;
import com.aptana.editor.haml.internal.text.rules.RubyEvaluationElementRule;
import com.aptana.editor.ruby.RubySourceConfiguration;
import java.util.List;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;

public class HAMLSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    private static final String PREFIX = "__haml_";
    public static final String DEFAULT = "__haml___dftl_partition_content_type";
    public static final String DOCTYPE = "__haml_doctype";
    public static final String ELEMENT = "__haml_element";
    public static final String RUBY_EVALUATION = "__haml_ruby_evaluation";
    public static final String RUBY_ATTRIBUTES = "__haml_ruby_attributes";
    public static final String RUBY_ATTRIBUTES_CLOSE = "__haml_ruby_attributes_close";
    public static final String HTML_ATTRIBUTES = "__haml_html_attributes";
    public static final String OBJECT = "__haml_object";
    public static final String INTERPOLATION = "__haml_interpolation";
    public static final String HTML_COMMENT = "__haml_html_comment";
    public static final String HAML_COMMENT = "__haml_haml_comment";
    public static final String[] CONTENT_TYPES = new String[]{"__haml___dftl_partition_content_type", "__haml_html_comment", "__haml_haml_comment", "__haml_doctype", "__haml_element", "__haml_interpolation", "__haml_ruby_evaluation", "__haml_html_attributes", "__haml_ruby_attributes", "__haml_ruby_attributes_close", "__haml_object"};
    private static final String[] SPELLING_CONTENT_TYPES = new String[]{"__haml___dftl_partition_content_type", "__haml_html_comment", "__haml_haml_comment"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.haml"}, {"com.aptana.contenttype.haml", "com.aptana.contenttype.ruby"}};
    private final IPredicateRule[] partitioningRules = new IPredicateRule[]{new HAMLSingleLineRule("/", HAMLSourceConfiguration.getToken("__haml_html_comment")), new HAMLSingleLineRule("-#", HAMLSourceConfiguration.getToken("__haml_haml_comment")), new HAMLSingleLineRule("!!!", HAMLSourceConfiguration.getToken("__haml_doctype")), new HAMLEscapeRule(HAMLSourceConfiguration.getToken("")), new SingleLineRule("#{", "}", HAMLSourceConfiguration.getToken("__haml_interpolation")), new HAMLElementRule(HAMLSourceConfiguration.getToken("__haml_element")), new RubyEvaluationElementRule((IToken)new Token((Object)"__haml_ruby_evaluation")), new SingleCharacterRule('{', HAMLSourceConfiguration.getToken("__haml_ruby_attributes")), new SingleCharacterRule('}', HAMLSourceConfiguration.getToken("__haml_ruby_attributes_close")), new SingleLineRule("[", "]", HAMLSourceConfiguration.getToken("__haml_object")), new MultiLineRule("(", ")", HAMLSourceConfiguration.getToken("__haml_html_attributes"))};
    private static HAMLSourceConfiguration instance;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.haml"}), new QualifiedContentType(new String[]{"text.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{HAML_COMMENT}), new QualifiedContentType(new String[]{"meta.line.ruby.haml source.ruby.embedded.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_COMMENT}), new QualifiedContentType(new String[]{"comment.line.slash.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{DOCTYPE}), new QualifiedContentType(new String[]{"meta.prolog.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{ELEMENT}), new QualifiedContentType(new String[]{"meta.tag.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_ATTRIBUTES}), new QualifiedContentType(new String[]{"meta.section.attributes.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{RUBY_ATTRIBUTES}), new QualifiedContentType(new String[]{"meta.section.attributes.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{RUBY_EVALUATION}), new QualifiedContentType(new String[]{"meta.line.ruby.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{OBJECT}), new QualifiedContentType(new String[]{"meta.section.object.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{INTERPOLATION}), new QualifiedContentType(new String[]{"meta.section.other.haml"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.haml", "com.aptana.contenttype.ruby"}), new QualifiedContentType(new String[]{"text.haml", "meta.line.ruby.haml", "source.ruby.embedded.haml"}));
    }

    public static synchronized HAMLSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new HAMLSourceConfiguration();
        }
        return instance;
    }

    private HAMLSourceConfiguration() {
    }

    public String[] getContentTypes() {
        return TextUtils.combine((String[][])new String[][]{CONTENT_TYPES, RubySourceConfiguration.CONTENT_TYPES, RubyAttributesSourceConfiguration.CONTENT_TYPES});
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public String[] getSpellingContentTypes() {
        return SPELLING_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new HAMLSubPartitionScanner();
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.haml";
        }
        String result = RubySourceConfiguration.getDefault().getDocumentContentType(contentType);
        if (result != null) {
            return result;
        }
        result = RubyAttributesSourceConfiguration.getDefault().getDocumentContentType(contentType);
        if (result != null) {
            return result;
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        RubySourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        RubyAttributesSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getHTMLCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, HTML_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getHAMLCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, HAML_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, HAML_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getDocTypeScanner());
        reconciler.setDamager((IPresentationDamager)dr, DOCTYPE);
        reconciler.setRepairer((IPresentationRepairer)dr, DOCTYPE);
        dr = new ThemeingDamagerRepairer(this.getElementScanner());
        reconciler.setDamager((IPresentationDamager)dr, ELEMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, ELEMENT);
        dr = new ThemeingDamagerRepairer(this.getInterpolationScanner());
        reconciler.setDamager((IPresentationDamager)dr, INTERPOLATION);
        reconciler.setRepairer((IPresentationRepairer)dr, INTERPOLATION);
        dr = new ThemeingDamagerRepairer(this.getObjectScanner());
        reconciler.setDamager((IPresentationDamager)dr, OBJECT);
        reconciler.setRepairer((IPresentationRepairer)dr, OBJECT);
        dr = new ThemeingDamagerRepairer(this.getHTMLAttributesScanner());
        reconciler.setDamager((IPresentationDamager)dr, HTML_ATTRIBUTES);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_ATTRIBUTES);
        dr = new ThemeingDamagerRepairer(this.getRubyEvaluationScanner());
        reconciler.setDamager((IPresentationDamager)dr, RUBY_EVALUATION);
        reconciler.setRepairer((IPresentationRepairer)dr, RUBY_EVALUATION);
    }

    protected ITokenScanner getRubyEvaluationScanner() {
        return new SingleTokenScanner(HAMLSourceConfiguration.getToken(""));
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return null;
    }

    private ITokenScanner getTextScanner() {
        RuleBasedScanner textScanner = new RuleBasedScanner();
        textScanner.setRules(new IRule[]{new CharacterMapRule().add('/', HAMLSourceConfiguration.getToken("punctuation.terminator.tag.haml")).add('/', HAMLSourceConfiguration.getToken("punctuation.terminator.tag.haml")).add('>', HAMLSourceConfiguration.getToken("punctuation.other.tag.haml")).add('<', HAMLSourceConfiguration.getToken("punctuation.other.tag.haml")).add('&', HAMLSourceConfiguration.getToken("punctuation.other.tag.haml")).add('!', HAMLSourceConfiguration.getToken("punctuation.other.tag.haml")), new HAMLEscapeRule(HAMLSourceConfiguration.getToken("meta.escape.haml"))});
        textScanner.setDefaultReturnToken(HAMLSourceConfiguration.getToken("text.haml"));
        return textScanner;
    }

    private ITokenScanner getElementScanner() {
        return new HAMLElementScanner();
    }

    private ITokenScanner getInterpolationScanner() {
        RuleBasedScanner interpolationScanner = new RuleBasedScanner();
        interpolationScanner.setRules(new IRule[]{new MultiCharacterRule("#{", HAMLSourceConfiguration.getToken("punctuation.section.embedded.ruby")), new SingleCharacterRule('}', HAMLSourceConfiguration.getToken("punctuation.section.embedded.ruby"))});
        interpolationScanner.setDefaultReturnToken(HAMLSourceConfiguration.getToken("source.ruby.embedded.source"));
        return interpolationScanner;
    }

    private ITokenScanner getObjectScanner() {
        RuleBasedScanner objectScanner = new RuleBasedScanner();
        objectScanner.setRules(new IRule[]{new CharacterMapRule().add('[', HAMLSourceConfiguration.getToken("punctuation.section.other.haml")).add(']', HAMLSourceConfiguration.getToken("punctuation.section.other.haml"))});
        objectScanner.setDefaultReturnToken(HAMLSourceConfiguration.getToken("meta.section.object.haml"));
        return objectScanner;
    }

    private ITokenScanner getHTMLAttributesScanner() {
        RuleBasedScanner htmlAttributesScanner = new RuleBasedScanner();
        htmlAttributesScanner.setRules(new IRule[]{new CharacterMapRule().add('(', HAMLSourceConfiguration.getToken("punctuation.section.other.haml")).add(')', HAMLSourceConfiguration.getToken("punctuation.section.other.haml"))});
        htmlAttributesScanner.setDefaultReturnToken(HAMLSourceConfiguration.getToken("meta.section.object.haml"));
        return htmlAttributesScanner;
    }

    private ITokenScanner getHTMLCommentScanner() {
        Object commentScanner = new RuleBasedScanner();
        commentScanner = new CommentScanner(HAMLSourceConfiguration.getToken("comment.line.slash.haml")){

            protected List<IRule> createRules() {
                List rules = super.createRules();
                rules.add(new SingleCharacterRule('/', HAMLSourceConfiguration.getToken("punctuation.section.comment.haml")));
                return rules;
            }
        };
        return commentScanner;
    }

    private ITokenScanner getHAMLCommentScanner() {
        return new CommentScanner(HAMLSourceConfiguration.getToken("comment.line.number-sign.ruby"));
    }

    private ITokenScanner getDocTypeScanner() {
        RuleBasedScanner docTypeScanner = new RuleBasedScanner();
        docTypeScanner.setRules(new IRule[]{new SingleCharacterRule('!', HAMLSourceConfiguration.getToken("punctuation.definition.prolog.haml"))});
        docTypeScanner.setDefaultReturnToken(HAMLSourceConfiguration.getToken("meta.prolog.haml"));
        return docTypeScanner;
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

