/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.haml;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.haml.HAMLEditorPlugin;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class HAMLAutoIndentStrategy
extends RubyRegexpAutoIndentStrategy {
    private static final String TAG_OR_FILTER_ONLY = "^\\s*[%:](\\w|\\.|#)+";
    private static final Pattern BEGIN_WITH_TAG_OR_FILTER = Pattern.compile("^\\s*[%:](?!area|base|br|col|hr|img|input|link|meta|param)(\\w|\\.)+.*$");
    private static final Pattern ATTRIBUTE = Pattern.compile("^\\s*\\{.*\\}\\s*$");

    public HAMLAutoIndentStrategy(String contentType, SourceViewerConfiguration configuration, ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        super(contentType, configuration, sourceViewer, prefStore);
    }

    protected boolean autoIndent(IDocument d, DocumentCommand c) {
        if (c.offset <= 0 || d.getLength() == 0 || !this.shouldAutoIndent()) {
            return false;
        }
        String newline = c.text;
        try {
            String contentWithoutTagFilter;
            IRegion curLineRegion = d.getLineInformationOfOffset(c.offset);
            String lineContent = d.get(curLineRegion.getOffset(), c.offset - curLineRegion.getOffset()).trim();
            boolean shouldAutoIndent = false;
            if (lineContent.length() > 1 && lineContent.charAt(0) == '-' && lineContent.endsWith("|")) {
                shouldAutoIndent = true;
            } else if (BEGIN_WITH_TAG_OR_FILTER.matcher(lineContent).matches() && !lineContent.endsWith("/") && (StringUtil.isEmpty((String)(contentWithoutTagFilter = lineContent.replaceAll(TAG_OR_FILTER_ONLY, ""))) || ATTRIBUTE.matcher(contentWithoutTagFilter).matches())) {
                shouldAutoIndent = true;
            }
            if (shouldAutoIndent) {
                String previousLineIndent = this.getAutoIndentAfterNewLine(d, c, true);
                String restOfLine = d.get(c.offset, curLineRegion.getLength() - (c.offset - curLineRegion.getOffset()));
                String startIndent = String.valueOf(newline) + previousLineIndent + this.getIndentString();
                c.text = this.indentAndPushTrailingContentAfterNewlineAndCursor(lineContent, restOfLine) ? String.valueOf(startIndent) + newline + previousLineIndent : startIndent;
                c.shiftsCaret = false;
                c.caretOffset = c.offset + startIndent.length();
                return true;
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HAMLEditorPlugin.getDefault(), (Throwable)e);
        }
        return false;
    }
}

