/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.ContainerSelectionGroup;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class SaveAsDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "SaveAsDialogSettings";
    private IFile originalFile = null;
    private String originalName = null;
    private IPath result;
    private boolean isLocalFile;
    private ResourceAndContainerGroup resourceGroup;
    private Text resourcePathField;
    private Button okButton;
    private String extend = null;
    private String[] extensions = new String[]{"HTML (.html)", "JavaScript (.js)", "CSS (.css)", "JSON (.json)", "Text (.txt)", "PHP (.php)", "Sass (.sass)", "Less (.less)", "Markdown (.md)", "XML (.xml)", "JSP (.jsp)", "ASP (.asp)", "CoffeeScript (.coffee)", "Ruby (.rb)", "ASPX (.aspx)", "HAML (.haml)", "RHTML (.rhtml)", "RXML (.rxml)", "SVG (.svg)", "YAML (.yaml)", "DTD (.dtd)"};
    private Image dlgTitleImage = null;

    public SaveAsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IDEWorkbenchMessages.SaveAsDialog_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.save_as_dialog_context");
    }

    protected Control createContents(Composite parent) {
        this.extend = null;
        Control contents = super.createContents(parent);
        this.initializeControls();
        this.validatePage();
        this.resourceGroup.setFocus();
        this.setTitle(IDEWorkbenchMessages.SaveAsDialog_title);
        ImageDescriptor descriptor = IDEInternalWorkbenchImages.getImageDescriptor("IMG_DLGBAN_SAVEAS_DLG");
        if (descriptor != null) {
            this.dlgTitleImage = descriptor.createImage();
            this.setTitleImage(this.dlgTitleImage);
        }
        this.setMessage(IDEWorkbenchMessages.SaveAsDialog_message);
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parentComposite.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                String fPath;
                Text t;
                Widget w = event.widget;
                if (w instanceof ContainerSelectionGroup) {
                    ContainerSelectionGroup c = (ContainerSelectionGroup)w;
                    IPath path = c.getContainerFullPath();
                    if (path != null) {
                        String fPath2 = null;
                        fPath2 = path.toOSString();
                        if (path.isRoot()) {
                            SaveAsDialog.this.resourcePathField.setText(fPath2);
                        } else {
                            String name = path.segment(0);
                            fPath2 = fPath2.substring(fPath2.indexOf(name) + name.length());
                            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                            if (project.exists()) {
                                fPath2 = String.valueOf(project.getLocation().toOSString()) + fPath2;
                                SaveAsDialog.this.resourcePathField.setText(fPath2);
                            }
                        }
                    }
                } else if (w instanceof Text && (t = (Text)w).getParent() instanceof ContainerSelectionGroup && (fPath = t.getText()) != null && fPath.length() > 0) {
                    IPath path = new Path(TextProcessor.deprocess((String)fPath)).makeAbsolute();
                    fPath = path.toOSString();
                    String name = path.segment(0);
                    fPath = fPath.substring(fPath.indexOf(name) + name.length());
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                    if (project.exists()) {
                        fPath = String.valueOf(project.getLocation().toOSString()) + fPath;
                        SaveAsDialog.this.resourcePathField.setText(fPath);
                    }
                }
                SaveAsDialog.this.setDialogComplete(SaveAsDialog.this.validatePage());
            }
        };
        this.resourceGroup = new ResourceAndContainerGroup(composite, listener, IDEWorkbenchMessages.SaveAsDialog_fileLabel, IDEWorkbenchMessages.SaveAsDialog_file);
        this.resourceGroup.setAllowExistingResources(true);
        this.createExtendFiled(composite);
        this.createPathFiled(composite);
        return parentComposite;
    }

    private void createExtendFiled(Composite composite) {
        Font font = composite.getFont();
        Composite extendGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        extendGroup.setLayout((Layout)layout);
        extendGroup.setLayoutData((Object)new GridData(768));
        extendGroup.setFont(font);
        Label label = new Label(extendGroup, 0);
        label.setText("\u4fdd\u5b58\u7c7b\u578b\uff1a");
        label.setFont(font);
        final Combo combo = new Combo(extendGroup, 8);
        combo.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        combo.setFont(font);
        String editorName = this.getEditorLabel();
        int index = -1;
        String prefix = null;
        int select = -1;
        String resourceText = this.resourceGroup.getResource();
        int resourceIndex = -1;
        String resourceExtend = null;
        if (resourceText != null) {
            resourceIndex = resourceText.lastIndexOf(".");
            if (resourceIndex > -1) {
                resourceExtend = resourceText.substring(resourceIndex);
            } else {
                resourceText = this.getResourceName();
                if (resourceText != null && (resourceIndex = resourceText.lastIndexOf(".")) > -1) {
                    resourceExtend = resourceText.substring(resourceIndex);
                }
            }
        }
        int i = 0;
        while (i < this.extensions.length) {
            String extendType = this.extensions[i];
            index = extendType.indexOf("(");
            if (index > 0) {
                prefix = extendType.substring(0, index);
                if (editorName != null && editorName.startsWith(prefix)) {
                    select = i;
                    this.extend = extendType.substring(index + 1, extendType.indexOf(")"));
                } else {
                    String ext;
                    int indexR = extendType.indexOf(")");
                    if (indexR > 0 && resourceExtend != null && resourceExtend.equals(ext = extendType.substring(index + 1, indexR))) {
                        select = i;
                    }
                }
            }
            combo.add(extendType, i);
            ++i;
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String extend = combo.getText();
                extend = extend.substring(extend.indexOf("."), extend.length() - 1);
                String resource = SaveAsDialog.this.resourceGroup.getResource();
                int index = resource.lastIndexOf(".");
                if (index > -1) {
                    resource = resource.substring(0, index);
                }
                SaveAsDialog.this.resourceGroup.setResource(String.valueOf(resource) + extend);
                SaveAsDialog.this.resourceGroup.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (select > -1) {
            combo.select(select);
        }
    }

    private String getEditorLabel() {
        IWorkbench workbench;
        String editorId = this.getEditorID();
        if (editorId != null && editorId != "" && (workbench = this.getWorkbench()) != null) {
            IEditorDescriptor editorDescriptor = workbench.getEditorRegistry().findEditor(editorId);
            return editorDescriptor.getLabel();
        }
        return null;
    }

    public void createPathFiled(Composite composite) {
        Font font = composite.getFont();
        Composite pathGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        pathGroup.setLayout((Layout)layout);
        pathGroup.setLayoutData((Object)new GridData(768));
        pathGroup.setFont(font);
        Label label = new Label(pathGroup, 0);
        label.setText("\u4fdd\u5b58\u4f4d\u7f6e\uff1a");
        label.setFont(font);
        this.resourcePathField = new Text(pathGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.resourcePathField.setLayoutData((Object)data);
        this.resourcePathField.setFont(font);
        this.resourcePathField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SaveAsDialog.this.setDialogComplete(SaveAsDialog.this.validatePage());
            }
        });
        final Button fileButton = new Button(pathGroup, 0);
        fileButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        fileButton.setText("\u6d4f\u89c8(&B)...");
        fileButton.setFont(font);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(fileButton.getShell());
                dialog.setText("\u9009\u62e9\u76ee\u5f55");
                dialog.setMessage("\u9009\u62e9\u76ee\u5f55");
                String result = dialog.open();
                if (result != null && !result.equals("")) {
                    SaveAsDialog.this.resourcePathField.setText(result);
                }
            }
        });
    }

    public IPath getResult() {
        return this.result;
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    private void initializeControls() {
        if (this.originalFile != null) {
            this.resourceGroup.setContainerFullPath(this.originalFile.getParent().getFullPath());
            this.resourceGroup.setResource(this.originalFile.getName());
        } else if (this.originalName != null) {
            if (this.extend != null && this.originalName.lastIndexOf(".") < 0) {
                this.originalName = String.valueOf(this.originalName) + this.extend;
            }
            this.resourceGroup.setResource(this.originalName);
        }
        this.setDialogComplete(this.validatePage());
    }

    private String getResourceName() {
        String name = null;
        if (this.originalFile != null) {
            name = this.originalFile.getName();
        } else if (this.originalName != null && this.extend != null && this.originalName.lastIndexOf(".") < 0) {
            name = this.originalName = String.valueOf(this.originalName) + this.extend;
        }
        return name;
    }

    private String getEditorID() {
        IEditorPart editor = this.getEditorPart();
        if (editor == null) {
            return null;
        }
        IEditorSite site = editor.getEditorSite();
        if (site == null) {
            return null;
        }
        return site.getId();
    }

    public IEditorPart getEditorPart() {
        IWorkbenchPage page = this.getPage();
        if (page == null) {
            return null;
        }
        return page.getActiveEditor();
    }

    public IWorkbenchPage getPage() {
        IWorkbench workbench = this.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        return workbenchWindow.getActivePage();
    }

    public IWorkbench getWorkbench() {
        return IDEWorkbenchPlugin.getDefault().getWorkbench();
    }

    protected void okPressed() {
        File rf;
        String rfPath;
        String fPath;
        boolean b;
        IPath fullPath = this.resourceGroup.getContainerFullPath();
        IPath path = null;
        IFile file = null;
        File f = null;
        if (fullPath != null) {
            path = fullPath.append(this.resourceGroup.getResource());
            if (path.getFileExtension() == null) {
                if (this.originalFile != null && this.originalFile.getFileExtension() != null) {
                    path = path.addFileExtension(this.originalFile.getFileExtension());
                } else if (this.originalName != null) {
                    int pos = this.originalName.lastIndexOf(46);
                    if (++pos > 0 && pos < this.originalName.length()) {
                        path = path.addFileExtension(this.originalName.substring(pos));
                    }
                }
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            f = file.getLocation().toFile();
        }
        if (!(b = (fPath = f == null ? "" : f.getParent()).equals(rfPath = (rf = new File(this.resourcePathField.getText())).getAbsolutePath()))) {
            rf = new File(rf, this.resourceGroup.getResource());
            path = new Path(TextProcessor.deprocess((String)rf.getAbsolutePath())).makeAbsolute();
        }
        if (b && file != null && file.exists() || !b && rf.exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)IDEWorkbenchMessages.SaveAsDialog_overwriteQuestion, (Object)path.toString());
            MessageDialog d = new MessageDialog(this.getShell(), IDEWorkbenchMessages.Question, null, question, 3, buttons, 0){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    this.cancelPressed();
                    return;
                }
            }
        }
        if (b) {
            this.result = path;
            this.isLocalFile = false;
        } else {
            this.result = path;
            this.isLocalFile = true;
        }
        this.close();
    }

    protected void setDialogComplete(boolean value) {
        this.okButton.setEnabled(value);
    }

    public void setOriginalFile(IFile originalFile) {
        this.originalFile = originalFile;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    private boolean validatePage() {
        IProject project;
        String projectName;
        IStatus isValidProjectName;
        if (!this.resourceGroup.areAllValuesValid() && (this.resourcePathField.getText() == null || this.resourcePathField.getText().equals(""))) {
            if (!this.resourceGroup.getResource().equals("")) {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            } else {
                this.setErrorMessage(null);
            }
            return false;
        }
        String resourceName = this.resourceGroup.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath fullPath = this.resourceGroup.getContainerFullPath();
        if (fullPath != null && (isValidProjectName = workspace.validateName(projectName = fullPath.segment(0), 4)).isOK() && !(project = workspace.getRoot().getProject(projectName)).isOpen()) {
            this.setErrorMessage(IDEWorkbenchMessages.SaveAsDialog_closedProjectMessage);
            return false;
        }
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    protected boolean isResizable() {
        return true;
    }
}

