/*
 * Decompiled with CFR 0.152.
 */
package cn.linchaokun.markdown.utils;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;

public class Utilities {
    private static Parser parser;
    private static HtmlRenderer renderer;
    public static FileChooser fileChooser;

    public Utilities() {
        MutableDataSet options = new MutableDataSet();
        parser = Parser.builder((DataHolder)options).build();
        renderer = HtmlRenderer.builder((DataHolder)options).build();
        fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Markdown files (*.md)", new String[]{"*.md"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("TXT files (*.txt)", new String[]{"*.txt"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All files (*.*)", new String[]{"*.*"}));
    }

    public static String reparse(String text) {
        Document document = parser.parse(text.replace("\n", "\n\n"));
        return renderer.render((Node)document);
    }

    public static String toRGB(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }
}

