/*
 * Decompiled with CFR 0.152.
 */
package cn.linchaokun.markdown.ui;

import cn.linchaokun.markdown.utils.Utilities;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDecorator;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextArea;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class MyTab
extends Tab {
    private JFXButton button;
    private SplitPane splitPane;
    private JFXTextArea textArea;
    private WebView webView;
    private Color colorTheme;
    private String filePath = "";
    public boolean isSaved = true;

    public MyTab(String name, JFXTabPane tabPane, Color colorTheme) {
        super(name);
        this.colorTheme = colorTheme;
        this.splitPane = new SplitPane();
        this.setTextArea(new JFXTextArea());
        this.setWebView(new WebView());
        this.addListeners();
        this.setContent((Node)this.splitPane);
        this.setGraphic((Node)this.createTabButton(colorTheme));
        ((JFXButton)this.getGraphic()).setOnAction(e -> {
            if (!this.isSaved) {
                this.checkIfUserWantsToSaveFile();
            }
            tabPane.getTabs().remove((Object)this);
        });
    }

    private JFXButton createTabButton(Color colorTheme) {
        this.button = new JFXButton();
        this.button.setText("X");
        this.button.setPrefWidth(10.0);
        this.button.setPrefHeight(10.0);
        this.button.getStyleClass().add((Object)"tab-button");
        this.updateButtonColor(colorTheme);
        return this.button;
    }

    private void addListeners() {
        this.setOnCloseRequest(e -> this.checkIfUserWantsToSaveFile());
    }

    public void checkIfUserWantsToSaveFile() {
        if (!this.isSaved) {
            Stage saveFileConfirmationStage = new Stage();
            saveFileConfirmationStage.initModality(Modality.WINDOW_MODAL);
            JFXButton buttonOk = new JFXButton("\u786e\u5b9a");
            JFXButton buttonCancel = new JFXButton("\u53d6\u6d88");
            buttonOk.setOnAction(e -> {
                this.checkSaveInCurrentPath();
                saveFileConfirmationStage.close();
            });
            buttonCancel.setOnAction(e -> saveFileConfirmationStage.close());
            HBox hbox = new HBox(new Node[]{buttonOk, buttonCancel});
            hbox.setPadding(new Insets(30.0));
            VBox vbox = new VBox(new Node[]{new Text("\u4fdd\u5b58\u6587\u4ef6 \"" + this.getText().replace(" (*)", "") + "\"?"), hbox});
            vbox.setAlignment(Pos.CENTER);
            vbox.setPadding(new Insets(30.0));
            JFXDecorator saveFileConfirmationDecorator = new JFXDecorator(saveFileConfirmationStage, (Node)vbox);
            Scene saveFileConfirmationScene = new Scene((Parent)saveFileConfirmationDecorator);
            saveFileConfirmationScene.getStylesheets().add((Object)"/css/JMarkPad.css");
            saveFileConfirmationDecorator.setStyle("-fx-decorator-color: " + Utilities.toRGB((Color)this.colorTheme) + ";");
            saveFileConfirmationStage.setScene(saveFileConfirmationScene);
            saveFileConfirmationStage.setResizable(false);
            saveFileConfirmationStage.showAndWait();
        }
    }

    public void checkSaveInCurrentPath() {
        File file = this.filePath.equals("") ? Utilities.fileChooser.showSaveDialog((Window)new Stage()) : new File(this.filePath);
        this.save(file);
    }

    public void saveAs() {
        File file = Utilities.fileChooser.showSaveDialog((Window)new Stage());
        this.save(file);
    }

    private void save(File file) {
        if (file != null) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.getTextArea().getText());
                fileWriter.close();
                this.filePath = file.getAbsolutePath();
                this.setSaved(true);
                this.setText(file.getName());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateButtonColor(Color colorTheme) {
        this.colorTheme = colorTheme;
        this.button.setStyle("-fx-background-color: " + Utilities.toRGB((Color)colorTheme) + ";");
    }

    public void setTextArea(JFXTextArea textArea) {
        this.textArea = textArea;
        textArea.textProperty().addListener(o -> {
            this.webView.getEngine().loadContent(Utilities.reparse((String)textArea.getText()), "text/html");
            this.setSaved(false);
        });
        if (this.splitPane.getItems().size() > 1) {
            this.splitPane.getItems().remove(0);
        }
        this.splitPane.getItems().add(0, (Object)textArea);
        this.setContent((Node)this.splitPane);
    }

    private void setWebView(WebView webView) {
        this.webView = webView;
        if (this.splitPane.getItems().size() > 1) {
            this.splitPane.getItems().remove(1);
        }
        this.splitPane.getItems().add(1, (Object)webView);
        this.setContent((Node)this.splitPane);
    }

    private JFXTextArea getTextArea() {
        return this.textArea;
    }

    public WebView getWebView() {
        return this.webView;
    }

    private void setSaved(boolean isSaved) {
        this.isSaved = isSaved;
        if (isSaved) {
            this.setText(this.getText().replace(" (*)", ""));
        } else {
            this.setText(this.getText().replace(" (*)", "") + " (*)");
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

