/*
 * Decompiled with CFR 0.152.
 */
package cn.linchaokun.markdown.controller;

import cn.linchaokun.markdown.constant.HelpDocConstant;
import cn.linchaokun.markdown.io.XML;
import cn.linchaokun.markdown.ui.MyTab;
import cn.linchaokun.markdown.ui.panes.AboutPane;
import cn.linchaokun.markdown.ui.panes.OptionsPane;
import cn.linchaokun.markdown.utils.HelpUtil;
import cn.linchaokun.markdown.utils.SystemUtil;
import cn.linchaokun.markdown.utils.Utilities;
import cn.linchaokun.markdown.utils.VariablesToSave;
import com.jfoenix.controls.JFXDecorator;
import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXDrawersStack;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextArea;
import de.felixroske.jfxsupport.FXMLController;
import de.felixroske.jfxsupport.GUIState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.scene.control.Tab;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

@FXMLController
public class IndexController
implements Initializable {
    private Stage stage;
    public Color colorTheme;
    public JFXDrawer optionsDrawer;
    public JFXDrawer aboutDrawer;
    private static String receivedPath = "";
    private XML xml;
    private static JFXDecorator jfDecorator;
    private static String colorStr;
    @FXML
    public JFXDrawersStack drawersStack;
    @FXML
    public JFXTabPane tabPane;
    @FXML
    public MenuBar menuBar;

    public void initialize(URL location, ResourceBundle resources) {
        this.stage = GUIState.getStage();
        new Utilities();
        this.loadXMLValues();
        this.loadDrawers();
        if (this.tabPane.getTabs().size() < 1) {
            MyTab tab = new MyTab("New 1", this.tabPane, this.colorTheme);
            this.tabPane.getTabs().add((Object)tab);
        }
        this.refreshTheme();
    }

    private void loadXMLValues() {
        try {
            this.xml = new XML("/" + SystemUtil.getUserHome() + "/jmarkpad.xml");
            this.stage.setWidth(Double.valueOf(this.xml.loadVariable("width")).doubleValue());
            this.stage.setHeight(Double.valueOf(this.xml.loadVariable("height")).doubleValue());
            this.colorTheme = new Color(Double.valueOf(this.xml.loadVariable("red")).doubleValue(), Double.valueOf(this.xml.loadVariable("green")).doubleValue(), Double.valueOf(this.xml.loadVariable("blue")).doubleValue(), 1.0);
            for (String path : this.xml.loadVariables("file")) {
                MyTab tab = new MyTab(path.split("\\\\")[path.split("\\\\").length - 1], this.tabPane, this.colorTheme);
                File file = new File(path);
                try {
                    this.openFileIntoTab(file, tab);
                    tab.setFilePath(file.getAbsolutePath());
                    this.tabPane.getTabs().add((Object)tab);
                    this.tabPane.getSelectionModel().select((Object)tab);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            this.colorTheme = new Color(0.3921568691730499, 0.7098039388656616, 0.9647058844566345, 1.0);
        }
    }

    private void loadDrawers() {
        this.drawersStack.setMouseTransparent(true);
        FlowPane content = new FlowPane();
        StackPane optionsDrawerPane = new StackPane();
        this.optionsDrawer = new JFXDrawer();
        OptionsPane optionsPane = new OptionsPane(this);
        optionsDrawerPane.getChildren().add((Object)optionsPane);
        this.optionsDrawer.setDirection(JFXDrawer.DrawerDirection.RIGHT);
        this.optionsDrawer.setSidePane(new Node[]{optionsDrawerPane});
        this.optionsDrawer.setDefaultDrawerSize(150.0);
        this.optionsDrawer.setOverLayVisible(false);
        this.optionsDrawer.setResizableOnDrag(true);
        this.aboutDrawer = new JFXDrawer();
        AboutPane aboutPane = new AboutPane(this);
        StackPane aboutDrawerPane = new StackPane();
        aboutDrawerPane.getChildren().add((Object)aboutPane);
        this.aboutDrawer.setDirection(JFXDrawer.DrawerDirection.RIGHT);
        this.aboutDrawer.setSidePane(new Node[]{aboutDrawerPane});
        this.aboutDrawer.setDefaultDrawerSize(this.stage.getWidth());
        this.aboutDrawer.setOverLayVisible(false);
        this.aboutDrawer.setResizableOnDrag(true);
        this.drawersStack.setContent((Node)content);
    }

    private void openFileIntoTab(File file, MyTab tab) throws IOException {
        String text;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        JFXTextArea textArea = new JFXTextArea("");
        while ((text = bufferedReader.readLine()) != null) {
            textArea.appendText(text + "\n");
        }
        tab.setTextArea(textArea);
        bufferedReader.close();
    }

    public void refreshTheme() {
        String colorThemeString = Utilities.toRGB((Color)this.colorTheme);
        String colorThemeStringBrighter = Utilities.toRGB((Color)this.colorTheme.brighter().brighter());
        colorStr = colorThemeString;
        this.menuBar.setStyle("-fx-background-color: " + colorThemeString + ";");
        this.tabPane.setStyle("tab-header-background: " + colorThemeStringBrighter + ";");
        if (jfDecorator != null) {
            jfDecorator.setStyle("-fx-decorator-color: " + colorStr + ";");
        }
        for (int i = 0; i < this.tabPane.getTabs().size(); ++i) {
            ((MyTab)this.tabPane.getTabs().get(i)).updateButtonColor(this.colorTheme);
        }
    }

    public static void refreshThemeDecorator(JFXDecorator decorator) {
        decorator.setStyle("-fx-decorator-color: " + colorStr + ";");
        jfDecorator = decorator;
    }

    private boolean isFileIsAlreadyOpen(String filePath) {
        boolean result = false;
        for (int i = 0; i < this.tabPane.getTabs().size(); ++i) {
            MyTab currentlyOpenTab = (MyTab)this.tabPane.getTabs().get(i);
            if (!currentlyOpenTab.getFilePath().equals(filePath)) continue;
            this.tabPane.getSelectionModel().select(i);
            result = true;
        }
        return result;
    }

    public void newClicked(ActionEvent actionEvent) {
        String newFileName = "";
        int counter = 1;
        while (newFileName.equals("")) {
            boolean usedName = false;
            for (int i = 0; i < this.tabPane.getTabs().size(); ++i) {
                if (!((Tab)this.tabPane.getTabs().get(i)).getText().contains("New " + counter)) continue;
                usedName = true;
                i = this.tabPane.getTabs().size();
            }
            if (!usedName) {
                newFileName = "New " + counter;
            }
            ++counter;
        }
        MyTab tab = new MyTab(newFileName, this.tabPane, this.colorTheme);
        this.tabPane.getTabs().add((Object)tab);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    public void openClicked(ActionEvent actionEvent) {
        File file = Utilities.fileChooser.showOpenDialog((Window)this.stage);
        if (file != null) {
            if (this.isFileIsAlreadyOpen(file.getAbsolutePath())) {
                return;
            }
            MyTab tab = new MyTab(file.getName(), this.tabPane, this.colorTheme);
            try {
                this.openFileIntoTab(file, tab);
                tab.setFilePath(file.getAbsolutePath());
                this.tabPane.getTabs().add((Object)tab);
                this.tabPane.getSelectionModel().select((Object)tab);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveClicked(ActionEvent actionEvent) {
        ((MyTab)this.tabPane.getTabs().get(this.tabPane.getSelectionModel().getSelectedIndex())).checkSaveInCurrentPath();
    }

    public void saveAsClicked(ActionEvent actionEvent) {
        for (int i = 0; i < this.tabPane.getTabs().size(); ++i) {
            ((MyTab)this.tabPane.getTabs().get(i)).saveAs();
        }
    }

    public void saveAllClicked(ActionEvent actionEvent) {
        for (int i = 0; i < this.tabPane.getTabs().size(); ++i) {
            ((MyTab)this.tabPane.getTabs().get(i)).checkSaveInCurrentPath();
        }
    }

    public void closeClicked(ActionEvent actionEvent) {
        int selectedIndex = this.tabPane.getSelectionModel().getSelectedIndex();
        if (selectedIndex != -1) {
            if (!((MyTab)this.tabPane.getTabs().get((int)selectedIndex)).isSaved) {
                ((MyTab)this.tabPane.getTabs().get(this.tabPane.getSelectionModel().getSelectedIndex())).checkIfUserWantsToSaveFile();
            }
            this.tabPane.getTabs().remove(this.tabPane.getSelectionModel().getSelectedIndex());
        } else {
            System.exit(0);
        }
    }

    public void optionsClicked(ActionEvent actionEvent) {
        this.drawersStack.toggle(this.optionsDrawer);
        this.drawersStack.setMouseTransparent(false);
    }

    public void markDownHelpClicked(ActionEvent actionEvent) {
        HelpUtil.creHelpDoc((String)"Examples", (JFXTabPane)this.tabPane, (Color)this.colorTheme, (String)HelpDocConstant.SIMPLE);
    }

    public void aboutClicked(ActionEvent actionEvent) {
        this.drawersStack.toggle(this.aboutDrawer);
        this.drawersStack.setMouseTransparent(false);
    }

    public void optionsSaveClicked(ActionEvent actionEvent) {
        String[] filePaths = new String[]{};
        VariablesToSave variablesToSave = new VariablesToSave();
        variablesToSave.width = this.stage.getWidth();
        variablesToSave.height = this.stage.getHeight();
        variablesToSave.red = this.colorTheme.getRed();
        variablesToSave.green = this.colorTheme.getGreen();
        variablesToSave.blue = this.colorTheme.getBlue();
        variablesToSave.paths = filePaths;
        this.xml.writeVariables(variablesToSave);
    }
}

