
PrefixStr="UpgradeFlash"

mtdtype=`cat /proc/cmdline  | sed -e "s/.*mtdparts=//g" -e "s/:.*//g"`
mtd_config_index=`cat /proc/mtd |grep -e "config" | sed -e "s/:.*//g" | cut -c 4-`
if [ -z $mtd_config_index ];then
mtd_config_index=4;
fi
ovfs_core_path=$(which ovfs_core)
if [ -z $ovfs_core_path ];then
g_bOvfsSystem=0;
else
g_bOvfsSystem=1;
fi
LogFile="/dev/tee.log"
configmtd=/dev/mtdblock${mtd_config_index};
restart()
{
if [ $g_bOvfsSystem -eq 0 ];then
mount -t jffs2 $configmtd /usr/etc;
local index=0;
while [ $index -lt 10 ] ; do 
cd /root/; ./AntsOnvifServer & 
sleep 1; str=$(ps); sleep 1; 
echo "$str" | grep -q "AntsOnvifServer"; ret=$?; 
if [ $ret -eq 0 ] ; then 
break; 
else let index++; 
fi; 
done;
if [ $index -eq 10 ] ; then echo -e "$PrefixStr Status=Rebooting" | tee -a $LogFile; sleep 1; reboot; fi;
else
echo -e "$PrefixStr Status=Rebooting" | tee -a $LogFile; sleep 1; reboot;
fi
}

resetip()
{
local n=1;
while [ true ] ; do 
ip=192.168.1.$n; ping -c1 -w5 $ip; ret=$?; 
echo -e ip=$ip>>/dev/ip.log; fsync /dev/ip.log; 
if [ $ret -eq 0 ] ; then let n++; usleep 10000; continue; 
else 
#sed -i -e "s/<struDVRIP sIpV4=\".*\" *\/>/<struDVRIP sIpV4=\"${ip}\" byIPv6=\"${ip}\" \/>/g" /usr/etc/NETCFG.xml; killall AntsOnvifServer; 
ifconfig eth0 $ip; route add default gw 192.168.1.1 eth0; break; 
fi; 
done;
}

checkversion()
{
return 0;
grep -q "buildmonth 09" /root/version && grep -q "buildday 15" /root/version; return $?;
}

prepare()
{
echo Prepare $(date) >> $LogFile;
echo -e "$PrefixStr Status=Preparing" | tee -a $LogFile
checkversion; ret=$?;
check_hardware;

if [ $ret -ne 0 ] ; then
echo -e "$PrefixStr Status=UpgradeFinished" | tee -a $LogFile
sleep 1; exit 0;
else

if [ $g_bOvfsSystem -eq 0 ];then
#### old ipc ####

echo -e "#!/bin/sh \n\nwhile [ true ] ; do sleep 1; done;" > /dev/AntsOnvifServer; chmod a+x /dev/AntsOnvifServer; 
local program=$(which wdgagent || which wtg_close)
if [ -z $program ] ; then
cd /dev; ftpget -u test -p test $serverip wdgagent bin/"${s_chipf}"/wdgagent; ret=$?; 
if [ $ret -eq 0 ] ; then program=/dev/wdgagent; chmod a+x $program; else echo -e "$PrefixStr Status=DownloadWdgagentFail" | tee -a $LogFile; exit 0; fi
fi

${program} 1 9999999 & 
killall appinstall mediaservice AntsOnvifServer nginx boardsystem;killall snmptrap.sh;pkill ovfs_;pkill nginx;rm /tmp/prerecord/* /tmp/syslog.log -rf;
let pid=$(ps -A |grep "AntsOnvifServer"| awk '{print $1}'); kill -9 $pid; sleep 3;
sysctl -w vm.drop_caches=3; /dev/AntsOnvifServer &

echo "$imagefile" | grep -q ".flash";
if [ $? -eq 0 ] ; then
configmtd=$(mount | grep " /usr/etc " | cut -d ' ' -f 1); cp -af /usr/etc/auth/sn /dev; umount /usr/etc; umount -f /update;
fi

else
#####ovfs###
#
local program=$(which wtdgops)
${program} stop &
pkill ovfs;pkill nginx;killall update appinstall snmptrap.sh pppoe-start;sleep 3;
sysctl -w vm.drop_caches=3;
echo "$imagefile" | grep -q ".flash";
fi


fi
}

s_hardware="";
s_platform="";
s_chipf="";
check_hardware()
{
if [ ! -z "$s_hardware" ] ; then
return;
fi

if [ -f "/usr/etc/factoryinfo.json" ] ; then
FAC_INFO_PATH=/usr/etc/factoryinfo.json
s_hardware=$(echo $(grep "Hardware" $FAC_INFO_PATH) | sed -e "s/\"//g" -e "s/Hardware://g" | cut -d ',' -f 1 | tr [a-z] [A-Z])

else

local infofile="/root/res_xml/factoryInfo.xml";
if [ -f "/root/res_xml/factoryInfo.xml" ] ; then
infofile="/root/res_xml/factoryInfo.xml";
elif [ -f "/update/res_xml/factoryInfo.xml" ] ; then
infofile="/update/res_xml/factoryInfo.xml";
elif [ -f "/usr/etc/res_xml/factoryInfo.xml" ] ; then
infofile="/usr/etc/res_xml/factoryInfo.xml";
fi

s_customer=$(grep -nr "<Customer content" "$infofile" | cut -d '"' -f 2);
s_hardware=$(grep -nr "<Hardware content" "$infofile" | cut -d '"' -f 2);
if [ -z "${s_hardware}" ] ; then
echo "Not find hardware."
if [ "${s_customer}" == "JUANTMP" ] ; then
s_hardware="FSAN_HI3518C_D1402_JUAN";
else
return
fi
fi

fi

if [ ! -z "${s_hardware}" ] ; then

echo "${s_hardware}" | grep -q "MSTAR";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=MSTAR;
s_chipf=mstar;
fi

echo "${s_hardware}" | grep -q "HI3519";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=HI3519;
s_chipf=hi3519;
fi

echo "${s_hardware}" | grep -q "HI3516A";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3516a;
s_chipf=hi3516a;
fi

echo "${s_hardware}" | grep -q "HI3516D";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3516d;
s_chipf=hi3516a;
fi

echo "${s_hardware}" | grep -q "HI3516CV300";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3516cv300;
s_chipf=hi3516cv300;
fi

echo "${s_hardware}" | grep -q "HI3518A";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3518a;
s_chipf=hi3518;
fi

echo "${s_hardware}" | grep -q "HI3518C";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3518c;
s_chipf=hi3518;
fi

echo "${s_hardware}" | grep -q "HI3518E";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3518e;
s_chipf=hi3518;
fi

echo "${s_hardware}" | grep -q "HI3516C";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3516c;
s_chipf=hi3518;
fi

echo "${s_hardware}" | grep -q "HI3516";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3516;
s_chipf=hi3518;
fi

echo "${s_hardware}" | grep -q "GM8135S";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=GM8135S;
s_chipf=gm8136;
fi

echo "${s_hardware}" | grep -q "GM8136S";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=GM8136S;
s_chipf=gm8136;
fi

echo "${s_hardware}" | grep -q "HI3535";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3535;
s_chipf=hi3535;
fi

echo "${s_hardware}" | grep -q "HI3536";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=hi3536;
s_chipf=hi3536;
return;
fi

echo "${s_hardware}" | grep -q "GM8138S";
if [ -z "$s_platform" -a $? -eq 0 ] ; then
s_platform=GM8138S;
s_chipf=gm8136;
return;
fi

echo "hardware:$s_hardware"
echo "platform:$s_platform"
echo "chipf:$s_chipf"

fi
}

download()
{
local j=0;
echo Download $(date) >> $LogFile;
while [ $j -lt 3 ] ; do
let j++;
echo -e "$PrefixStr Status=Downloading Progress=%1" | tee -a $LogFile
echo -e "cd /dev; ftpget -u test -p test $serverip bin/${s_chipf}/upflash; chmod a+x upflash;" | tee -a $LogFile
cd /dev; ftpget -u test -p test $serverip upflash bin/"${s_chipf}"/upflash; ret=$?; 
if [ $ret -eq 0 ] ; then 
echo -e "$PrefixStr Status=Downloading Progress=%10" | tee -a $LogFile
chmod a+x upflash;
break;
else
echo -e "$PrefixStr Status=DownloadingError1" | tee -a $LogFile
sleep 1;
fi;
done
if [ $j -eq 3 ] ; then
echo -e "$PrefixStr Status=UpgradeFailed" | tee -a $LogFile;
finish;
fi

local i=0;
while [ $i -lt 3 ] ; do
let i++;
echo -e "ftpget -u test -p test $serverip \"$imagefile\";" | tee -a $LogFile
ftpget -u test -p test $serverip "$imagefile";ret=$?;
if [ $ret -eq 0 ] ; then 
#result=$(md5sum $imagefile | cut -d ' ' -f 1);
result=$md5value;
if [ "$result" == "$md5value" ] ; then 
echo -e "$PrefixStr Status=Downloading Progress=%100" | tee -a $LogFile
break;
else
echo -e "$PrefixStr Status=DownloadingError2" | tee -a $LogFile
fi;
else
echo -e "$PrefixStr Status=DownloadingError3" | tee -a $LogFile
fi;
done
if [ $i -eq 3 ] ; then
echo -e "$PrefixStr Status=UpgradeFailed" | tee -a $LogFile;
finish;
fi
}

upgrade()
{
echo Upgrade $(date) >> $LogFile;
echo -e "$PrefixStr Status=Upgrading Progress=%1" | tee -a $LogFile
which upflash ;
if [ $? -eq 0 ] ; then
upflash "$imagefile" prog.log > /dev/null 2>>$LogFile &
else
/dev/upflash "$imagefile" prog.log > /dev/null 2>>$LogFile &
fi
}

before_finish()
{
local program=$(which asdpd)
${program} -d 1;


echo "$imagefile" | grep -q ".flash";
if [ $? -ne 0 ] ; then
echo Finish1 $(date) >> $LogFile;

if [ $g_bOvfsSystem -eq 0 ];then

mount -t jffs2 $configmtd /usr/etc;
if [ -f /usr/etc/NETCFG.xml.bak ] ; then
mv /usr/etc/NETCFG.xml.bak /usr/etc/NETCFG.xml;
fi;
if [ -f /dev/sn ] ; then
mkdir -p /usr/etc/auth;
cp -af /dev/sn /usr/etc/auth/sn;
fi;
fi;

fi;

rm -rf "$imagefile"; sleep 3;
hwaddr=$(ifconfig eth0 | grep "HWaddr" | sed -e "s/.*HWaddr //g" -e "s/ *$//g" -e "s/:/./g");
ipaddr=$(ifconfig eth0 | grep "inet addr" | sed -e "s/.*inet addr://g" -e "s/ *Bcast.*//g");

if [ $mtdtype == "sfc" ] || [ $mtdtype == "hi_sfc" ];then
dumpfile="$hwaddr-$ipaddr"
cat /dev/mtd0 > "$dumpfile"; cat /dev/mtd1 >> "$dumpfile"; cat /dev/mtd2 >> "$dumpfile"; cat /dev/mtd3 >> "$dumpfile";
else
dumpfile="$hwaddr-$ipaddr".tar.gz
tar czf ${dumpfile} /update;
fi
echo -e "ftpput -u test -p test $serverip $dumpfile;" >> $LogFile;
md5sum "$dumpfile" >> $LogFile;

echo -e "prog.log start============" >> $LogFile;
cat prog.log >> $LogFile;
echo -e "prog.log stop============" >> $LogFile;

echo -e "dmesg start=============" >> $LogFile;
dmesg -c >> $LogFile;
echo -e "dmesg stop=============" >> $LogFile;

ftpput -u test -p test $serverip log/$dumpfile.log tee.log;

}

checkprogress()
{
echo CheckProgress $(date) >> $LogFile;
while [ ture ] ; do
sleep 4; 
str=$(ps); echo "$str" | grep -q "upflash"; local ret=$?;
progress=$(cat prog.log | cut -d ' ' -f 2); 
echo -e "$PrefixStr Status=Upgrading Progress=$progress" | tee -a $LogFile
if [ "$progress" == "%100" ] ; then 

if [ $g_bOvfsSystem -eq 0 ];then
before_finish;
fi

echo -e "$PrefixStr Status=UpgradeFinished" | tee -a $LogFile
break; 
elif [ $ret -ne 0 ] ; then
echo -e "$PrefixStr Status=UpgradingError01" | tee -a $LogFile
break;
fi; 
done;
}

confirm()
{
result=$(cat /dev/mtd0 | md5sum); 
if [ "$result" == "" ] ; then 
echo "Partition 0 PASS" | tee -a $LogFile;
else echo "Partition 0 FAILED" | tee -a $LogFile; fi
}

finish()
{
echo Finish2 $(date) >> $LogFile;
echo -e "$PrefixStr Status=Rebooting" | tee -a $LogFile;
tail -n 100 $LogFile > /usr/etc/tee.log;
while [ true ] ; do sleep 10; reboot; done;
}

main()
{
#resetip;

prepare;

download;

upgrade;

checkprogress;

#confirm;

finish;
}

main &
