/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.tokens;

import java.util.List;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.tokens.Token;

public final class DirectiveToken
extends Token {
    private final String name;
    private final List<?> value;

    public DirectiveToken(String string, List<?> list, Mark mark, Mark mark2) {
        super(mark, mark2);
        this.name = string;
        if (list != null && list.size() != 2) {
            throw new YAMLException("Two strings must be provided instead of " + String.valueOf(list.size()));
        }
        this.value = list;
    }

    public String getName() {
        return this.name;
    }

    public List<?> getValue() {
        return this.value;
    }

    @Override
    protected String getArguments() {
        if (this.value != null) {
            return "name=" + this.name + ", value=[" + this.value.get(0) + ", " + this.value.get(1) + "]";
        }
        return "name=" + this.name;
    }

    @Override
    public String getTokenId() {
        return "<directive>";
    }
}

