/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.serializer;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.SerializerException;

public final class Serializer {
    private final Emitter emitter;
    private final Resolver resolver;
    private boolean explicitStart;
    private boolean explicitEnd;
    private Integer[] useVersion;
    private Map<String, String> useTags;
    private Set<Node> serializedNodes;
    private Map<Node, String> anchors;
    private int lastAnchorId;
    private Boolean closed;
    private String explicitRoot;

    public Serializer(Emitter emitter, Resolver resolver, DumperOptions dumperOptions) {
        this.emitter = emitter;
        this.resolver = resolver;
        this.explicitStart = dumperOptions.isExplicitStart();
        this.explicitEnd = dumperOptions.isExplicitEnd();
        if (dumperOptions.getVersion() != null) {
            this.useVersion = dumperOptions.getVersion().getArray();
        }
        this.useTags = dumperOptions.getTags();
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, String>();
        this.lastAnchorId = 0;
        this.closed = null;
        this.explicitRoot = dumperOptions.getExplicitRoot();
    }

    public void open() throws IOException {
        if (this.closed != null) {
            if (Boolean.TRUE.equals(this.closed)) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent(null, null));
        this.closed = Boolean.FALSE;
    }

    public void close() throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (!Boolean.TRUE.equals(this.closed)) {
            this.emitter.emit(new StreamEndEvent(null, null));
            this.closed = Boolean.TRUE;
        }
    }

    public void serialize(Node node) throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed.booleanValue()) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(null, null, this.explicitStart, this.useVersion, this.useTags));
        this.anchorNode(node);
        if (this.explicitRoot != null) {
            node.setTag(this.explicitRoot);
        }
        this.serializeNode(node, null, null);
        this.emitter.emit(new DocumentEndEvent(null, null, this.explicitEnd));
        this.serializedNodes.clear();
        this.anchors.clear();
        this.lastAnchorId = 0;
    }

    private void anchorNode(Node node) {
        if (this.anchors.containsKey(node)) {
            String string = this.anchors.get(node);
            if (null == string) {
                string = this.generateAnchor();
                this.anchors.put(node, string);
            }
        } else {
            this.anchors.put(node, null);
            switch (node.getNodeId()) {
                case sequence: {
                    SequenceNode sequenceNode = (SequenceNode)node;
                    List<Node> list = sequenceNode.getValue();
                    for (Node node2 : list) {
                        this.anchorNode(node2);
                    }
                    break;
                }
                case mapping: {
                    MappingNode mappingNode = (MappingNode)node;
                    List<NodeTuple> list = mappingNode.getValue();
                    for (NodeTuple nodeTuple : list) {
                        Node node3 = nodeTuple.getKeyNode();
                        Node node4 = nodeTuple.getValueNode();
                        this.anchorNode(node3);
                        this.anchorNode(node4);
                    }
                    break;
                }
            }
        }
    }

    private String generateAnchor() {
        ++this.lastAnchorId;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumIntegerDigits(3);
        String string = numberFormat.format(this.lastAnchorId);
        return "id" + string;
    }

    private void serializeNode(Node node, Node node2, Object object) throws IOException {
        String string = this.anchors.get(node);
        if (this.serializedNodes.contains(node)) {
            this.emitter.emit(new AliasEvent(string, null, null));
        } else {
            this.serializedNodes.add(node);
            switch (node.getNodeId()) {
                case scalar: {
                    ScalarNode scalarNode = (ScalarNode)node;
                    String string2 = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), true);
                    String string3 = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), false);
                    ImplicitTuple implicitTuple = new ImplicitTuple(node.getTag().equals(string2), node.getTag().equals(string3));
                    ScalarEvent scalarEvent = new ScalarEvent(string, node.getTag(), implicitTuple, scalarNode.getValue(), null, null, scalarNode.getStyle());
                    this.emitter.emit(scalarEvent);
                    break;
                }
                case sequence: {
                    SequenceNode sequenceNode = (SequenceNode)node;
                    boolean bl = node.getTag().equals(this.resolver.resolve(NodeId.sequence, null, true));
                    this.emitter.emit(new SequenceStartEvent(string, node.getTag(), bl, null, null, sequenceNode.getFlowStyle()));
                    int n = 0;
                    List<Node> list = sequenceNode.getValue();
                    for (Node node3 : list) {
                        this.serializeNode(node3, node, new Integer(n));
                        ++n;
                    }
                    this.emitter.emit(new SequenceEndEvent(null, null));
                    break;
                }
                default: {
                    String string4 = this.resolver.resolve(NodeId.mapping, null, true);
                    boolean bl = node.getTag().equals(string4);
                    this.emitter.emit(new MappingStartEvent(string, node.getTag(), bl, null, null, ((CollectionNode)node).getFlowStyle()));
                    MappingNode mappingNode = (MappingNode)node;
                    List<NodeTuple> list = mappingNode.getValue();
                    for (NodeTuple nodeTuple : list) {
                        Node node4 = nodeTuple.getKeyNode();
                        Node node5 = nodeTuple.getValueNode();
                        this.serializeNode(node4, mappingNode, null);
                        this.serializeNode(node5, mappingNode, node4);
                    }
                    this.emitter.emit(new MappingEndEvent(null, null));
                }
            }
        }
    }
}

