/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.error;

public final class Mark {
    private String name;
    private int line;
    private int column;
    private String buffer;
    private int pointer;

    public Mark(String string, int n, int n2, int n3, String string2, int n4) {
        this.name = string;
        this.line = n2;
        this.column = n3;
        this.buffer = string2;
        this.pointer = n4;
    }

    private boolean isLineBreak(char c) {
        return "\u0000\r\n\u0085\u2028\u2029".indexOf(c) != -1;
    }

    public String get_snippet(int n, int n2) {
        int n3;
        if (this.buffer == null) {
            return null;
        }
        float f = n2 / 2 - 1;
        int n4 = this.pointer;
        String string = "";
        while (n4 > 0 && !this.isLineBreak(this.buffer.charAt(n4 - 1))) {
            if (!((float)(this.pointer - --n4) > f)) continue;
            string = " ... ";
            n4 += 5;
            break;
        }
        String string2 = "";
        int n5 = this.pointer;
        while (n5 < this.buffer.length() && !this.isLineBreak(this.buffer.charAt(n5))) {
            if (!((float)(++n5 - this.pointer) > f)) continue;
            string2 = " ... ";
            n5 -= 5;
            break;
        }
        String string3 = this.buffer.substring(n4, n5);
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n; ++n3) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(string);
        stringBuffer.append(string3);
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        for (n3 = 0; n3 < n + this.pointer - n4 + string.length(); ++n3) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("^");
        return stringBuffer.toString();
    }

    public String get_snippet() {
        return this.get_snippet(4, 75);
    }

    public String toString() {
        String string = this.get_snippet();
        StringBuffer stringBuffer = new StringBuffer(" in \"");
        stringBuffer.append(this.name);
        stringBuffer.append("\", line ");
        stringBuffer.append(this.line + 1);
        stringBuffer.append(", column ");
        stringBuffer.append(this.column + 1);
        if (string != null) {
            stringBuffer.append(":\n");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

