/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.util.Iterator;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.Reader;
import org.yaml.snakeyaml.resolver.Resolver;

public class Loader {
    protected final BaseConstructor constructor;
    protected Resolver resolver;
    private boolean attached = false;

    public Loader(BaseConstructor baseConstructor) {
        this.constructor = baseConstructor;
    }

    public Loader() {
        this(new Constructor());
    }

    public Object load(java.io.Reader reader) {
        Composer composer = new Composer(new ParserImpl(new Reader(reader)), this.resolver);
        this.constructor.setComposer(composer);
        return this.constructor.getSingleData();
    }

    public Iterable<Object> loadAll(java.io.Reader reader) {
        Composer composer = new Composer(new ParserImpl(new Reader(reader)), this.resolver);
        this.constructor.setComposer(composer);
        Iterator<Object> iterator = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return Loader.this.constructor.checkData();
            }

            @Override
            public Object next() {
                return Loader.this.constructor.getData();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new YamlIterable(iterator);
    }

    public Node compose(java.io.Reader reader) {
        Composer composer = new Composer(new ParserImpl(new Reader(reader)), this.resolver);
        this.constructor.setComposer(composer);
        return composer.getSingleNode();
    }

    public Iterable<Node> composeAll(java.io.Reader reader) {
        final Composer composer = new Composer(new ParserImpl(new Reader(reader)), this.resolver);
        this.constructor.setComposer(composer);
        Iterator<Node> iterator = new Iterator<Node>(){

            @Override
            public boolean hasNext() {
                return composer.checkNode();
            }

            @Override
            public Node next() {
                return composer.getNode();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new NodeIterable(iterator);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    void setAttached() {
        if (this.attached) {
            throw new YAMLException("Loader cannot be shared.");
        }
        this.attached = true;
    }

    public Iterable<Event> parse(java.io.Reader reader) {
        final ParserImpl parserImpl = new ParserImpl(new Reader(reader));
        Iterator<Event> iterator = new Iterator<Event>(){

            @Override
            public boolean hasNext() {
                return parserImpl.peekEvent() != null;
            }

            @Override
            public Event next() {
                return parserImpl.getEvent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new EventIterable(iterator);
    }

    private class EventIterable
    implements Iterable<Event> {
        private Iterator<Event> iterator;

        public EventIterable(Iterator<Event> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Event> iterator() {
            return this.iterator;
        }
    }

    private class YamlIterable
    implements Iterable<Object> {
        private Iterator<Object> iterator;

        public YamlIterable(Iterator<Object> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iterator;
        }
    }

    private class NodeIterable
    implements Iterable<Node> {
        private Iterator<Node> iterator;

        public NodeIterable(Iterator<Node> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Node> iterator() {
            return this.iterator;
        }
    }
}

