/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

public class Dumper {
    private final Representer representer;
    private final DumperOptions options;
    private boolean attached = false;

    public Dumper(Representer representer, DumperOptions dumperOptions) {
        this.representer = representer;
        representer.setDefaultFlowStyle(dumperOptions.getDefaultFlowStyle());
        representer.setDefaultScalarStyle(dumperOptions.getDefaultScalarStyle());
        this.options = dumperOptions;
    }

    public Dumper(DumperOptions dumperOptions) {
        this(new Representer(), dumperOptions);
    }

    public void dump(Iterator<? extends Object> iterator, Writer writer, Resolver resolver) {
        Serializer serializer = new Serializer(new Emitter(writer, this.options), resolver, this.options);
        try {
            serializer.open();
            while (iterator.hasNext()) {
                this.representer.represent(serializer, iterator.next());
            }
            serializer.close();
        }
        catch (IOException iOException) {
            throw new YAMLException(iOException);
        }
    }

    void setAttached() {
        if (this.attached) {
            throw new YAMLException("Dumper cannot be shared.");
        }
        this.attached = true;
    }
}

