/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

public final class ByteArray {
    private final byte[] bytes;
    private final int start;
    private final int size;

    public ByteArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("bytes == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("start < 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("end < start");
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("end > bytes.length");
        }
        this.bytes = byArray;
        this.start = n;
        this.size = n2 - n;
    }

    public ByteArray(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public int size() {
        return this.size;
    }

    public ByteArray slice(int n, int n2) {
        this.checkOffsets(n, n2);
        return new ByteArray(this.bytes, n + this.start, n2 + this.start);
    }

    public int underlyingOffset(int n, byte[] byArray) {
        if (byArray != this.bytes) {
            throw new IllegalArgumentException("wrong bytes");
        }
        return this.start + n;
    }

    public int getByte(int n) {
        this.checkOffsets(n, n + 1);
        return this.getByte0(n);
    }

    public int getShort(int n) {
        this.checkOffsets(n, n + 2);
        return this.getByte0(n) << 8 | this.getUnsignedByte0(n + 1);
    }

    public int getInt(int n) {
        this.checkOffsets(n, n + 4);
        return this.getByte0(n) << 24 | this.getUnsignedByte0(n + 1) << 16 | this.getUnsignedByte0(n + 2) << 8 | this.getUnsignedByte0(n + 3);
    }

    public long getLong(int n) {
        this.checkOffsets(n, n + 8);
        int n2 = this.getByte0(n) << 24 | this.getUnsignedByte0(n + 1) << 16 | this.getUnsignedByte0(n + 2) << 8 | this.getUnsignedByte0(n + 3);
        int n3 = this.getByte0(n + 4) << 24 | this.getUnsignedByte0(n + 5) << 16 | this.getUnsignedByte0(n + 6) << 8 | this.getUnsignedByte0(n + 7);
        return (long)n3 & 0xFFFFFFFFL | (long)n2 << 32;
    }

    public int getUnsignedByte(int n) {
        this.checkOffsets(n, n + 1);
        return this.getUnsignedByte0(n);
    }

    public int getUnsignedShort(int n) {
        this.checkOffsets(n, n + 2);
        return this.getUnsignedByte0(n) << 8 | this.getUnsignedByte0(n + 1);
    }

    public void getBytes(byte[] byArray, int n) {
        if (byArray.length - n < this.size) {
            throw new IndexOutOfBoundsException("(out.length - offset) < size()");
        }
        System.arraycopy(this.bytes, this.start, byArray, n, this.size);
    }

    private void checkOffsets(int n, int n2) {
        if (n < 0 || n2 < n || n2 > this.size) {
            throw new IllegalArgumentException("bad range: " + n + ".." + n2 + "; actual size " + this.size);
        }
    }

    private int getByte0(int n) {
        return this.bytes[this.start + n];
    }

    private int getUnsignedByte0(int n) {
        return this.bytes[this.start + n] & 0xFF;
    }
}

