/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class DoubleEncodedValue
extends EncodedValue {
    public final double value;

    protected DoubleEncodedValue(Input input, byte by) {
        long l = EncodedValueUtils.decodeRightZeroExtendedValue(input.readBytes(by + 1));
        this.value = Double.longBitsToDouble(l);
    }

    public DoubleEncodedValue(double d) {
        this.value = d;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        byte[] byArray = EncodedValueUtils.encodeRightZeroExtendedValue(Double.doubleToRawLongBits(this.value));
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_DOUBLE.name() + ",value_arg=" + (byArray.length - 1));
            annotatedOutput.annotate(byArray.length, "value: " + this.value);
        }
        annotatedOutput.writeByte(ValueType.VALUE_DOUBLE.value | byArray.length - 1 << 5);
        annotatedOutput.write(byArray);
    }

    @Override
    public int placeValue(int n) {
        return n + 1 + EncodedValueUtils.getRequiredBytesForRightZeroExtendedValue(Double.doubleToRawLongBits(this.value));
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        DoubleEncodedValue doubleEncodedValue = (DoubleEncodedValue)encodedValue;
        return Double.compare(this.value, doubleEncodedValue.value);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_DOUBLE;
    }

    public int hashCode() {
        return (int)Double.doubleToRawLongBits(this.value);
    }
}

