/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

public class ArrayEncodedSubValue
extends EncodedValue {
    private int hashCode = 0;
    public final EncodedValue[] values;

    public ArrayEncodedSubValue(DexFile dexFile, Input input) {
        this.values = new EncodedValue[input.readUnsignedLeb128()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = EncodedValue.readEncodedValue(dexFile, input);
        }
    }

    public ArrayEncodedSubValue(EncodedValue[] encodedValueArray) {
        this.values = encodedValueArray;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate("array_size: 0x" + Integer.toHexString(this.values.length) + " (" + this.values.length + ")");
            annotatedOutput.writeUnsignedLeb128(this.values.length);
            int n = 0;
            for (EncodedValue encodedValue : this.values) {
                annotatedOutput.annotate(0, "[" + n++ + "] array_element");
                annotatedOutput.indent();
                encodedValue.writeValue(annotatedOutput);
                annotatedOutput.deindent();
            }
        } else {
            annotatedOutput.writeUnsignedLeb128(this.values.length);
            for (EncodedValue encodedValue : this.values) {
                encodedValue.writeValue(annotatedOutput);
            }
        }
    }

    @Override
    public int placeValue(int n) {
        n += Leb128Utils.unsignedLeb128Size(this.values.length);
        for (EncodedValue encodedValue : this.values) {
            n = encodedValue.placeValue(n);
        }
        return n;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        ArrayEncodedSubValue arrayEncodedSubValue = (ArrayEncodedSubValue)encodedValue;
        int n = this.values.length - arrayEncodedSubValue.values.length;
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.values.length; ++i) {
            n = this.values[i].compareTo(arrayEncodedSubValue.values[i]);
            if (n == 0) continue;
            return n;
        }
        return n;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_ARRAY;
    }

    private void calcHashCode() {
        this.hashCode = 0;
        for (EncodedValue encodedValue : this.values) {
            this.hashCode = 31 * this.hashCode + encodedValue.hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }
}

