/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Format.Instruction20t;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Format.Instruction30t;
import org.jf.dexlib.Code.Format.Instruction31c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionIterator;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.Debug.DebugOpcode;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.DebugInfoBuilder;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;
import org.jf.dexlib.Util.SparseArray;
import org.jf.dexlib.Util.SparseIntArray;

public class CodeItem
extends Item<CodeItem> {
    private int registerCount;
    private int inWords;
    private int outWords;
    private DebugInfoItem debugInfo;
    private Instruction[] instructions;
    private TryItem[] tries;
    private EncodedCatchHandler[] encodedCatchHandlers;
    private ClassDataItem.EncodedMethod parent;

    public CodeItem(DexFile dexFile) {
        super(dexFile);
    }

    private CodeItem(DexFile dexFile, int n, int n2, int n3, DebugInfoItem debugInfoItem, Instruction[] instructionArray, TryItem[] tryItemArray, EncodedCatchHandler[] encodedCatchHandlerArray) {
        super(dexFile);
        this.registerCount = n;
        this.inWords = n2;
        this.outWords = n3;
        this.debugInfo = debugInfoItem;
        if (debugInfoItem != null) {
            debugInfoItem.setParent(this);
        }
        this.instructions = instructionArray;
        this.tries = tryItemArray;
        this.encodedCatchHandlers = encodedCatchHandlerArray;
    }

    public static CodeItem internCodeItem(DexFile dexFile, int n, int n2, int n3, DebugInfoItem debugInfoItem, List<Instruction> list, List<TryItem> list2, List<EncodedCatchHandler> list3) {
        TryItem[] tryItemArray = null;
        EncodedCatchHandler[] encodedCatchHandlerArray = null;
        Instruction[] instructionArray = null;
        if (list2 != null && list2.size() > 0) {
            tryItemArray = new TryItem[list2.size()];
            list2.toArray(tryItemArray);
        }
        if (list3 != null && list3.size() > 0) {
            encodedCatchHandlerArray = new EncodedCatchHandler[list3.size()];
            list3.toArray(encodedCatchHandlerArray);
        }
        if (list != null && list.size() > 0) {
            instructionArray = new Instruction[list.size()];
            list.toArray(instructionArray);
        }
        CodeItem codeItem = new CodeItem(dexFile, n, n2, n3, debugInfoItem, instructionArray, tryItemArray, encodedCatchHandlerArray);
        return dexFile.CodeItemsSection.intern(codeItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.registerCount = input.readShort();
        this.inWords = input.readShort();
        this.outWords = input.readShort();
        int n = input.readShort();
        this.debugInfo = (DebugInfoItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_DEBUG_INFO_ITEM, input.readInt());
        if (this.debugInfo != null) {
            this.debugInfo.setParent(this);
        }
        int n2 = input.readInt();
        final ArrayList arrayList = new ArrayList();
        byte[] byArray = input.readBytes(n2 * 2);
        InstructionIterator.IterateInstructions(this.dexFile, byArray, new InstructionIterator.ProcessInstructionDelegate(){

            @Override
            public void ProcessInstruction(int n, Instruction instruction) {
                arrayList.add(instruction);
            }
        });
        this.instructions = new Instruction[arrayList.size()];
        arrayList.toArray(this.instructions);
        if (n > 0) {
            int n3;
            int n4;
            input.alignTo(4);
            int n5 = input.getCursor();
            input.setCursor(n5 + 8 * n);
            int n6 = input.getCursor();
            int n7 = input.readUnsignedLeb128();
            SparseArray<EncodedCatchHandler> sparseArray = new SparseArray<EncodedCatchHandler>(n7);
            this.encodedCatchHandlers = new EncodedCatchHandler[n7];
            for (n4 = 0; n4 < n7; ++n4) {
                try {
                    n3 = input.getCursor() - n6;
                    this.encodedCatchHandlers[n4] = new EncodedCatchHandler(this.dexFile, input);
                    sparseArray.append(n3, this.encodedCatchHandlers[n4]);
                    continue;
                }
                catch (Exception exception) {
                    throw ExceptionWithContext.withContext(exception, "Error while reading EncodedCatchHandler at index " + n4);
                }
            }
            n4 = input.getCursor();
            input.setCursor(n5);
            this.tries = new TryItem[n];
            for (n3 = 0; n3 < n; ++n3) {
                try {
                    this.tries[n3] = new TryItem(input, sparseArray);
                    continue;
                }
                catch (Exception exception) {
                    throw ExceptionWithContext.withContext(exception, "Error while reading TryItem at index " + n3);
                }
            }
            input.setCursor(n4);
        }
    }

    @Override
    protected int placeItem(int n) {
        n += 16 + this.getInstructionsLength() * 2;
        if (this.tries != null && this.tries.length > 0) {
            n = AlignmentUtils.alignOffset(n, 4);
            int n2 = n += this.tries.length * 8;
            n += Leb128Utils.unsignedLeb128Size(this.encodedCatchHandlers.length);
            for (EncodedCatchHandler encodedCatchHandler : this.encodedCatchHandlers) {
                n = encodedCatchHandler.place(n, n2);
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        block16: {
            int n;
            int n2 = this.getInstructionsLength();
            if (annotatedOutput.annotates()) {
                annotatedOutput.annotate(0, this.parent.method.getMethodString());
                annotatedOutput.annotate(2, "registers_size: 0x" + Integer.toHexString(this.registerCount) + " (" + this.registerCount + ")");
                annotatedOutput.annotate(2, "ins_size: 0x" + Integer.toHexString(this.inWords) + " (" + this.inWords + ")");
                annotatedOutput.annotate(2, "outs_size: 0x" + Integer.toHexString(this.outWords) + " (" + this.outWords + ")");
                n = this.tries == null ? 0 : this.tries.length;
                annotatedOutput.annotate(2, "tries_size: 0x" + Integer.toHexString(n) + " (" + n + ")");
                if (this.debugInfo == null) {
                    annotatedOutput.annotate(4, "debug_info_off:");
                } else {
                    annotatedOutput.annotate(4, "debug_info_off: 0x" + this.debugInfo.getOffset());
                }
                annotatedOutput.annotate(4, "insns_size: 0x" + Integer.toHexString(n2) + " (" + n2 + ")");
            }
            annotatedOutput.writeShort(this.registerCount);
            annotatedOutput.writeShort(this.inWords);
            annotatedOutput.writeShort(this.outWords);
            if (this.tries == null) {
                annotatedOutput.writeShort(0);
            } else {
                annotatedOutput.writeShort(this.tries.length);
            }
            if (this.debugInfo == null) {
                annotatedOutput.writeInt(0);
            } else {
                annotatedOutput.writeInt(this.debugInfo.getOffset());
            }
            annotatedOutput.writeInt(n2);
            n = 0;
            for (Instruction object : this.instructions) {
                n = object.write(annotatedOutput, n);
            }
            if (this.tries == null || this.tries.length <= 0) break block16;
            if (annotatedOutput.annotates()) {
                void var7_13;
                void var7_11;
                if (n % 2 != 0) {
                    annotatedOutput.annotate("padding");
                    annotatedOutput.writeShort(0);
                }
                int n3 = 0;
                Object[] objectArray = this.tries;
                int n4 = objectArray.length;
                boolean bl = false;
                while (var7_11 < n4) {
                    TryItem tryItem = objectArray[var7_11];
                    annotatedOutput.annotate(0, "[0x" + Integer.toHexString(n3++) + "] try_item");
                    annotatedOutput.indent();
                    tryItem.writeTo(annotatedOutput);
                    annotatedOutput.deindent();
                    ++var7_11;
                }
                annotatedOutput.annotate("handler_count: 0x" + Integer.toHexString(this.encodedCatchHandlers.length) + "(" + this.encodedCatchHandlers.length + ")");
                annotatedOutput.writeUnsignedLeb128(this.encodedCatchHandlers.length);
                n3 = 0;
                objectArray = this.encodedCatchHandlers;
                n4 = objectArray.length;
                boolean bl2 = false;
                while (var7_13 < n4) {
                    Object object = objectArray[var7_13];
                    annotatedOutput.annotate(0, "[" + Integer.toHexString(n3++) + "] encoded_catch_handler");
                    annotatedOutput.indent();
                    ((EncodedCatchHandler)object).writeTo(annotatedOutput);
                    annotatedOutput.deindent();
                    ++var7_13;
                }
            } else {
                if (n % 2 != 0) {
                    annotatedOutput.writeShort(0);
                }
                for (TryItem tryItem : this.tries) {
                    tryItem.writeTo(annotatedOutput);
                }
                annotatedOutput.writeUnsignedLeb128(this.encodedCatchHandlers.length);
                for (EncodedCatchHandler encodedCatchHandler : this.encodedCatchHandlers) {
                    encodedCatchHandler.writeTo(annotatedOutput);
                }
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_CODE_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        if (this.parent == null) {
            return "code_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "code_item @0x" + Integer.toHexString(this.getOffset()) + " (" + this.parent.method.getMethodString() + ")";
    }

    @Override
    public int compareTo(CodeItem codeItem) {
        if (this.parent == null) {
            if (codeItem.parent == null) {
                return 0;
            }
            return -1;
        }
        if (codeItem.parent == null) {
            return 1;
        }
        return this.parent.method.compareTo(codeItem.parent.method);
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public Instruction[] getInstructions() {
        return this.instructions;
    }

    public TryItem[] getTries() {
        return this.tries;
    }

    public EncodedCatchHandler[] getHandlers() {
        return this.encodedCatchHandlers;
    }

    public DebugInfoItem getDebugInfo() {
        return this.debugInfo;
    }

    protected void setParent(ClassDataItem.EncodedMethod encodedMethod) {
        this.parent = encodedMethod;
    }

    public ClassDataItem.EncodedMethod getParent() {
        return this.parent;
    }

    public void updateCode(Instruction[] instructionArray) {
        this.instructions = instructionArray;
    }

    private int getInstructionsLength() {
        int n = 0;
        for (Instruction instruction : this.instructions) {
            n += instruction.getSize(n);
        }
        return n;
    }

    public void fixInstructions(boolean bl, boolean bl2) {
        try {
            boolean bl3 = false;
            block4: do {
                bl3 = false;
                int n = 0;
                for (int i = 0; i < this.instructions.length; ++i) {
                    Instruction instruction = this.instructions[i];
                    try {
                        Instruction21c instruction21c;
                        if (bl2 && instruction.opcode == Opcode.GOTO) {
                            int n2 = ((OffsetInstruction)((Object)instruction)).getTargetAddressOffset();
                            if ((byte)n2 != n2) {
                                if ((short)n2 == n2) {
                                    this.replaceInstructionAtAddress(n, new Instruction20t(Opcode.GOTO_16, n2));
                                } else {
                                    this.replaceInstructionAtAddress(n, new Instruction30t(Opcode.GOTO_32, n2));
                                }
                                bl3 = true;
                                continue block4;
                            }
                        } else if (bl2 && instruction.opcode == Opcode.GOTO_16) {
                            int n3 = ((OffsetInstruction)((Object)instruction)).getTargetAddressOffset();
                            if ((short)n3 != n3) {
                                this.replaceInstructionAtAddress(n, new Instruction30t(Opcode.GOTO_32, n3));
                                bl3 = true;
                                continue block4;
                            }
                        } else if (bl && instruction.opcode == Opcode.CONST_STRING && (instruction21c = (Instruction21c)instruction).getReferencedItem().getIndex() > 65535) {
                            this.replaceInstructionAtAddress(n, new Instruction31c(Opcode.CONST_STRING_JUMBO, (short)instruction21c.getRegisterA(), instruction21c.getReferencedItem()));
                            bl3 = true;
                            continue block4;
                        }
                        n += instruction.getSize(n);
                        continue;
                    }
                    catch (Exception exception) {
                        throw ExceptionWithContext.withContext(exception, "Error while attempting to fix " + instruction.opcode.name + " instruction at address " + n);
                    }
                }
            } while (bl3);
        }
        catch (Exception exception) {
            throw this.addExceptionContext(exception);
        }
    }

    private void replaceInstructionAtAddress(int n, Instruction instruction) {
        int n2;
        Object object;
        Object object2;
        int n3;
        Instruction instruction2 = null;
        int[] nArray = new int[this.instructions.length + 1];
        SparseIntArray sparseIntArray = new SparseIntArray();
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.instructions.length; ++n3) {
            int n6;
            object2 = this.instructions[n3];
            if (n4 == n) {
                instruction2 = object2;
                n5 = n3;
            }
            if ((((Instruction)object2).opcode == Opcode.PACKED_SWITCH || ((Instruction)object2).opcode == Opcode.SPARSE_SWITCH) && sparseIntArray.indexOfKey(n6 = n4 + (object = (OffsetInstruction)object2).getTargetAddressOffset()) < 0) {
                sparseIntArray.put(n6, n4);
            }
            nArray[n3] = n4;
            n4 += ((Instruction)object2).getSize(n4);
        }
        nArray[n3] = n4;
        if (instruction2 == null) {
            throw new RuntimeException("There is no instruction at address " + n);
        }
        this.instructions[n5] = instruction;
        if (instruction2.getSize(n) == instruction.getSize(n)) {
            return;
        }
        object2 = new SparseIntArray();
        object = new SparseIntArray();
        n4 = 0;
        for (n3 = 0; n3 < this.instructions.length; ++n3) {
            Instruction instruction3 = this.instructions[n3];
            int n7 = nArray[n3];
            ((SparseIntArray)object2).append(n4, n7);
            ((SparseIntArray)object).append(n7, n4);
            n4 += instruction3.getSize(n4);
        }
        ((SparseIntArray)object2).append(n4, nArray[n3]);
        ((SparseIntArray)object).append(nArray[n3], n4);
        n4 = 0;
        for (n3 = 0; n3 < this.instructions.length; ++n3) {
            int n8;
            int n9;
            int n10;
            Object object3;
            Instruction instruction4 = this.instructions[n3];
            if (instruction4 instanceof OffsetInstruction) {
                object3 = (OffsetInstruction)((Object)instruction4);
                assert (((SparseIntArray)object2).indexOfKey(n4) >= 0);
                n10 = ((SparseIntArray)object2).get(n4);
                n9 = n10 + object3.getTargetAddressOffset();
                assert (((SparseIntArray)object).indexOfKey(n9) >= 0);
                n8 = ((SparseIntArray)object).get(n9);
                n2 = n8 - n4;
                if (n2 != object3.getTargetAddressOffset()) {
                    object3.updateTargetAddressOffset(n2);
                }
            } else if (instruction4 instanceof MultiOffsetInstruction) {
                object3 = (MultiOffsetInstruction)((Object)instruction4);
                assert (((SparseIntArray)object2).indexOfKey(n4) >= 0);
                n10 = ((SparseIntArray)object2).get(n4);
                n9 = sparseIntArray.get(n10, -1);
                if (n9 == -1) {
                    throw new RuntimeException("This method contains an unreferenced switch data block at address " + n4 + " and can't be automatically fixed.");
                }
                assert (((SparseIntArray)object).indexOfKey(n9) >= 0);
                n8 = ((SparseIntArray)object).get(n9);
                int[] nArray2 = object3.getTargets();
                for (int i = 0; i < nArray2.length; ++i) {
                    int n11 = n9 + nArray2[i];
                    assert (((SparseIntArray)object).indexOfKey(n11) >= 0);
                    int n12 = ((SparseIntArray)object).get(n11);
                    int n13 = n12 - n8;
                    if (n13 == nArray2[i]) continue;
                    object3.updateTarget(i, n13);
                }
            }
            n4 += instruction4.getSize(n4);
        }
        if (this.debugInfo != null) {
            byte[] byArray = this.debugInfo.getEncodedDebugInfo();
            ByteArrayInput byteArrayInput = new ByteArrayInput(byArray);
            DebugInstructionFixer debugInstructionFixer = new DebugInstructionFixer(byArray, (SparseIntArray)object);
            DebugInstructionIterator.IterateInstructions(byteArrayInput, debugInstructionFixer);
            if (debugInstructionFixer.result != null) {
                this.debugInfo.setEncodedDebugInfo(debugInstructionFixer.result);
            }
        }
        if (this.encodedCatchHandlers != null) {
            for (EncodedCatchHandler encodedCatchHandler : this.encodedCatchHandlers) {
                if (encodedCatchHandler.catchAllHandlerAddress != -1) {
                    assert (((SparseIntArray)object).indexOfKey(encodedCatchHandler.catchAllHandlerAddress) >= 0);
                    encodedCatchHandler.catchAllHandlerAddress = ((SparseIntArray)object).get(encodedCatchHandler.catchAllHandlerAddress);
                }
                for (EncodedTypeAddrPair encodedTypeAddrPair : encodedCatchHandler.handlers) {
                    assert (((SparseIntArray)object).indexOfKey(encodedTypeAddrPair.handlerAddress) >= 0);
                    encodedTypeAddrPair.handlerAddress = ((SparseIntArray)object).get(encodedTypeAddrPair.handlerAddress);
                }
            }
        }
        if (this.tries != null) {
            for (TryItem tryItem : this.tries) {
                int n14 = tryItem.startCodeAddress;
                n2 = tryItem.startCodeAddress + tryItem.tryLength;
                assert (((SparseIntArray)object).indexOfKey(n14) >= 0);
                tryItem.startCodeAddress = ((SparseIntArray)object).get(n14);
                assert (((SparseIntArray)object).indexOfKey(n2) >= 0);
                tryItem.tryLength = ((SparseIntArray)object).get(n2) - tryItem.startCodeAddress;
            }
        }
    }

    public static class EncodedTypeAddrPair {
        public final TypeIdItem exceptionType;
        private int handlerAddress;

        public EncodedTypeAddrPair(TypeIdItem typeIdItem, int n) {
            this.exceptionType = typeIdItem;
            this.handlerAddress = n;
        }

        private EncodedTypeAddrPair(DexFile dexFile, Input input) {
            this.exceptionType = dexFile.TypeIdsSection.getItemByIndex(input.readUnsignedLeb128());
            this.handlerAddress = input.readUnsignedLeb128();
        }

        private int getSize() {
            return Leb128Utils.unsignedLeb128Size(this.exceptionType.getIndex()) + Leb128Utils.unsignedLeb128Size(this.handlerAddress);
        }

        private void writeTo(AnnotatedOutput annotatedOutput) {
            if (annotatedOutput.annotates()) {
                annotatedOutput.annotate("exception_type: " + this.exceptionType.getTypeDescriptor());
                annotatedOutput.writeUnsignedLeb128(this.exceptionType.getIndex());
                annotatedOutput.annotate("handler_addr: 0x" + Integer.toHexString(this.handlerAddress));
                annotatedOutput.writeUnsignedLeb128(this.handlerAddress);
            } else {
                annotatedOutput.writeUnsignedLeb128(this.exceptionType.getIndex());
                annotatedOutput.writeUnsignedLeb128(this.handlerAddress);
            }
        }

        public int getHandlerAddress() {
            return this.handlerAddress;
        }

        public int hashCode() {
            return this.exceptionType.hashCode() * 31 + this.handlerAddress;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            EncodedTypeAddrPair encodedTypeAddrPair = (EncodedTypeAddrPair)object;
            return this.exceptionType == encodedTypeAddrPair.exceptionType && this.handlerAddress == encodedTypeAddrPair.handlerAddress;
        }
    }

    public static class EncodedCatchHandler {
        public final EncodedTypeAddrPair[] handlers;
        private int catchAllHandlerAddress;
        private int baseOffset;
        private int offset;

        public EncodedCatchHandler(EncodedTypeAddrPair[] encodedTypeAddrPairArray, int n) {
            this.handlers = encodedTypeAddrPairArray;
            this.catchAllHandlerAddress = n;
        }

        private EncodedCatchHandler(DexFile dexFile, Input input) {
            int n = input.readSignedLeb128();
            this.handlers = n < 0 ? new EncodedTypeAddrPair[-1 * n] : new EncodedTypeAddrPair[n];
            for (int i = 0; i < this.handlers.length; ++i) {
                try {
                    this.handlers[i] = new EncodedTypeAddrPair(dexFile, input);
                    continue;
                }
                catch (Exception exception) {
                    throw ExceptionWithContext.withContext(exception, "Error while reading EncodedTypeAddrPair at index " + i);
                }
            }
            this.catchAllHandlerAddress = n <= 0 ? input.readUnsignedLeb128() : -1;
        }

        public int getCatchAllHandlerAddress() {
            return this.catchAllHandlerAddress;
        }

        private int getOffsetInList() {
            return this.offset - this.baseOffset;
        }

        private int place(int n, int n2) {
            this.offset = n;
            this.baseOffset = n2;
            int n3 = this.handlers.length;
            if (this.catchAllHandlerAddress > -1) {
                n3 *= -1;
                n += Leb128Utils.unsignedLeb128Size(this.catchAllHandlerAddress);
            }
            n += Leb128Utils.signedLeb128Size(n3);
            for (EncodedTypeAddrPair encodedTypeAddrPair : this.handlers) {
                n += encodedTypeAddrPair.getSize();
            }
            return n;
        }

        private void writeTo(AnnotatedOutput annotatedOutput) {
            if (annotatedOutput.annotates()) {
                annotatedOutput.annotate("size: 0x" + Integer.toHexString(this.handlers.length) + " (" + this.handlers.length + ")");
                int n = this.handlers.length;
                if (this.catchAllHandlerAddress > -1) {
                    n *= -1;
                }
                annotatedOutput.writeSignedLeb128(n);
                int n2 = 0;
                for (EncodedTypeAddrPair encodedTypeAddrPair : this.handlers) {
                    annotatedOutput.annotate(0, "[" + n2++ + "] encoded_type_addr_pair");
                    annotatedOutput.indent();
                    encodedTypeAddrPair.writeTo(annotatedOutput);
                    annotatedOutput.deindent();
                }
                if (this.catchAllHandlerAddress > -1) {
                    annotatedOutput.annotate("catch_all_addr: 0x" + Integer.toHexString(this.catchAllHandlerAddress));
                    annotatedOutput.writeUnsignedLeb128(this.catchAllHandlerAddress);
                }
            } else {
                int n = this.handlers.length;
                if (this.catchAllHandlerAddress > -1) {
                    n *= -1;
                }
                annotatedOutput.writeSignedLeb128(n);
                for (EncodedTypeAddrPair encodedTypeAddrPair : this.handlers) {
                    encodedTypeAddrPair.writeTo(annotatedOutput);
                }
                if (this.catchAllHandlerAddress > -1) {
                    annotatedOutput.writeUnsignedLeb128(this.catchAllHandlerAddress);
                }
            }
        }

        public int hashCode() {
            int n = 0;
            for (EncodedTypeAddrPair encodedTypeAddrPair : this.handlers) {
                n = n * 31 + encodedTypeAddrPair.hashCode();
            }
            n = n * 31 + this.catchAllHandlerAddress;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            EncodedCatchHandler encodedCatchHandler = (EncodedCatchHandler)object;
            if (this.handlers.length != encodedCatchHandler.handlers.length || this.catchAllHandlerAddress != encodedCatchHandler.catchAllHandlerAddress) {
                return false;
            }
            for (int i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i].equals(encodedCatchHandler.handlers[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class TryItem {
        private int startCodeAddress;
        private int tryLength;
        public final EncodedCatchHandler encodedCatchHandler;

        public TryItem(int n, int n2, EncodedCatchHandler encodedCatchHandler) {
            this.startCodeAddress = n;
            this.tryLength = n2;
            this.encodedCatchHandler = encodedCatchHandler;
        }

        private TryItem(Input input, SparseArray<EncodedCatchHandler> sparseArray) {
            this.startCodeAddress = input.readInt();
            this.tryLength = input.readShort();
            this.encodedCatchHandler = sparseArray.get(input.readShort());
            if (this.encodedCatchHandler == null) {
                throw new RuntimeException("Could not find the EncodedCatchHandler referenced by this TryItem");
            }
        }

        private void writeTo(AnnotatedOutput annotatedOutput) {
            if (annotatedOutput.annotates()) {
                annotatedOutput.annotate(4, "start_addr: 0x" + Integer.toHexString(this.startCodeAddress));
                annotatedOutput.annotate(2, "try_length: 0x" + Integer.toHexString(this.tryLength) + " (" + this.tryLength + ")");
                annotatedOutput.annotate(2, "handler_off: 0x" + Integer.toHexString(this.encodedCatchHandler.getOffsetInList()));
            }
            annotatedOutput.writeInt(this.startCodeAddress);
            annotatedOutput.writeShort(this.tryLength);
            annotatedOutput.writeShort(this.encodedCatchHandler.getOffsetInList());
        }

        public int getStartCodeAddress() {
            return this.startCodeAddress;
        }

        public int getTryLength() {
            return this.tryLength;
        }
    }

    private class DebugInstructionFixer
    extends DebugInstructionIterator.ProcessRawDebugInstructionDelegate {
        private int currentCodeAddress = 0;
        private SparseIntArray newAddressByOriginalAddress;
        private final byte[] originalEncodedDebugInfo;
        public byte[] result = null;

        public DebugInstructionFixer(byte[] byArray, SparseIntArray sparseIntArray) {
            this.newAddressByOriginalAddress = sparseIntArray;
            this.originalEncodedDebugInfo = byArray;
        }

        @Override
        public void ProcessAdvancePC(int n, int n2, int n3) {
            this.currentCodeAddress += n3;
            if (this.result != null) {
                return;
            }
            int n4 = this.newAddressByOriginalAddress.get(this.currentCodeAddress, -1);
            if (n4 == -1) {
                return;
            }
            if (n4 != this.currentCodeAddress) {
                int n5 = n4 - (this.currentCodeAddress - n3);
                assert (n5 > 0);
                int n6 = Leb128Utils.unsignedLeb128Size(n5);
                if (n6 + 1 == n2) {
                    this.result = this.originalEncodedDebugInfo;
                    Leb128Utils.writeUnsignedLeb128(n5, this.result, n + 1);
                } else {
                    this.result = new byte[this.originalEncodedDebugInfo.length + n6 - (n2 - 1)];
                    System.arraycopy(this.originalEncodedDebugInfo, 0, this.result, 0, n);
                    this.result[n] = DebugOpcode.DBG_ADVANCE_PC.value;
                    Leb128Utils.writeUnsignedLeb128(n5, this.result, n + 1);
                    System.arraycopy(this.originalEncodedDebugInfo, n + n2, this.result, n + n6 + 1, this.originalEncodedDebugInfo.length - (n + n6 + 1));
                }
            }
        }

        @Override
        public void ProcessSpecialOpcode(int n, int n2, int n3, int n4) {
            this.currentCodeAddress += n4;
            if (this.result != null) {
                return;
            }
            int n5 = this.newAddressByOriginalAddress.get(this.currentCodeAddress, -1);
            assert (n5 != -1);
            if (n5 != this.currentCodeAddress) {
                int n6 = n5 - (this.currentCodeAddress - n4);
                assert (n6 > 0);
                if (n3 < 2 && n6 > 16 || n3 > 1 && n6 > 15) {
                    int n7 = n5 - this.currentCodeAddress;
                    int n8 = Leb128Utils.signedLeb128Size(n7);
                    this.result = new byte[this.originalEncodedDebugInfo.length + n8 + 1];
                    System.arraycopy(this.originalEncodedDebugInfo, 0, this.result, 0, n);
                    this.result[n] = 1;
                    Leb128Utils.writeUnsignedLeb128(n7, this.result, n + 1);
                    System.arraycopy(this.originalEncodedDebugInfo, n, this.result, n + n8 + 1, this.result.length - (n + n8 + 1));
                } else {
                    this.result = this.originalEncodedDebugInfo;
                    this.result[n] = DebugInfoBuilder.calculateSpecialOpcode(n3, n6);
                }
            }
        }
    }
}

