/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.NumberUtils;

public abstract class InstructionWithReference
extends Instruction {
    private Item referencedItem;

    protected InstructionWithReference(Opcode opcode, Item item) {
        super(opcode);
        this.referencedItem = item;
        this.checkReferenceType();
    }

    protected InstructionWithReference(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        int n2 = this.getReferencedItemIndex(byArray, n);
        this.lookupReferencedItem(dexFile, opcode, n2);
    }

    protected int getReferencedItemIndex(byte[] byArray, int n) {
        return NumberUtils.decodeUnsignedShort(byArray, n + 2);
    }

    public Item getReferencedItem() {
        return this.referencedItem;
    }

    private void lookupReferencedItem(DexFile dexFile, Opcode opcode, int n) {
        switch (opcode.referenceType) {
            case field: {
                this.referencedItem = dexFile.FieldIdsSection.getItemByIndex(n);
                return;
            }
            case method: {
                this.referencedItem = dexFile.MethodIdsSection.getItemByIndex(n);
                return;
            }
            case type: {
                this.referencedItem = dexFile.TypeIdsSection.getItemByIndex(n);
                return;
            }
            case string: {
                this.referencedItem = dexFile.StringIdsSection.getItemByIndex(n);
            }
        }
    }

    private void checkReferenceType() {
        switch (this.opcode.referenceType) {
            case field: {
                if (!(this.referencedItem instanceof FieldIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting FieldIdItem.");
                }
                return;
            }
            case method: {
                if (!(this.referencedItem instanceof MethodIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting MethodIdItem.");
                }
                return;
            }
            case type: {
                if (!(this.referencedItem instanceof TypeIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting TypeIdItem.");
                }
                return;
            }
            case string: {
                if (!(this.referencedItem instanceof StringIdItem)) {
                    throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is the wrong item type for opcode " + this.opcode.name + ". Expecting StringIdItem.");
                }
                return;
            }
        }
        if (this.referencedItem != null) {
            throw new RuntimeException(this.referencedItem.getClass().getSimpleName() + " is invalid for opcode " + this.opcode.name + ". This opcode does not reference an item");
        }
    }
}

