/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import java.util.Iterator;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class SparseSwitchDataPseudoInstruction
extends Instruction
implements MultiOffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int[] keys;
    private int[] targets;

    @Override
    public int getSize(int n) {
        return this.getTargetCount() * 4 + 2 + n % 2;
    }

    public SparseSwitchDataPseudoInstruction(int[] nArray, int[] nArray2) {
        super(Opcode.NOP);
        if (nArray.length != nArray2.length) {
            throw new RuntimeException("The number of keys and targets don't match");
        }
        if (nArray2.length == 0) {
            throw new RuntimeException("The sparse-switch data must contain at least 1 key/target");
        }
        if (nArray2.length > 65535) {
            throw new RuntimeException("The sparse-switch data contains too many elements. The maximum number of switch elements is 65535");
        }
        this.keys = nArray;
        this.targets = nArray2;
    }

    public SparseSwitchDataPseudoInstruction(byte[] byArray, int n) {
        super(Opcode.NOP);
        byte by = byArray[n];
        if (by != 0) {
            throw new RuntimeException("Invalid opcode byte for a SparseSwitchData pseudo-instruction");
        }
        byte by2 = byArray[n + 1];
        if (by2 != 2) {
            throw new RuntimeException("Invalid sub-opcode byte for a SparseSwitchData pseudo-instruction");
        }
        int n2 = NumberUtils.decodeUnsignedShort(byArray, n + 2);
        this.keys = new int[n2];
        this.targets = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.keys[i] = NumberUtils.decodeInt(byArray, n + 4 + i * 4);
            this.targets[i] = NumberUtils.decodeInt(byArray, n + 4 + n2 * 4 + i * 4);
        }
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.alignTo(4);
        annotatedOutput.writeByte(0);
        annotatedOutput.writeByte(2);
        annotatedOutput.writeShort(this.targets.length);
        if (this.targets.length > 0) {
            int n2 = this.keys[0];
            annotatedOutput.writeInt(n2);
            for (int i = 1; i < this.keys.length; ++i) {
                n2 = this.keys[i];
                assert (n2 >= this.keys[i - 1]);
                annotatedOutput.writeInt(n2);
            }
            for (int n3 : this.targets) {
                annotatedOutput.writeInt(n3);
            }
        }
    }

    @Override
    protected void annotateInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.annotate(this.getSize(n) * 2, "[0x" + Integer.toHexString(n) + "] " + "sparse-switch-data instruction");
    }

    @Override
    public void updateTarget(int n, int n2) {
        this.targets[n] = n2;
    }

    @Override
    public Format getFormat() {
        return Format.SparseSwitchData;
    }

    public int getTargetCount() {
        return this.targets.length;
    }

    @Override
    public int[] getTargets() {
        return this.targets;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public Iterator<SparseSwitchTarget> iterateKeysAndTargets() {
        return new Iterator<SparseSwitchTarget>(){
            final int targetCount;
            int i;
            SparseSwitchTarget sparseSwitchTarget;
            {
                this.targetCount = SparseSwitchDataPseudoInstruction.this.getTargetCount();
                this.i = 0;
                this.sparseSwitchTarget = new SparseSwitchTarget();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.targetCount;
            }

            @Override
            public SparseSwitchTarget next() {
                this.sparseSwitchTarget.key = SparseSwitchDataPseudoInstruction.this.keys[this.i];
                this.sparseSwitchTarget.targetAddressOffset = SparseSwitchDataPseudoInstruction.this.targets[this.i];
                ++this.i;
                return this.sparseSwitchTarget;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            if (opcode != Opcode.NOP) {
                throw new RuntimeException("The opcode for a SparseSwitchDataPseudoInstruction must be NOP");
            }
            return new SparseSwitchDataPseudoInstruction(byArray, n);
        }
    }

    public static class SparseSwitchTarget {
        public int key;
        public int targetAddressOffset;
    }
}

