/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;

public class Instruction10t
extends Instruction
implements OffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int targetAddressOffset;

    public Instruction10t(Opcode opcode, int n) {
        super(opcode);
        this.targetAddressOffset = n;
        if (this.targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0. Use goto/32 instead.");
        }
    }

    private Instruction10t(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        assert (byArray[n] == opcode.value);
        this.targetAddressOffset = byArray[n + 1];
        assert (this.targetAddressOffset != 0);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        if (this.targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0. Use goto/32 instead");
        }
        if (this.targetAddressOffset < -128 || this.targetAddressOffset > 127) {
            throw new RuntimeException("The address offset is out of range. It must be in [-128,-1] or [1, 127]");
        }
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.targetAddressOffset);
    }

    @Override
    public void updateTargetAddressOffset(int n) {
        this.targetAddressOffset = n;
    }

    @Override
    public Format getFormat() {
        return Format.Format10t;
    }

    @Override
    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction10t(opcode, byArray, n);
        }
    }
}

