/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.TypeIdItem;

public class RegisterType {
    private static final HashMap<RegisterType, RegisterType> internedRegisterTypes = new HashMap();
    public final Category category;
    public final ClassPath.ClassDef type;

    private RegisterType(Category category, ClassPath.ClassDef classDef) {
        assert ((category == Category.Reference || category == Category.UninitRef || category == Category.UninitThis) && classDef != null || category != Category.Reference && category != Category.UninitRef && category != Category.UninitThis && classDef == null);
        this.category = category;
        this.type = classDef;
    }

    public String toString() {
        return "(" + this.category.name() + (this.type == null ? "" : "," + this.type.getClassType()) + ")";
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this.category.name());
        if (this.type != null) {
            writer.write(44);
            writer.write(this.type.getClassType());
        }
        writer.write(41);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegisterType registerType = (RegisterType)object;
        if (this.category != registerType.category) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(registerType.type) : registerType.type != null);
    }

    public int hashCode() {
        int n = this.category.hashCode();
        n = 31 * n + (this.type != null ? this.type.hashCode() : 0);
        return n;
    }

    public static RegisterType getRegisterTypeForType(String string) {
        switch (string.charAt(0)) {
            case 'V': {
                throw new ValidationException("The V type can only be used as a method return type");
            }
            case 'Z': {
                return RegisterType.getRegisterType(Category.Boolean, null);
            }
            case 'B': {
                return RegisterType.getRegisterType(Category.Byte, null);
            }
            case 'S': {
                return RegisterType.getRegisterType(Category.Short, null);
            }
            case 'C': {
                return RegisterType.getRegisterType(Category.Char, null);
            }
            case 'I': {
                return RegisterType.getRegisterType(Category.Integer, null);
            }
            case 'F': {
                return RegisterType.getRegisterType(Category.Float, null);
            }
            case 'J': {
                return RegisterType.getRegisterType(Category.LongLo, null);
            }
            case 'D': {
                return RegisterType.getRegisterType(Category.DoubleLo, null);
            }
            case 'L': 
            case '[': {
                return RegisterType.getRegisterType(Category.Reference, ClassPath.getClassDef(string));
            }
        }
        throw new RuntimeException("Invalid type: " + string);
    }

    public static RegisterType getRegisterTypeForTypeIdItem(TypeIdItem typeIdItem) {
        return RegisterType.getRegisterTypeForType(typeIdItem.getTypeDescriptor());
    }

    public static RegisterType getWideRegisterTypeForTypeIdItem(TypeIdItem typeIdItem, boolean bl) {
        if (typeIdItem.getRegisterCount() == 1) {
            throw new RuntimeException("Cannot use this method for non-wide register type: " + typeIdItem.getTypeDescriptor());
        }
        switch (typeIdItem.getTypeDescriptor().charAt(0)) {
            case 'J': {
                if (bl) {
                    return RegisterType.getRegisterType(Category.LongLo, null);
                }
                return RegisterType.getRegisterType(Category.LongHi, null);
            }
            case 'D': {
                if (bl) {
                    return RegisterType.getRegisterType(Category.DoubleLo, null);
                }
                return RegisterType.getRegisterType(Category.DoubleHi, null);
            }
        }
        throw new RuntimeException("Invalid type: " + typeIdItem.getTypeDescriptor());
    }

    public static RegisterType getRegisterTypeForLiteral(long l) {
        if (l < -32768L) {
            return RegisterType.getRegisterType(Category.Integer, null);
        }
        if (l < -128L) {
            return RegisterType.getRegisterType(Category.Short, null);
        }
        if (l < 0L) {
            return RegisterType.getRegisterType(Category.Byte, null);
        }
        if (l == 0L) {
            return RegisterType.getRegisterType(Category.Null, null);
        }
        if (l == 1L) {
            return RegisterType.getRegisterType(Category.One, null);
        }
        if (l < 128L) {
            return RegisterType.getRegisterType(Category.PosByte, null);
        }
        if (l < 32768L) {
            return RegisterType.getRegisterType(Category.PosShort, null);
        }
        if (l < 65536L) {
            return RegisterType.getRegisterType(Category.Char, null);
        }
        return RegisterType.getRegisterType(Category.Integer, null);
    }

    public RegisterType merge(RegisterType registerType) {
        if (registerType == null || registerType == this) {
            return this;
        }
        Category category = Category.mergeTable[this.category.ordinal()][registerType.category.ordinal()];
        ClassPath.ClassDef classDef = null;
        if (category == Category.Reference) {
            classDef = ClassPath.getCommonSuperclass(this.type, registerType.type);
        }
        if (category == Category.UninitRef || category == Category.UninitThis) {
            if (this.category == Category.Unknown) {
                return registerType;
            }
            assert (registerType.category == Category.Unknown);
            return this;
        }
        return RegisterType.getRegisterType(category, classDef);
    }

    public boolean canBeAssignedTo(RegisterType registerType) {
        if (Category.assigmentTable[this.category.ordinal()][registerType.category.ordinal()]) {
            if (this.category == Category.Reference && registerType.category == Category.Reference && !registerType.type.isInterface()) {
                return this.type.extendsClass(registerType.type);
            }
            return true;
        }
        return false;
    }

    public static RegisterType getUnitializedReference(ClassPath.ClassDef classDef) {
        return new RegisterType(Category.UninitRef, classDef);
    }

    public static RegisterType getRegisterType(Category category, ClassPath.ClassDef classDef) {
        RegisterType registerType = new RegisterType(category, classDef);
        RegisterType registerType2 = internedRegisterTypes.get(registerType);
        if (registerType2 == null) {
            internedRegisterTypes.put(registerType, registerType);
            return registerType;
        }
        return registerType2;
    }

    public static enum Category {
        Unknown,
        Uninit,
        Null,
        One,
        Boolean,
        Byte,
        PosByte,
        Short,
        PosShort,
        Char,
        Integer,
        Float,
        LongLo,
        LongHi,
        DoubleLo,
        DoubleHi,
        UninitRef,
        UninitThis,
        Reference,
        Conflicted;

        protected static Category[][] mergeTable;
        protected static boolean[][] assigmentTable;

        static {
            mergeTable = new Category[][]{{Unknown, Uninit, Null, One, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, LongLo, LongHi, DoubleLo, DoubleHi, UninitRef, UninitThis, Reference, Conflicted}, {Uninit, Uninit, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Null, Conflicted, Null, Boolean, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Reference, Conflicted}, {One, Conflicted, Boolean, One, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Boolean, Conflicted, Boolean, Boolean, Boolean, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Byte, Conflicted, Byte, Byte, Byte, Byte, Byte, Short, Short, Integer, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {PosByte, Conflicted, PosByte, PosByte, PosByte, Byte, PosByte, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Short, Conflicted, Short, Short, Short, Short, Short, Short, Short, Integer, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {PosShort, Conflicted, PosShort, PosShort, PosShort, Short, PosShort, Short, PosShort, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Char, Conflicted, Char, Char, Char, Integer, Char, Integer, Char, Char, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Integer, Conflicted, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {Float, Conflicted, Float, Float, Float, Float, Float, Float, Float, Float, Integer, Float, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {LongLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongLo, Conflicted, LongLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {LongHi, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongHi, Conflicted, LongHi, Conflicted, Conflicted, Conflicted, Conflicted}, {DoubleLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongLo, Conflicted, DoubleLo, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {DoubleHi, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, LongHi, Conflicted, DoubleHi, Conflicted, Conflicted, Conflicted, Conflicted}, {UninitRef, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}, {UninitThis, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, UninitThis, Conflicted, Conflicted}, {Reference, Conflicted, Reference, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Reference, Conflicted}, {Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted, Conflicted}};
            assigmentTable = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, false}, {false, false, false, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, true, false, true, true, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
        }
    }
}

