/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.List;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class AnnotationSetRefList
extends Item<AnnotationSetRefList> {
    private int hashCode = 0;
    private AnnotationSetItem[] annotationSets;

    protected AnnotationSetRefList(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationSetRefList(DexFile dexFile, AnnotationSetItem[] annotationSetItemArray) {
        super(dexFile);
        this.annotationSets = annotationSetItemArray;
    }

    public static AnnotationSetRefList internAnnotationSetRefList(DexFile dexFile, List<AnnotationSetItem> list) {
        AnnotationSetItem[] annotationSetItemArray = new AnnotationSetItem[list.size()];
        list.toArray(annotationSetItemArray);
        AnnotationSetRefList annotationSetRefList = new AnnotationSetRefList(dexFile, annotationSetItemArray);
        return dexFile.AnnotationSetRefListsSection.intern(annotationSetRefList);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.annotationSets = new AnnotationSetItem[input.readInt()];
        for (int i = 0; i < this.annotationSets.length; ++i) {
            this.annotationSets[i] = (AnnotationSetItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, input.readInt());
        }
    }

    @Override
    protected int placeItem(int n) {
        return n + 4 + this.annotationSets.length * 4;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "size: 0x" + Integer.toHexString(this.annotationSets.length) + " (" + this.annotationSets.length + ")");
            for (AnnotationSetItem annotationSetItem : this.annotationSets) {
                annotatedOutput.annotate(4, "annotation_set_off: 0x" + Integer.toHexString(annotationSetItem.getOffset()));
            }
        }
        annotatedOutput.writeInt(this.annotationSets.length);
        for (AnnotationSetItem annotationSetItem : this.annotationSets) {
            annotatedOutput.writeInt(annotationSetItem.getOffset());
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATION_SET_REF_LIST;
    }

    @Override
    public String getConciseIdentity() {
        return "annotation_set_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(AnnotationSetRefList annotationSetRefList) {
        int n = this.annotationSets.length - annotationSetRefList.annotationSets.length;
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.annotationSets.length; ++i) {
            n = this.annotationSets[i].compareTo(annotationSetRefList.annotationSets[i]);
            if (n == 0) continue;
            return n;
        }
        return n;
    }

    public AnnotationSetItem[] getAnnotationSets() {
        return this.annotationSets;
    }

    private void calcHashCode() {
        this.hashCode = 0;
        for (AnnotationSetItem annotationSetItem : this.annotationSets) {
            this.hashCode = this.hashCode * 31 + annotationSetItem.hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AnnotationSetRefList annotationSetRefList = (AnnotationSetRefList)object;
        return this.compareTo(annotationSetRefList) == 0;
    }
}

