/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.BitSet;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.RegisterType;

public class PostInstructionRegisterInfoMethodItem
extends MethodItem {
    private final AnalyzedInstruction analyzedInstruction;
    private final MethodAnalyzer methodAnalyzer;

    public PostInstructionRegisterInfoMethodItem(AnalyzedInstruction analyzedInstruction, MethodAnalyzer methodAnalyzer, int n) {
        super(n);
        this.analyzedInstruction = analyzedInstruction;
        this.methodAnalyzer = methodAnalyzer;
    }

    @Override
    public double getSortOrder() {
        return 100.1;
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        int n = baksmali.registerInfo;
        int n2 = this.analyzedInstruction.getRegisterCount();
        BitSet bitSet = new BitSet(n2);
        if ((n & 1) != 0) {
            bitSet.set(0, n2);
        } else if ((n & 4) != 0) {
            bitSet.set(0, n2);
        } else if ((n & 0x10) != 0) {
            this.addDestRegs(bitSet, n2);
        }
        return this.writeRegisterInfo(indentingWriter, bitSet);
    }

    private void addDestRegs(BitSet bitSet, int n) {
        for (int i = 0; i < n; ++i) {
            if (this.analyzedInstruction.getPreInstructionRegisterType(i) == this.analyzedInstruction.getPostInstructionRegisterType(i)) continue;
            bitSet.set(i);
        }
    }

    private boolean writeRegisterInfo(IndentingWriter indentingWriter, BitSet bitSet) throws IOException {
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        int n = bitSet.nextSetBit(0);
        if (n < 0) {
            return false;
        }
        indentingWriter.write(35);
        while (n >= 0) {
            RegisterType registerType = this.analyzedInstruction.getPostInstructionRegisterType(n);
            RegisterFormatter.writeTo(indentingWriter, encodedMethod.codeItem, n);
            indentingWriter.write(61);
            if (registerType == null) {
                indentingWriter.write("null");
            } else {
                registerType.writeTo(indentingWriter);
            }
            indentingWriter.write(59);
            n = bitSet.nextSetBit(n + 1);
        }
        return true;
    }
}

