/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.CodeItem;

public class SparseSwitchMethodItem
extends InstructionMethodItem<SparseSwitchDataPseudoInstruction>
implements Iterable<LabelMethodItem> {
    private final List<SparseSwitchTarget> targets;

    public SparseSwitchMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int n, SparseSwitchDataPseudoInstruction sparseSwitchDataPseudoInstruction) {
        super(codeItem, n, sparseSwitchDataPseudoInstruction);
        int n2 = methodDefinition.getSparseSwitchBaseAddress(n);
        this.targets = new ArrayList<SparseSwitchTarget>();
        Iterator<SparseSwitchDataPseudoInstruction.SparseSwitchTarget> iterator = sparseSwitchDataPseudoInstruction.iterateKeysAndTargets();
        while (iterator.hasNext()) {
            SparseSwitchDataPseudoInstruction.SparseSwitchTarget sparseSwitchTarget = iterator.next();
            SparseSwitchTarget sparseSwitchTarget2 = new SparseSwitchTarget();
            sparseSwitchTarget2.Key = sparseSwitchTarget.key;
            LabelMethodItem labelMethodItem = new LabelMethodItem(n2 + sparseSwitchTarget.targetAddressOffset, "sswitch_");
            sparseSwitchTarget2.Target = labelMethodItem = methodDefinition.getLabelCache().internLabel(labelMethodItem);
            this.targets.add(sparseSwitchTarget2);
        }
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write(".sparse-switch\n");
        indentingWriter.indent(4);
        for (SparseSwitchTarget sparseSwitchTarget : this.targets) {
            IntegerRenderer.writeTo(indentingWriter, sparseSwitchTarget.Key);
            indentingWriter.write(" -> ");
            sparseSwitchTarget.Target.writeTo(indentingWriter);
            indentingWriter.write(10);
        }
        indentingWriter.deindent(4);
        indentingWriter.write(".end sparse-switch");
        return true;
    }

    @Override
    public Iterator<LabelMethodItem> iterator() {
        return new Iterator<LabelMethodItem>(){
            private Iterator<SparseSwitchTarget> iterator;
            {
                this.iterator = SparseSwitchMethodItem.this.targets.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public LabelMethodItem next() {
                return this.iterator.next().Target;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    private static class SparseSwitchTarget {
        public int Key;
        public LabelMethodItem Target;

        private SparseSwitchTarget() {
        }
    }
}

