/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.IndentingWriter;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;

public abstract class DebugMethodItem
extends MethodItem {
    private final double sortOrder;

    public DebugMethodItem(int n, double d) {
        super(n);
        this.sortOrder = d;
    }

    @Override
    public double getSortOrder() {
        return this.sortOrder;
    }

    protected static void writeLine(IndentingWriter indentingWriter, int n) throws IOException {
        indentingWriter.write(".line ");
        indentingWriter.printIntAsDec(n);
    }

    protected static void writeEndPrologue(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write(".prologue");
    }

    protected static void writeBeginEpilogue(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write(".epilogue");
    }

    protected static void writeStartLocal(IndentingWriter indentingWriter, CodeItem codeItem, int n, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) throws IOException {
        indentingWriter.write(".local ");
        RegisterFormatter.writeTo(indentingWriter, codeItem, n);
        indentingWriter.write(", ");
        indentingWriter.write(stringIdItem.getStringValue());
        indentingWriter.write(58);
        indentingWriter.write(typeIdItem.getTypeDescriptor());
        if (stringIdItem2 != null) {
            indentingWriter.write(",\"");
            indentingWriter.write(stringIdItem2.getStringValue());
            indentingWriter.write(34);
        }
    }

    protected static void writeEndLocal(IndentingWriter indentingWriter, CodeItem codeItem, int n, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) throws IOException {
        indentingWriter.write(".end local ");
        RegisterFormatter.writeTo(indentingWriter, codeItem, n);
        if (stringIdItem != null) {
            indentingWriter.write("           #");
            indentingWriter.write(stringIdItem.getStringValue());
            indentingWriter.write(58);
            indentingWriter.write(typeIdItem.getTypeDescriptor());
            if (stringIdItem2 != null) {
                indentingWriter.write(",\"");
                indentingWriter.write(stringIdItem2.getStringValue());
                indentingWriter.write(34);
            }
        }
    }

    protected static void writeRestartLocal(IndentingWriter indentingWriter, CodeItem codeItem, int n, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) throws IOException {
        indentingWriter.write(".restart local ");
        RegisterFormatter.writeTo(indentingWriter, codeItem, n);
        if (stringIdItem != null) {
            indentingWriter.write("       #");
            indentingWriter.write(stringIdItem.getStringValue());
            indentingWriter.write(58);
            indentingWriter.write(typeIdItem.getTypeDescriptor());
            if (stringIdItem2 != null) {
                indentingWriter.write(",\"");
                indentingWriter.write(stringIdItem2.getStringValue());
                indentingWriter.write(34);
            }
        }
    }

    protected static void writeSetFile(IndentingWriter indentingWriter, String string) throws IOException {
        indentingWriter.write(".source \"");
        indentingWriter.write(string);
        indentingWriter.write(34);
    }
}

