/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class PatternOptionBuilder {
    public static final Class STRING_VALUE = String.class;
    public static final Class OBJECT_VALUE = Object.class;
    public static final Class NUMBER_VALUE = Number.class;
    public static final Class DATE_VALUE = Date.class;
    public static final Class CLASS_VALUE = Class.class;
    public static final Class EXISTING_FILE_VALUE = FileInputStream.class;
    public static final Class FILE_VALUE = File.class;
    public static final Class FILES_VALUE = File[].class;
    public static final Class URL_VALUE = URL.class;

    public static Object getValueClass(char c) {
        switch (c) {
            case '@': {
                return OBJECT_VALUE;
            }
            case ':': {
                return STRING_VALUE;
            }
            case '%': {
                return NUMBER_VALUE;
            }
            case '+': {
                return CLASS_VALUE;
            }
            case '#': {
                return DATE_VALUE;
            }
            case '<': {
                return EXISTING_FILE_VALUE;
            }
            case '>': {
                return FILE_VALUE;
            }
            case '*': {
                return FILES_VALUE;
            }
            case '/': {
                return URL_VALUE;
            }
        }
        return null;
    }

    public static boolean isValueCode(char c) {
        return c == '@' || c == ':' || c == '%' || c == '+' || c == '#' || c == '<' || c == '>' || c == '*' || c == '/' || c == '!';
    }

    public static Options parsePattern(String string) {
        int n = 32;
        boolean bl = false;
        Object object = null;
        Options options = new Options();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!PatternOptionBuilder.isValueCode(c)) {
                if (n != 32) {
                    OptionBuilder.hasArg(object != null);
                    OptionBuilder.isRequired(bl);
                    OptionBuilder.withType(object);
                    options.addOption(OptionBuilder.create((char)n));
                    bl = false;
                    object = null;
                    n = 32;
                }
                n = c;
                continue;
            }
            if (c == '!') {
                bl = true;
                continue;
            }
            object = PatternOptionBuilder.getValueClass(c);
        }
        if (n != 32) {
            OptionBuilder.hasArg(object != null);
            OptionBuilder.isRequired(bl);
            OptionBuilder.withType(object);
            options.addOption(OptionBuilder.create((char)n));
        }
        return options;
    }
}

