/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Util;

public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map shortOpts = new HashMap();
    private Map longOpts = new HashMap();
    private List requiredOpts = new ArrayList();
    private Map optionGroups = new HashMap();

    public Options addOptionGroup(OptionGroup optionGroup) {
        Iterator iterator = optionGroup.getOptions().iterator();
        if (optionGroup.isRequired()) {
            this.requiredOpts.add(optionGroup);
        }
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            option.setRequired(false);
            this.addOption(option);
            this.optionGroups.put(option.getKey(), optionGroup);
        }
        return this;
    }

    Collection getOptionGroups() {
        return new HashSet(this.optionGroups.values());
    }

    public Options addOption(String string, boolean bl, String string2) {
        this.addOption(string, null, bl, string2);
        return this;
    }

    public Options addOption(String string, String string2, boolean bl, String string3) {
        this.addOption(new Option(string, string2, bl, string3));
        return this;
    }

    public Options addOption(Option option) {
        String string = option.getKey();
        if (option.hasLongOpt()) {
            this.longOpts.put(option.getLongOpt(), option);
        }
        if (option.isRequired()) {
            if (this.requiredOpts.contains(string)) {
                this.requiredOpts.remove(this.requiredOpts.indexOf(string));
            }
            this.requiredOpts.add(string);
        }
        this.shortOpts.put(string, option);
        return this;
    }

    public Collection getOptions() {
        return Collections.unmodifiableCollection(this.helpOptions());
    }

    List helpOptions() {
        return new ArrayList(this.shortOpts.values());
    }

    public List getRequiredOptions() {
        return this.requiredOpts;
    }

    public Option getOption(String string) {
        if (this.shortOpts.containsKey(string = Util.stripLeadingHyphens(string))) {
            return (Option)this.shortOpts.get(string);
        }
        return (Option)this.longOpts.get(string);
    }

    public boolean hasOption(String string) {
        return this.shortOpts.containsKey(string = Util.stripLeadingHyphens(string)) || this.longOpts.containsKey(string);
    }

    public OptionGroup getOptionGroup(Option option) {
        return (OptionGroup)this.optionGroups.get(option.getKey());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ Options: [ short ");
        stringBuffer.append(this.shortOpts.toString());
        stringBuffer.append(" ] [ long ");
        stringBuffer.append(this.longOpts);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

