/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.Option;

public class OptionGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map optionMap = new HashMap();
    private String selected;
    private boolean required;

    public OptionGroup addOption(Option option) {
        this.optionMap.put(option.getKey(), option);
        return this;
    }

    public Collection getNames() {
        return this.optionMap.keySet();
    }

    public Collection getOptions() {
        return this.optionMap.values();
    }

    public void setSelected(Option option) throws AlreadySelectedException {
        if (this.selected != null && !this.selected.equals(option.getOpt())) {
            throw new AlreadySelectedException(this, option);
        }
        this.selected = option.getOpt();
    }

    public String getSelected() {
        return this.selected;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getOptions().iterator();
        stringBuffer.append("[");
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            if (option.getOpt() != null) {
                stringBuffer.append("-");
                stringBuffer.append(option.getOpt());
            } else {
                stringBuffer.append("--");
                stringBuffer.append(option.getLongOpt());
            }
            stringBuffer.append(" ");
            stringBuffer.append(option.getDescription());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

