/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DirUtil {
    public static void copyToDir(Directory directory, Directory directory2) throws DirectoryException {
        for (String string : directory.getFiles(true)) {
            DirUtil.copyToDir(directory, directory2, string);
        }
    }

    public static void copyToDir(Directory directory, Directory directory2, String[] stringArray) throws DirectoryException {
        for (int i = 0; i < stringArray.length; ++i) {
            DirUtil.copyToDir(directory, directory2, stringArray[i]);
        }
    }

    public static void copyToDir(Directory directory, Directory directory2, String string) throws DirectoryException {
        try {
            if (directory.containsDir(string)) {
                directory.getDir(string).copyToDir(directory2.createDir(string));
            } else {
                BrutIO.copyAndClose(directory.getFileInput(string), directory2.getFileOutput(string));
            }
        }
        catch (IOException iOException) {
            throw new DirectoryException("Error copying file: " + string, iOException);
        }
    }

    public static void copyToDir(Directory directory, File file) throws DirectoryException {
        for (String string : directory.getFiles(true)) {
            DirUtil.copyToDir(directory, file, string);
        }
    }

    public static void copyToDir(Directory directory, File file, String[] stringArray) throws DirectoryException {
        for (int i = 0; i < stringArray.length; ++i) {
            DirUtil.copyToDir(directory, file, stringArray[i]);
        }
    }

    public static void copyToDir(Directory directory, File file, String string) throws DirectoryException {
        try {
            if (directory.containsDir(string)) {
                OS.rmdir(new File(file, string));
                directory.getDir(string).copyToDir(new File(file, string));
            } else {
                File file2 = new File(file, string);
                file2.getParentFile().mkdirs();
                BrutIO.copyAndClose(directory.getFileInput(string), new FileOutputStream(file2));
            }
        }
        catch (IOException iOException) {
            throw new DirectoryException("Error copying file: " + string, iOException);
        }
        catch (BrutException brutException) {
            throw new DirectoryException("Error copying file: " + string, brutException);
        }
    }
}

