/*
 * Decompiled with CFR 0.152.
 */
package brut.apktool;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.ApkDecoder;
import brut.androlib.err.CantFindFrameworkResException;
import brut.androlib.err.OutDirExistsException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Main {
    public static void main(String[] stringArray) throws IOException, AndrolibException, InterruptedException {
        block9: {
            try {
                String string;
                int n;
                boolean bl = false;
                for (n = 0; n < stringArray.length && (string = stringArray[n]).startsWith("-"); ++n) {
                    if (!"-v".equals(string) && !"--verbose".equals(string)) {
                        throw new InvalidArgsError();
                    }
                    bl = true;
                }
                Main.setupLogging(bl);
                if (stringArray.length <= n) {
                    throw new InvalidArgsError();
                }
                string = stringArray[n];
                stringArray = Arrays.copyOfRange(stringArray, n + 1, stringArray.length);
                if ("d".equals(string) || "decode".equals(string)) {
                    Main.cmdDecode(stringArray);
                    break block9;
                }
                if ("b".equals(string) || "build".equals(string)) {
                    Main.cmdBuild(stringArray);
                    break block9;
                }
                if ("if".equals(string) || "install-framework".equals(string)) {
                    Main.cmdInstallFramework(stringArray);
                    break block9;
                }
                if ("publicize-resources".equals(string)) {
                    Main.cmdPublicizeResources(stringArray);
                    break block9;
                }
                throw new InvalidArgsError();
            }
            catch (InvalidArgsError invalidArgsError) {
                Main.usage();
                System.exit(1);
            }
        }
    }

    private static void cmdDecode(String[] stringArray) throws InvalidArgsError, AndrolibException {
        String string;
        int n;
        ApkDecoder apkDecoder = new ApkDecoder();
        for (n = 0; n < stringArray.length && (string = stringArray[n]).startsWith("-"); ++n) {
            if ("-s".equals(string) || "--no-src".equals(string)) {
                apkDecoder.setDecodeSources((short)0);
                continue;
            }
            if ("-d".equals(string) || "--debug".equals(string)) {
                apkDecoder.setDebugMode(true);
                continue;
            }
            if ("-t".equals(string) || "--frame-tag".equals(string)) {
                if (++n >= stringArray.length) {
                    throw new InvalidArgsError();
                }
                apkDecoder.setFrameworkTag(stringArray[n]);
                continue;
            }
            if ("-f".equals(string) || "--force".equals(string)) {
                apkDecoder.setForceDelete(true);
                continue;
            }
            if ("-r".equals(string) || "--no-res".equals(string)) {
                apkDecoder.setDecodeResources((short)256);
                continue;
            }
            if ("--keep-broken-res".equals(string)) {
                apkDecoder.setKeepBrokenResources(true);
                continue;
            }
            throw new InvalidArgsError();
        }
        string = null;
        if (stringArray.length == n + 2) {
            string = stringArray[n + 1];
        } else if (stringArray.length == n + 1) {
            string = stringArray[n];
            string = string.endsWith(".apk") ? string.substring(0, string.length() - 4) : string + ".out";
            string = new File(string).getName();
        } else {
            throw new InvalidArgsError();
        }
        File file = new File(string);
        apkDecoder.setOutDir(file);
        apkDecoder.setApkFile(new File(stringArray[n]));
        try {
            apkDecoder.decode();
        }
        catch (OutDirExistsException outDirExistsException) {
            System.out.println("Destination directory (" + file.getAbsolutePath() + ") " + "already exists. Use -f switch if you want to overwrite it.");
            System.exit(1);
        }
        catch (CantFindFrameworkResException cantFindFrameworkResException) {
            System.out.println("Can't find framework resources for package of id: " + String.valueOf(cantFindFrameworkResException.getPkgId()) + ". You must install proper " + "framework files, see project website for more info.");
            System.exit(1);
        }
    }

    private static void cmdBuild(String[] stringArray) throws InvalidArgsError, AndrolibException {
        String string;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length && (string = stringArray[n]).startsWith("-"); ++n) {
            if ("-f".equals(string) || "--force-all".equals(string)) {
                bl = true;
                continue;
            }
            if ("-d".equals(string) || "--debug".equals(string)) {
                bl2 = true;
                continue;
            }
            throw new InvalidArgsError();
        }
        File file = null;
        switch (stringArray.length - n) {
            case 0: {
                string = ".";
                break;
            }
            case 2: {
                file = new File(stringArray[n + 1]);
            }
            case 1: {
                string = stringArray[n];
                break;
            }
            default: {
                throw new InvalidArgsError();
            }
        }
        new Androlib().build(new File(string), file, bl, bl2);
    }

    private static void cmdInstallFramework(String[] stringArray) throws AndrolibException {
        String string = null;
        switch (stringArray.length) {
            case 2: {
                string = stringArray[1];
            }
            case 1: {
                new Androlib().installFramework(new File(stringArray[0]), string);
                return;
            }
        }
        throw new InvalidArgsError();
    }

    private static void cmdPublicizeResources(String[] stringArray) throws InvalidArgsError, AndrolibException {
        if (stringArray.length != 1) {
            throw new InvalidArgsError();
        }
        new Androlib().publicizeResources(new File(stringArray[0]));
    }

    private static void usage() {
        System.out.println("Apktool v" + Androlib.getVersion() + " - a tool for reengineering Android apk files\n" + "Copyright 2010 Ryszard Wi\u015bniewski <brut.alll@gmail.com>\n" + "Apache License 2.0 (http://www.apache.org/licenses/LICENSE-2.0)\n" + "\n" + "Usage: apktool [-v|--verbose] COMMAND [...]\n" + "\n" + "COMMANDs are:\n" + "\n" + "    d[ecode] [OPTS] <file.apk> [<dir>]\n" + "        Decode <file.apk> to <dir>.\n" + "\n" + "        OPTS:\n" + "\n" + "        -s, --no-src\n" + "            Do not decode sources.\n" + "        -r, --no-res\n" + "            Do not decode resources.\n" + "        -d, --debug\n" + "            Decode in debug mode. Check project page for more info.\n" + "        -f, --force\n" + "            Force delete destination directory.\n" + "        -t <tag>, --frame-tag <tag>\n" + "            Try to use framework files tagged by <tag>.\n" + "        --keep-broken-res\n" + "            Use if there was an error and some resources were dropped, e.g.:\n" + "            \"Invalid config flags detected. Dropping resources\", but you\n" + "            want to decode them anyway, even with errors. You will have to\n" + "            fix them manually before building." + "\n" + "    b[uild] [OPTS] [<app_path>] [<out_file>]\n" + "        Build an apk from already decoded application located in <app_path>.\n" + "\n" + "        It will automatically detect, whether files was changed and perform\n" + "        needed steps only.\n" + "\n" + "        If you omit <app_path> then current directory will be used.\n" + "        If you omit <out_file> then <app_path>/dist/<name_of_original.apk>\n" + "        will be used.\n" + "\n" + "        OPTS:\n" + "\n" + "        -f, --force-all\n" + "            Skip changes detection and build all files.\n" + "        -d, --debug\n" + "            Build in debug mode. Check project page for more info.\n" + "\n" + "    if|install-framework <framework.apk> [<tag>]\n" + "        Install framework file to your system.\n" + "\n" + "For additional info, see: http://code.google.com/p/android-apktool/");
    }

    private static void setupLogging(boolean bl) {
        Logger logger = Logger.getLogger("");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        logger.removeHandler(logger.getHandlers()[0]);
        logger.addHandler(consoleHandler);
        if (bl) {
            consoleHandler.setLevel(Level.ALL);
            logger.setLevel(Level.ALL);
        } else {
            consoleHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord logRecord) {
                    return logRecord.getLevel().toString().charAt(0) + ": " + logRecord.getMessage() + System.getProperty("line.separator");
                }
            });
        }
    }

    static class InvalidArgsError
    extends AndrolibException {
        InvalidArgsError() {
        }
    }
}

