/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResEnumAttr;
import brut.androlib.res.data.value.ResFlagsAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.data.value.ResXmlSerializable;
import brut.util.Duo;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResAttr
extends ResBagValue
implements ResXmlSerializable {
    private final int mType;
    private final Integer mMin;
    private final Integer mMax;
    private final Boolean mL10n;
    public static final int BAG_KEY_ATTR_TYPE = 0x1000000;
    private static final int BAG_KEY_ATTR_MIN = 0x1000001;
    private static final int BAG_KEY_ATTR_MAX = 0x1000002;
    private static final int BAG_KEY_ATTR_L10N = 0x1000003;
    private static final int TYPE_REFERENCE = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_INT = 4;
    private static final int TYPE_BOOL = 8;
    private static final int TYPE_COLOR = 16;
    private static final int TYPE_FLOAT = 32;
    private static final int TYPE_DIMEN = 64;
    private static final int TYPE_FRACTION = 128;
    private static final int TYPE_ANY_STRING = 238;
    private static final int TYPE_ENUM = 65536;
    private static final int TYPE_FLAGS = 131072;

    ResAttr(ResReferenceValue resReferenceValue, int n, Integer n2, Integer n3, Boolean bl) {
        super(resReferenceValue);
        this.mType = n;
        this.mMin = n2;
        this.mMax = n3;
        this.mL10n = bl;
    }

    public String convertToResXmlFormat(ResScalarValue resScalarValue) throws AndrolibException {
        return resScalarValue.toResXmlFormat();
    }

    @Override
    public void serializeToXml(XmlSerializer xmlSerializer, ResResource resResource) throws IOException, AndrolibException {
        String string = this.getTypeAsString();
        xmlSerializer.startTag(null, "attr");
        xmlSerializer.attribute(null, "name", resResource.getResSpec().getName());
        if (string != null) {
            xmlSerializer.attribute(null, "format", string);
        }
        if (this.mMin != null) {
            xmlSerializer.attribute(null, "min", this.mMin.toString());
        }
        if (this.mMax != null) {
            xmlSerializer.attribute(null, "max", this.mMax.toString());
        }
        if (this.mL10n != null && this.mL10n.booleanValue()) {
            xmlSerializer.attribute(null, "localization", "suggested");
        }
        this.serializeBody(xmlSerializer, resResource);
        xmlSerializer.endTag(null, "attr");
    }

    public static ResAttr factory(ResReferenceValue resReferenceValue, Duo<Integer, ResScalarValue>[] duoArray, ResValueFactory resValueFactory, ResPackage resPackage) throws AndrolibException {
        int n;
        int n2 = ((ResIntValue)duoArray[0].m2).getValue();
        int n3 = n2 & 0xFFFF;
        Integer n4 = null;
        Integer n5 = null;
        Boolean bl = null;
        block9: for (n = 1; n < duoArray.length; ++n) {
            switch ((Integer)duoArray[n].m1) {
                case 0x1000001: {
                    n4 = ((ResIntValue)duoArray[n].m2).getValue();
                    continue block9;
                }
                case 0x1000002: {
                    n5 = ((ResIntValue)duoArray[n].m2).getValue();
                    continue block9;
                }
                case 0x1000003: {
                    bl = ((ResIntValue)duoArray[n].m2).getValue() != 0;
                    continue block9;
                }
            }
        }
        if (n == duoArray.length) {
            return new ResAttr(resReferenceValue, n3, n4, n5, bl);
        }
        Duo[] duoArray2 = new Duo[duoArray.length - n];
        int n6 = 0;
        while (n < duoArray.length) {
            int n7 = (Integer)duoArray[n].m1;
            resPackage.addSynthesizedRes(n7);
            duoArray2[n6++] = new Duo<ResReferenceValue, ResIntValue>(resValueFactory.newReference(n7), (ResIntValue)duoArray[n].m2);
            ++n;
        }
        switch (n2 & 0xFF0000) {
            case 65536: {
                return new ResEnumAttr(resReferenceValue, n3, n4, n5, bl, duoArray2);
            }
            case 131072: {
                return new ResFlagsAttr(resReferenceValue, n3, n4, n5, bl, duoArray2);
            }
        }
        throw new AndrolibException("Could not decode attr value");
    }

    protected void serializeBody(XmlSerializer xmlSerializer, ResResource resResource) throws AndrolibException, IOException {
    }

    protected String getTypeAsString() {
        String string = "";
        if ((this.mType & 1) != 0) {
            string = string + "|reference";
        }
        if ((this.mType & 2) != 0) {
            string = string + "|string";
        }
        if ((this.mType & 4) != 0) {
            string = string + "|integer";
        }
        if ((this.mType & 8) != 0) {
            string = string + "|boolean";
        }
        if ((this.mType & 0x10) != 0) {
            string = string + "|color";
        }
        if ((this.mType & 0x20) != 0) {
            string = string + "|float";
        }
        if ((this.mType & 0x40) != 0) {
            string = string + "|dimension";
        }
        if ((this.mType & 0x80) != 0) {
            string = string + "|fraction";
        }
        if (string.isEmpty()) {
            return null;
        }
        return string.substring(1);
    }
}

