/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import java.util.logging.Logger;

public class ResConfigFlags {
    public final short mcc;
    public final short mnc;
    public final char[] language;
    public final char[] country;
    public final byte orientation;
    public final byte touchscreen;
    public final short density;
    public final byte keyboard;
    public final byte navigation;
    public final byte inputFlags;
    public final short screenWidth;
    public final short screenHeight;
    public final short sdkVersion;
    public final byte screenLayout;
    public final byte uiMode;
    public final boolean isInvalid;
    private final String mQualifiers;
    private static int sErrCounter = 0;
    public static final byte ORIENTATION_ANY = 0;
    public static final byte ORIENTATION_PORT = 1;
    public static final byte ORIENTATION_LAND = 2;
    public static final byte ORIENTATION_SQUARE = 3;
    public static final byte TOUCHSCREEN_ANY = 0;
    public static final byte TOUCHSCREEN_NOTOUCH = 1;
    public static final byte TOUCHSCREEN_STYLUS = 2;
    public static final byte TOUCHSCREEN_FINGER = 3;
    public static final short DENSITY_DEFAULT = 0;
    public static final short DENSITY_LOW = 120;
    public static final short DENSITY_MEDIUM = 160;
    public static final short DENSITY_HIGH = 240;
    public static final short DENSITY_NONE = -1;
    public static final byte KEYBOARD_ANY = 0;
    public static final byte KEYBOARD_NOKEYS = 1;
    public static final byte KEYBOARD_QWERTY = 2;
    public static final byte KEYBOARD_12KEY = 3;
    public static final byte NAVIGATION_ANY = 0;
    public static final byte NAVIGATION_NONAV = 1;
    public static final byte NAVIGATION_DPAD = 2;
    public static final byte NAVIGATION_TRACKBALL = 3;
    public static final byte NAVIGATION_WHEEL = 4;
    public static final byte MASK_KEYSHIDDEN = 3;
    public static final byte KEYSHIDDEN_ANY = 0;
    public static final byte KEYSHIDDEN_NO = 1;
    public static final byte KEYSHIDDEN_YES = 2;
    public static final byte KEYSHIDDEN_SOFT = 3;
    public static final byte MASK_NAVHIDDEN = 12;
    public static final byte NAVHIDDEN_ANY = 0;
    public static final byte NAVHIDDEN_NO = 4;
    public static final byte NAVHIDDEN_YES = 8;
    public static final byte MASK_SCREENSIZE = 15;
    public static final byte SCREENSIZE_ANY = 0;
    public static final byte SCREENSIZE_SMALL = 1;
    public static final byte SCREENSIZE_NORMAL = 2;
    public static final byte SCREENSIZE_LARGE = 3;
    public static final byte MASK_SCREENLONG = 48;
    public static final byte SCREENLONG_ANY = 0;
    public static final byte SCREENLONG_NO = 16;
    public static final byte SCREENLONG_YES = 32;
    public static final byte MASK_UI_MODE_TYPE = 15;
    public static final byte UI_MODE_TYPE_ANY = 0;
    public static final byte UI_MODE_TYPE_NORMAL = 1;
    public static final byte UI_MODE_TYPE_DESK = 2;
    public static final byte UI_MODE_TYPE_CAR = 3;
    public static final byte MASK_UI_MODE_NIGHT = 48;
    public static final byte UI_MODE_NIGHT_ANY = 0;
    public static final byte UI_MODE_NIGHT_NO = 16;
    public static final byte UI_MODE_NIGHT_YES = 32;
    private static final Logger LOGGER = Logger.getLogger(ResConfigFlags.class.getName());

    public ResConfigFlags() {
        this.mcc = 0;
        this.mnc = 0;
        this.language = new char[]{'\u0000', '\u0000'};
        this.country = new char[]{'\u0000', '\u0000'};
        this.orientation = 0;
        this.touchscreen = 0;
        this.density = 0;
        this.keyboard = 0;
        this.navigation = 0;
        this.inputFlags = 0;
        this.screenWidth = 0;
        this.screenHeight = 0;
        this.sdkVersion = 0;
        this.screenLayout = 0;
        this.uiMode = 0;
        this.isInvalid = false;
        this.mQualifiers = "";
    }

    public ResConfigFlags(short s, short s2, char[] cArray, char[] cArray2, byte by, byte by2, short s3, byte by3, byte by4, byte by5, short s4, short s5, short s6, byte by6, byte by7, boolean bl) {
        if (by < 0 || by > 3) {
            LOGGER.warning("Invalid orientation value: " + by);
            by = 0;
            bl = true;
        }
        if (by2 < 0 || by2 > 3) {
            LOGGER.warning("Invalid touchscreen value: " + by2);
            by2 = 0;
            bl = true;
        }
        if (s3 < -1) {
            LOGGER.warning("Invalid density value: " + s3);
            s3 = 0;
            bl = true;
        }
        if (by3 < 0 || by3 > 3) {
            LOGGER.warning("Invalid keyboard value: " + by3);
            by3 = 0;
            bl = true;
        }
        if (by4 < 0 || by4 > 4) {
            LOGGER.warning("Invalid navigation value: " + by4);
            by4 = 0;
            bl = true;
        }
        this.mcc = s;
        this.mnc = s2;
        this.language = cArray;
        this.country = cArray2;
        this.orientation = by;
        this.touchscreen = by2;
        this.density = s3;
        this.keyboard = by3;
        this.navigation = by4;
        this.inputFlags = by5;
        this.screenWidth = s4;
        this.screenHeight = s5;
        this.sdkVersion = s6;
        this.screenLayout = by6;
        this.uiMode = by7;
        this.isInvalid = bl;
        this.mQualifiers = this.generateQualifiers();
    }

    public String getQualifiers() {
        return this.mQualifiers;
    }

    private String generateQualifiers() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mcc != 0) {
            stringBuilder.append("-mcc").append(this.mcc);
            if (this.mnc != 0) {
                stringBuilder.append("-mnc").append(this.mnc);
            }
        }
        if (this.language[0] != '\u0000') {
            stringBuilder.append('-').append(this.language);
            if (this.country[0] != '\u0000') {
                stringBuilder.append("-r").append(this.country);
            }
        }
        switch (this.screenLayout & 0xF) {
            case 1: {
                stringBuilder.append("-small");
                break;
            }
            case 2: {
                stringBuilder.append("-normal");
                break;
            }
            case 3: {
                stringBuilder.append("-large");
            }
        }
        switch (this.screenLayout & 0x30) {
            case 32: {
                stringBuilder.append("-long");
                break;
            }
            case 16: {
                stringBuilder.append("-notlong");
            }
        }
        switch (this.orientation) {
            case 1: {
                stringBuilder.append("-port");
                break;
            }
            case 2: {
                stringBuilder.append("-land");
                break;
            }
            case 3: {
                stringBuilder.append("-square");
            }
        }
        switch (this.uiMode & 0xF) {
            case 3: {
                stringBuilder.append("-car");
                break;
            }
            case 2: {
                stringBuilder.append("-desk");
            }
        }
        switch (this.uiMode & 0x30) {
            case 32: {
                stringBuilder.append("-night");
                break;
            }
            case 16: {
                stringBuilder.append("-notnight");
            }
        }
        switch (this.density) {
            case 0: {
                break;
            }
            case 120: {
                stringBuilder.append("-ldpi");
                break;
            }
            case 160: {
                stringBuilder.append("-mdpi");
                break;
            }
            case 240: {
                stringBuilder.append("-hdpi");
                break;
            }
            case -1: {
                stringBuilder.append("-nodpi");
                break;
            }
            default: {
                stringBuilder.append('-').append(this.density).append("dpi");
            }
        }
        switch (this.touchscreen) {
            case 1: {
                stringBuilder.append("-notouch");
                break;
            }
            case 2: {
                stringBuilder.append("-stylus");
                break;
            }
            case 3: {
                stringBuilder.append("-finger");
            }
        }
        switch (this.inputFlags & 3) {
            case 1: {
                stringBuilder.append("-keysexposed");
                break;
            }
            case 2: {
                stringBuilder.append("-keyshidden");
                break;
            }
            case 3: {
                stringBuilder.append("-keyssoft");
            }
        }
        switch (this.keyboard) {
            case 1: {
                stringBuilder.append("-nokeys");
                break;
            }
            case 2: {
                stringBuilder.append("-qwerty");
                break;
            }
            case 3: {
                stringBuilder.append("-12key");
            }
        }
        switch (this.inputFlags & 0xC) {
            case 4: {
                stringBuilder.append("-navexposed");
                break;
            }
            case 8: {
                stringBuilder.append("-navhidden");
            }
        }
        switch (this.navigation) {
            case 1: {
                stringBuilder.append("-nonav");
                break;
            }
            case 2: {
                stringBuilder.append("-dpad");
                break;
            }
            case 3: {
                stringBuilder.append("-trackball");
                break;
            }
            case 4: {
                stringBuilder.append("-wheel");
            }
        }
        if (this.screenWidth != 0 && this.screenHeight != 0) {
            if (this.screenWidth > this.screenHeight) {
                stringBuilder.append(String.format("-%dx%d", this.screenWidth, this.screenHeight));
            } else {
                stringBuilder.append(String.format("-%dx%d", this.screenHeight, this.screenWidth));
            }
        }
        if (this.sdkVersion > this.getNaturalSdkVersionRequirement()) {
            stringBuilder.append("-v").append(this.sdkVersion);
        }
        if (this.isInvalid) {
            stringBuilder.append("-ERR" + sErrCounter++);
        }
        return stringBuilder.toString();
    }

    private short getNaturalSdkVersionRequirement() {
        if ((this.uiMode & 0x3F) != 0) {
            return 8;
        }
        if ((this.screenLayout & 0x3F) != 0 || this.density != 0) {
            return 4;
        }
        return 0;
    }

    public String toString() {
        return !this.getQualifiers().equals("") ? this.getQualifiers() : "[DEFAULT]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResConfigFlags resConfigFlags = (ResConfigFlags)object;
        return this.mQualifiers.equals(resConfigFlags.mQualifiers);
    }

    public int hashCode() {
        int n = 3;
        n = 97 * n + this.mQualifiers.hashCode();
        return n;
    }
}

