﻿Imports System.IO
Imports System.Collections.Generic

'撰寫人員：吳宇澤
'撰寫日期：2012/09/21
'修改日期：2012/09/30
'版本號碼：v1.1
''' <summary>
''' Word、Excel 整批轉成 PDF 檔
''' </summary>
''' <remarks></remarks>
Public Class Form1
    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Me.ButtonConv.Enabled = False
    End Sub

    '選取目錄1
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If FolderBrowserDialog1.ShowDialog() = DialogResult.OK Then
            TextBox1.Text = FolderBrowserDialog1.SelectedPath
            Me.ButtonConv.Enabled = True
        End If
    End Sub

    '選取目錄2
    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        If FolderBrowserDialog2.ShowDialog() = DialogResult.OK Then
            TextBox2.Text = FolderBrowserDialog2.SelectedPath
            Me.ButtonConv.Enabled = True
        End If
    End Sub

    '選取目錄3
    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        If FolderBrowserDialog3.ShowDialog() = DialogResult.OK Then
            TextBox3.Text = FolderBrowserDialog3.SelectedPath
            Me.ButtonConv.Enabled = True
        End If
    End Sub

    '選取目錄4
    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        If FolderBrowserDialog4.ShowDialog() = DialogResult.OK Then
            TextBox4.Text = FolderBrowserDialog4.SelectedPath
            Me.ButtonConv.Enabled = True
        End If
    End Sub

    '選取目錄5
    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        If FolderBrowserDialog5.ShowDialog() = DialogResult.OK Then
            TextBox5.Text = FolderBrowserDialog5.SelectedPath
            Me.ButtonConv.Enabled = True
        End If
    End Sub

    '開始轉 PDF
    Private Sub ButtonConv_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonConv.Click
        Dim listFileList As New List(Of String)()   '所有已選取目錄下的 Excel 及 Word，其「路徑 + 檔名」的集合

        '選取目錄1
        If TextBox1.Text.Trim().Length > 0 Then
            Dim arrFiles01() As String

            '捉出該目錄下，所有副檔名為 .xls 或 .xlsx 的「路徑\檔名.副檔名」
            arrFiles01 = Directory.GetFiles(TextBox1.Text.Trim(), "*.xls")

            For Each strFile01_xls In arrFiles01
                listFileList.Add(strFile01_xls)
            Next

            arrFiles01 = Nothing

            '捉出該目錄下，所有副檔名為 .doc 或 .docx 的「路徑\檔名.副檔名」
            arrFiles01 = Directory.GetFiles(TextBox1.Text.Trim(), "*.doc")

            For Each strFile01_doc In arrFiles01
                listFileList.Add(strFile01_doc)
            Next

            arrFiles01 = Nothing
        End If

        '選取目錄2
        If TextBox2.Text.Trim().Length > 0 Then
            Dim arrFiles02() As String

            '捉出該目錄下，所有副檔名為 .xls 或 .xlsx 的「路徑\檔名.副檔名」
            arrFiles02 = Directory.GetFiles(TextBox2.Text.Trim(), "*.xls")

            For Each strFile02_xls In arrFiles02
                listFileList.Add(strFile02_xls)
            Next

            arrFiles02 = Nothing

            '捉出該目錄下，所有副檔名為 .doc 或 .docx 的「路徑\檔名.副檔名」
            arrFiles02 = Directory.GetFiles(TextBox2.Text.Trim(), "*.doc")

            For Each strFile02_doc In arrFiles02
                listFileList.Add(strFile02_doc)
            Next

            arrFiles02 = Nothing
        End If

        '選取目錄3
        If TextBox3.Text.Trim().Length > 0 Then
            Dim arrFiles03() As String

            '捉出該目錄下，所有副檔名為 .xls 或 .xlsx 的「路徑\檔名.副檔名」
            arrFiles03 = Directory.GetFiles(TextBox3.Text.Trim(), "*.xls")

            For Each strFile03_xls In arrFiles03
                listFileList.Add(strFile03_xls)
            Next

            arrFiles03 = Nothing

            '捉出該目錄下，所有副檔名為 .doc 或 .docx 的「路徑\檔名.副檔名」
            arrFiles03 = Directory.GetFiles(TextBox3.Text.Trim(), "*.doc")

            For Each strFile03_doc In arrFiles03
                listFileList.Add(strFile03_doc)
            Next

            arrFiles03 = Nothing
        End If

        '選取目錄4
        If TextBox4.Text.Trim().Length > 0 Then
            Dim arrFiles04() As String

            '捉出該目錄下，所有副檔名為 .xls 或 .xlsx 的「路徑\檔名.副檔名」
            arrFiles04 = Directory.GetFiles(TextBox4.Text.Trim(), "*.xls")

            For Each strFile04_xls In arrFiles04
                listFileList.Add(strFile04_xls)
            Next

            arrFiles04 = Nothing

            '捉出該目錄下，所有副檔名為 .doc 或 .docx 的「路徑\檔名.副檔名」
            arrFiles04 = Directory.GetFiles(TextBox4.Text.Trim(), "*.doc")

            For Each strFile04_doc In arrFiles04
                listFileList.Add(strFile04_doc)
            Next

            arrFiles04 = Nothing
        End If

        '選取目錄5
        If TextBox5.Text.Trim().Length > 0 Then
            Dim arrFiles05() As String

            '捉出該目錄下，所有副檔名為 .xls 或 .xlsx 的「路徑\檔名.副檔名」
            arrFiles05 = Directory.GetFiles(TextBox5.Text.Trim(), "*.xls")

            For Each strFile05_xls In arrFiles05
                listFileList.Add(strFile05_xls)
            Next

            arrFiles05 = Nothing

            '捉出該目錄下，所有副檔名為 .doc 或 .docx 的「路徑\檔名.副檔名」
            arrFiles05 = Directory.GetFiles(TextBox5.Text.Trim(), "*.doc")

            For Each strFile05_doc In arrFiles05
                listFileList.Add(strFile05_doc)
            Next

            arrFiles05 = Nothing
        End If

        If TextBox1.Text.Trim().Length = 0 And TextBox2.Text.Trim().Length = 0 And TextBox3.Text.Trim().Length = 0 _
             And TextBox4.Text.Trim().Length = 0 And TextBox5.Text.Trim().Length = 0 Then
            MessageBox.Show("您尚未選擇目錄。")
            Exit Sub
        End If

        '若所選的一或多個目錄下，有任一個 Word 或 Excel 檔案，就開始做轉換的動作
        If listFileList.Count = 0 Then
            MessageBox.Show("您所選的目錄下，並無任何 Word 或 Excel 檔案。")
        Else
            'Dim strFileList As String = ""
            'For i As Integer = 0 To listFileList.Count - 1
            '    strFileList &= "第 " & i & "個檔案：" & listFileList(i) & vbCrLf
            'Next
            'MessageBox.Show(strFileList)   '所有已選取目錄下的 Excel 及 Word，其「路徑 + 檔名」的集合

            ButtonConv.Enabled = False

            'Dim fileExtension As String = System.IO.Path.GetExtension(listFileList(0)).ToLower()
            'Dim fileExtension2 As String = System.IO.Path.GetExtension(listFileList(1)).ToLower()
            'Dim fileExtension3 As String = System.IO.Path.GetExtension(listFileList(2)).ToLower()
            'Dim fileExtension4 As String = System.IO.Path.GetExtension(listFileList(3)).ToLower()
            'Dim fileExtension5 As String = System.IO.Path.GetExtension(listFileList(4)).ToLower()
            'MessageBox.Show(fileExtension & vbCrLf & fileExtension2 & vbCrLf & fileExtension3 & vbCrLf & fileExtension4 & vbCrLf & fileExtension5 & vbCrLf)

            Dim fileExtension As String = ""    '取得檔案之副檔名，並轉換成小寫字母
            Dim strErrorFile As String = Nothing    '若轉換發生錯誤時，記錄是哪個 Office 檔案造成的
            Dim dtStartTime As DateTime = DateTime.Now  '記錄轉換開始時的時間，以便後續統計整個轉換過程用了多少時間
            Dim conv As New WizardWu.ConvertOfficeToPDF()

            '進度列
            ProgressBar1.Visible = True
            ProgressBar1.Minimum = 1
            ProgressBar1.Maximum = listFileList.Count
            ProgressBar1.Value = 1
            ProgressBar1.Step = 1

            Try
                For i As Integer = 0 To listFileList.Count - 1
                    ProgressBar1.PerformStep()  '進度列
                    fileExtension = System.IO.Path.GetExtension(listFileList(i)).ToLower()  '副檔名
                    strErrorFile = listFileList(i)

                    If (fileExtension.Equals(".doc") Or fileExtension.Equals(".docx")) Then
                        conv.ConvertWordToPDF(listFileList(i))      '轉成 Word
                    ElseIf (fileExtension.Equals(".xls") Or fileExtension.Equals(".xlsx")) Then
                        conv.ConvertExcelToPDF(listFileList(i))     '轉成 Excel。要轉換的 Excel，可有 sheet 為空白
                    End If

                    fileExtension = ""
                    strErrorFile = ""
                Next
            Catch ex As Exception
                MessageBox.Show("在轉檔 " & strErrorFile & " 時發生錯誤！錯誤為：" & vbCrLf & vbCrLf & ex.Message)
            Finally
                ProgressBar1.Visible = False
                ButtonConv.Enabled = True
            End Try

            Dim timeInterval As New TimeSpan()
            timeInterval = DateTime.Now - dtStartTime
            MessageBox.Show("轉檔成功！" & vbCrLf & "PDF 檔已產生，位置在原始 Office 檔案其所在目錄。" & _
                              vbCrLf & vbCrLf & "總共花了：" & _
                              timeInterval.Hours & " 小時 " & timeInterval.Minutes & " 分 " & timeInterval.Seconds & " 秒")
        End If
    End Sub

    Private Sub Button1_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Button1.MouseUp
        ToolTip1.Show("所選取的該層目錄下，應避免有「每個 sheet 內容皆為空白」的 Excel 檔案，" & vbCrLf & "否則轉換動作會被中斷。", Me.Button1, 8000)
    End Sub

    Private Sub Button2_MouseUp(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Button2.MouseUp
        ToolTip1.Show("所選取的該層目錄下，應避免有「每個 sheet 內容皆為空白」的 Excel 檔案，" & vbCrLf & "否則轉換動作會被中斷。", Me.Button2, 8000)
    End Sub
End Class
