/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.internal.OracleConnection;
import oracle.streams.ChunkColumnValue;
import oracle.streams.LCR;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;

public class XStreamIn {
    private String xsInName = null;
    private String clientName = null;
    private long ocisvc;
    private long ocierr;
    private byte[] processedLWM = null;
    private byte[] lastPosition = null;
    private static boolean library_loaded = false;
    private int batchInterval = 30;
    public static final int DEFAULT_MODE = 0;
    public static final int DEFAULT_BATCH_INTERVAL = 30;
    public static final int FINISHED = 0;
    public static final int EXECUTING = 1;

    private XStreamIn(long l, long l2, String string, String string2) throws StreamsException {
        this.xsInName = string;
        this.clientName = string2;
        this.ocisvc = l;
        this.ocierr = l2;
    }

    public static XStreamIn attach(oracle.jdbc.OracleConnection oracleConnection, String string, String string2, int n) throws StreamsException {
        return XStreamIn.attachInternal(oracleConnection, string, string2, 30, n);
    }

    public static XStreamIn attach(oracle.jdbc.OracleConnection oracleConnection, String string, String string2, int n, int n2) throws StreamsException {
        return XStreamIn.attachInternal(oracleConnection, string, string2, n, n2);
    }

    private static XStreamIn attachInternal(oracle.jdbc.OracleConnection oracleConnection, String string, String string2, int n, int n2) throws StreamsException {
        XStreamIn xStreamIn = null;
        Properties properties = null;
        ArrayList arrayList = null;
        try {
            OracleConnection oracleConnection2 = oracleConnection.physicalConnectionWithin();
            properties = oracleConnection2.getOCIHandles();
            long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
            xStreamIn = new XStreamIn(l, l2, string, string2);
            xStreamIn.batchInterval = n;
            arrayList = xStreamIn.XStreamInAttachNative(l, l2, string, string2, n, n2);
            if (null == arrayList) {
                throw new StreamsException("XStreamIn attach: attach native call returns null\n");
            }
            xStreamIn.processedLWM = (byte[])arrayList.get(0);
            xStreamIn.lastPosition = (byte[])arrayList.get(1);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamIn attach: failed to attach to an XStream inbound server(" + string + ")\n", exception);
        }
        return xStreamIn;
    }

    public byte[] detach(int n) throws StreamsException {
        try {
            this.processedLWM = this.XStreamInDetachNative(this.ocisvc, this.ocierr, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamIn detach: failed to detach from XStream inbound server(" + this.xsInName + ")\n", exception);
        }
        return this.processedLWM;
    }

    public void sendLCRCallback(XStreamLCRCallbackHandler xStreamLCRCallbackHandler, int n) throws StreamsException {
        try {
            this.processedLWM = this.XStreamInSendLCRCallbackNative(this.ocisvc, this.ocierr, xStreamLCRCallbackHandler, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamIn sendLCRCallback: failed to send LCRs to inbound server(" + this.xsInName + ")\n", exception);
        }
    }

    public int sendLCR(LCR lCR, int n) throws StreamsException {
        int n2 = 0;
        try {
            ArrayList arrayList = this.XStreamInSendLCRNative(this.ocisvc, this.ocierr, lCR, n);
            if (null == arrayList) {
                throw new StreamsException("XStreamIn sendLCR: return invalid results\n");
            }
            n2 = (Integer)arrayList.get(0);
            this.processedLWM = (byte[])arrayList.get(1);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamIn sendLCR: failed to send an LCR to inbound server\n", exception);
        }
        return n2;
    }

    public void sendChunk(ChunkColumnValue chunkColumnValue, int n) throws StreamsException {
        try {
            this.XStreamInSendChunkNative(this.ocisvc, this.ocierr, chunkColumnValue, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamIn sendChunk: failed to send a Chunk to inbound server\n", exception);
        }
    }

    public byte[] getProcessedLowWatermark() {
        return this.processedLWM;
    }

    public byte[] getLastPosition() {
        return this.lastPosition;
    }

    public void flush(int n) throws StreamsException {
        try {
            this.processedLWM = this.XStreamInFlushNative(this.ocisvc, this.ocierr, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamIn flush: failed to flush the network\n", exception);
        }
    }

    private synchronized native ArrayList XStreamInAttachNative(long var1, long var3, String var5, String var6, int var7, int var8) throws StreamsException;

    private synchronized native byte[] XStreamInDetachNative(long var1, long var3, int var5) throws StreamsException;

    private synchronized native byte[] XStreamInSendLCRCallbackNative(long var1, long var3, XStreamLCRCallbackHandler var5, int var6) throws StreamsException;

    private synchronized native ArrayList XStreamInSendLCRNative(long var1, long var3, LCR var5, int var6) throws StreamsException;

    private synchronized native void XStreamInSendChunkNative(long var1, long var3, ChunkColumnValue var5, int var6) throws StreamsException;

    private synchronized native byte[] XStreamInFlushNative(long var1, long var3, int var5) throws StreamsException;

    static {
        if (!library_loaded) {
            String string = System.getProperty("os.name");
            if (null != string && string.toUpperCase().startsWith("WINDOWS")) {
                System.loadLibrary("oci");
                library_loaded = true;
            } else if (null != string && string.equalsIgnoreCase("Mac OS X")) {
                System.loadLibrary("clntsh");
                library_loaded = true;
            } else if (string.equalsIgnoreCase("AIX")) {
                System.loadLibrary("clntsh");
                library_loaded = true;
            }
        }
    }
}

