/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.streams.AbstractLCR;
import oracle.streams.ChunkColumnValue;
import oracle.streams.ColumnValue;
import oracle.streams.RowLCR;
import oracle.streams.StreamsException;

public class DefaultRowLCR
extends AbstractLCR
implements RowLCR {
    protected ColumnValue[] oldValues = null;
    protected ColumnValue[] newValues = null;
    protected boolean chunkDataFlag = false;
    private final String DOUBLE_QUOTE = "\"";
    private final String SINGLE_QUOTE = "'";
    private final String COMMA = ",";
    private final String LEFT_PARAN = " ( ";
    private final String RIGHT_PARAN = " ) ";
    private final String DOT = ".";
    private final String INSERT_INTO = " INSERT INTO ";
    private final String UPDATE = " UPDATE ";
    private final String DELETE_FROM = " DELETE FROM ";
    private final String SELECT = " SELECT ";
    private final String VALUES = " ) VALUES ( ";
    private final String IS_NULL = " IS NULL ";
    private final String NULL = " NULL ";
    private final String FOR_UPDATE = " FOR UPDATE ";
    private final String COMMIT = " COMMIT ";
    private final String FROM = " FROM ";
    private final String WHERE = " WHERE ";
    private final String AND = " AND ";
    private final String SET = " SET ";
    private final String BIND_CHAR = " ? ";
    private final String EQUALS = " = ";
    private final String EMPTYBLOB = " EMPTY_BLOB() ";
    private final String EMPTYCLOB = " EMPTY_CLOB() ";
    private final String EMPTYLONG = " '0' ";
    private final String EMPTYXML = " '<xml />' ";
    private String dateFormat;
    private String timeStampFormat;
    private ColumnValue[] bindsWhere;
    private ColumnValue[] bindsNonWhere;
    int bindsWhereCount;
    int bindsNonWhereCount;

    public DefaultRowLCR(String string, String string2, String string3, String string4, String string5, byte[] byArray, byte[] byArray2, DATE dATE) {
        this.setSourceDatabaseName(string);
        this.setCommandType(string2);
        this.setObjectOwner(string3);
        this.setObjectName(string4);
        this.setTransactionId(string5);
        this.setTag(byArray);
        this.setPosition(byArray2);
        this.setSourceTime(dATE);
    }

    public DefaultRowLCR() {
    }

    private void initBinds() {
        ColumnValue[] columnValueArray = this.getOldValues();
        ColumnValue[] columnValueArray2 = this.getNewValues();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (columnValueArray != null) {
            n = columnValueArray.length;
        }
        if (columnValueArray2 != null) {
            n2 = columnValueArray2.length;
        }
        n3 = n > n2 ? n : n2;
        this.bindsWhere = new ColumnValue[n3];
        this.bindsNonWhere = new ColumnValue[n3];
        this.bindsWhereCount = 0;
        this.bindsNonWhereCount = 0;
    }

    public ColumnValue[] getOldValues() {
        return this.oldValues;
    }

    public ColumnValue[] getNewValues() {
        return this.newValues;
    }

    public void setOldValues(ColumnValue[] columnValueArray) {
        this.oldValues = columnValueArray;
    }

    public void setNewValues(ColumnValue[] columnValueArray) {
        this.newValues = columnValueArray;
    }

    public boolean hasChunkData() {
        return this.chunkDataFlag;
    }

    public void setChunkDataFlag(boolean bl) {
        this.chunkDataFlag = bl;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public void setTimeStampFormat(String string) {
        this.timeStampFormat = string;
    }

    public String getStatement(boolean bl) throws StreamsException {
        if (this.bindsWhere == null) {
            this.initBinds();
        }
        String string = this.getCommandType().equals("INSERT") ? this.getInsertStatement(bl) : (this.getCommandType().equals("UPDATE") ? this.getUpdateStatement(bl) : (this.getCommandType().equals("DELETE") ? this.getDeleteStatement(bl) : (this.getCommandType().equals("LOB TRIM") ? this.getLobPWiseStatement(bl) : (this.getCommandType().equals("LOB ERASE") ? this.getLobPWiseStatement(bl) : (this.getCommandType().equals("LOB WRITE") ? this.getLobPWiseStatement(bl) : this.getCommandType())))));
        return string;
    }

    public ColumnValue[] getBinds() {
        ColumnValue[] columnValueArray = new ColumnValue[this.bindsWhereCount + this.bindsNonWhereCount];
        for (int i = 0; i < this.bindsNonWhereCount; ++i) {
            columnValueArray[i] = this.bindsNonWhere[i];
        }
        for (int i = 0; i < this.bindsWhereCount; ++i) {
            columnValueArray[i + i] = this.bindsWhere[i];
        }
        return columnValueArray;
    }

    public String getWhereClause(boolean bl) throws StreamsException {
        String string = this.getCommandType().equals("UPDATE") || this.getCommandType().equals("DELETE") ? this.getWhereClause(bl, this.getOldValues(), false) : (this.getCommandType().equals("LOB TRIM") || this.getCommandType().equals("LOB ERASE") || this.getCommandType().equals("LOB WRITE") || this.getCommandType().equals("INSERT") ? this.getWhereClause(bl, this.getNewValues(), false) : "");
        return string;
    }

    public ColumnValue[] getWhereClauseBinds() {
        ColumnValue[] columnValueArray = new ColumnValue[this.bindsWhereCount];
        for (int i = 0; i < this.bindsWhereCount; ++i) {
            columnValueArray[i] = this.bindsWhere[i];
        }
        return columnValueArray;
    }

    private String getLobPWiseStatement(boolean bl) throws StreamsException {
        StringBuilder stringBuilder = new StringBuilder();
        ColumnValue[] columnValueArray = this.getNewValues();
        stringBuilder.append(" SELECT ");
        for (int i = 0; i < columnValueArray.length; ++i) {
            if (!(columnValueArray[i] instanceof ChunkColumnValue)) continue;
            stringBuilder.append("\"" + columnValueArray[i].getColumnName() + "\"");
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append("\"" + this.getObjectOwner() + "\"" + ".");
        stringBuilder.append("\"" + this.getObjectName() + "\"");
        stringBuilder.append(this.getWhereClause(bl, this.getNewValues(), true));
        stringBuilder.append(" FOR UPDATE ");
        return stringBuilder.toString();
    }

    private String getInsertStatement(boolean bl) throws StreamsException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        ColumnValue[] columnValueArray = this.getNewValues();
        stringBuilder.append(" INSERT INTO ");
        stringBuilder.append("\"" + this.getObjectOwner() + "\"" + ".");
        stringBuilder.append("\"" + this.getObjectName() + "\"" + " ( ");
        for (n = 0; n < columnValueArray.length; ++n) {
            if (n < columnValueArray.length - 1) {
                stringBuilder.append("\"" + columnValueArray[n].getColumnName() + "\"" + ",");
                continue;
            }
            stringBuilder.append("\"" + columnValueArray[n].getColumnName() + "\"");
        }
        stringBuilder.append(" ) VALUES ( ");
        for (n = 0; n < columnValueArray.length; ++n) {
            if (bl) {
                stringBuilder.append(" ? ");
                this.bindsNonWhere[this.bindsNonWhereCount++] = columnValueArray[n];
            } else {
                ColumnValue columnValue = columnValueArray[n];
                stringBuilder.append(this.getStringValue(columnValue, false));
            }
            if (n >= columnValueArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(" ) ");
        return stringBuilder.toString();
    }

    private String getStringValue(ColumnValue columnValue, boolean bl) throws StreamsException {
        String string = " NULL ";
        SimpleDateFormat simpleDateFormat = null;
        SimpleDateFormat simpleDateFormat2 = null;
        simpleDateFormat = this.dateFormat != null ? new SimpleDateFormat(this.dateFormat) : null;
        simpleDateFormat2 = this.timeStampFormat != null ? new SimpleDateFormat(this.timeStampFormat) : null;
        Datum datum = columnValue.getColumnData();
        try {
            if (columnValue instanceof ChunkColumnValue) {
                ChunkColumnValue chunkColumnValue = (ChunkColumnValue)columnValue;
                int n = chunkColumnValue.getChunkType();
                if (n == 2 || n == 6) {
                    string = " EMPTY_BLOB() ";
                } else if (n == 1 || n == 3) {
                    string = " EMPTY_CLOB() ";
                } else if (n == 5) {
                    string = " '0' ";
                } else if (n == 4) {
                    string = " '<xml />' ";
                }
                return string;
            }
            switch (columnValue.getColumnDataType()) {
                case 2: 
                case 100: 
                case 101: {
                    if (datum != null) {
                        string = datum.stringValue();
                    }
                    break;
                }
                case 12: {
                    if (datum != null) {
                        Timestamp timestamp = (Timestamp)datum.toJdbc();
                        string = simpleDateFormat != null ? simpleDateFormat.format(timestamp) : timestamp.toString();
                        string = "'" + string + "'";
                    }
                    break;
                }
                case 180: {
                    if (datum != null) {
                        Timestamp timestamp = (Timestamp)datum.toJdbc();
                        string = simpleDateFormat2 != null ? simpleDateFormat2.format(timestamp) : timestamp.toString();
                        string = "'" + string + "'";
                    }
                    break;
                }
                case 181: {
                    string = " NULL ";
                    break;
                }
                default: {
                    if (datum != null) {
                        string = "'" + datum.stringValue() + "'";
                    }
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new StreamsException("Unable to get String Value", sQLException);
        }
        String string2 = bl ? (string.equals(" NULL ") ? " IS NULL " : " = " + string) : string;
        return string2;
    }

    private String getUpdateStatement(boolean bl) throws StreamsException {
        StringBuilder stringBuilder = new StringBuilder();
        ColumnValue[] columnValueArray = this.getNewValues();
        stringBuilder.append(" UPDATE ");
        stringBuilder.append("\"" + this.getObjectOwner() + "\"" + ".");
        stringBuilder.append("\"" + this.getObjectName() + "\"" + " SET ");
        for (int i = 0; i < columnValueArray.length; ++i) {
            stringBuilder.append("\"" + columnValueArray[i].getColumnName() + "\"" + " = ");
            if (bl) {
                stringBuilder.append(" ? ");
                this.bindsNonWhere[this.bindsNonWhereCount++] = columnValueArray[i];
            } else {
                stringBuilder.append(this.getStringValue(columnValueArray[i], false));
            }
            if (i >= columnValueArray.length - 1) continue;
            stringBuilder.append(",");
        }
        ColumnValue[] columnValueArray2 = this.getOldValues();
        if (columnValueArray == null || columnValueArray.length == 0) {
            if (columnValueArray2.length != 0) {
                stringBuilder.append("\"" + columnValueArray2[0].getColumnName() + "\"" + " = " + columnValueArray2[0].getColumnName());
            } else {
                throw new StreamsException("UPDATE LCR without old values");
            }
        }
        stringBuilder.append(this.getWhereClause(bl, this.getOldValues(), true));
        return stringBuilder.toString();
    }

    private String getDeleteStatement(boolean bl) throws StreamsException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" DELETE FROM ");
        stringBuilder.append("\"" + this.getObjectOwner() + "\"" + ".");
        stringBuilder.append("\"" + this.getObjectName() + "\"");
        ColumnValue[] columnValueArray = this.getOldValues();
        stringBuilder.append(this.getWhereClause(bl, this.getOldValues(), true));
        return stringBuilder.toString();
    }

    private String getWhereClause(boolean bl, ColumnValue[] columnValueArray, boolean bl2) throws StreamsException {
        StringBuilder stringBuilder = new StringBuilder();
        ColumnValue[] columnValueArray2 = null;
        int n = -1;
        if (this.bindsWhere == null) {
            this.initBinds();
        }
        if (this.getCommandType().equals("UPDATE")) {
            columnValueArray2 = this.getNewValues();
        }
        stringBuilder.append(" WHERE ");
        for (int i = 0; i < columnValueArray.length; ++i) {
            if (columnValueArray[i] instanceof ChunkColumnValue) continue;
            if (i != 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("\"" + columnValueArray[i].getColumnName() + "\"");
            if (columnValueArray2 != null && !bl2) {
                for (n = 0; n < columnValueArray2.length && !columnValueArray[i].getColumnName().equals(columnValueArray2[n].getColumnName()); ++n) {
                }
                if (n == columnValueArray2.length) {
                    n = -1;
                }
            } else {
                n = -1;
            }
            if (bl) {
                stringBuilder.append(" =  ? ");
                this.bindsWhere[this.bindsWhereCount++] = n == -1 ? columnValueArray[i] : columnValueArray2[n];
                continue;
            }
            stringBuilder.append(this.getStringValue(n == -1 ? columnValueArray[i] : columnValueArray2[n], true));
        }
        return stringBuilder.toString();
    }
}

