/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;
    private boolean isFreed = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:38:22_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleSerialBlob(byte[] byArray) throws SQLException {
        this.length = byArray.length;
        this.buffer = new byte[(int)this.length];
        int n2 = 0;
        while ((long)n2 < this.length) {
            this.buffer[n2] = byArray[n2];
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleSerialBlob(Blob blob) throws SQLException {
        this.length = blob.length();
        this.buffer = new byte[(int)this.length];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
        try {
            try {
                int n2 = 0;
                int n3 = 0;
                do {
                    n2 = bufferedInputStream.read(this.buffer, n3, (int)(this.length - (long)n3));
                    n3 += n2;
                } while (n2 > 0);
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 346, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 346, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        try {}
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 346, iOException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bufferedInputStream == null) return;
        bufferedInputStream.close();
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new ByteArrayInputStream(this.buffer);
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray = null;
        if (--l2 < 0L || (long)n2 > this.length || l2 + (long)n2 > this.length) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byArray = new byte[n2];
        System.arraycopy(this.buffer, (int)l2, byArray, 0, n2);
        return byArray;
    }

    public long length() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.length;
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 > this.length || l2 + (long)byArray.length > this.length) {
            return -1L;
        }
        int n2 = (int)(l2 - 1L);
        boolean bl = false;
        long l3 = byArray.length;
        while ((long)n2 < this.length) {
            int n3 = 0;
            long l4 = n2 + 1;
            int n4 = n2;
            while ((long)n3 < l3 && (long)n4 < this.length && byArray[n3] == this.buffer[n4]) {
                ++n4;
                if ((long)(++n3) != l3) continue;
                return l4;
            }
            ++n2;
        }
        return -1L;
    }

    public long position(Blob blob, long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.position(blob.getBytes(1L, (int)blob.length()), l2);
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public void truncate(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

