/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.activation;

import com.genuitec.eclipse.core.ActivationCodeDecryptor;
import com.genuitec.eclipse.core.activation.InvalidSystemDataException;
import com.genuitec.eclipse.core.activation.SystemId;
import com.genuitec.eclipse.core.util.PlatformUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ActivationCode {
    public static final int STD_FORMAT = 1;
    private static final SimpleDateFormat F = new SimpleDateFormat("yyyyMMdd", Locale.US);
    private int E = 1;
    private SystemId A;
    private String B;
    private Date C;
    private String D;

    public static ActivationCode fromCode(String string) throws InvalidSystemDataException {
        Date date;
        String string2;
        SystemId systemId;
        int n;
        if (PlatformUtil.isNullOrEmpty((String)string)) {
            throw new InvalidSystemDataException();
        }
        String string3 = ActivationCodeDecryptor.decrypt(string);
        if (string3 == null || string3.length() < 35) {
            throw new InvalidSystemDataException();
        }
        try {
            n = Integer.parseInt(string3.substring(1, 2));
            if (n != 1) {
                throw new InvalidSystemDataException();
            }
            String string4 = string3.substring(1, 20);
            systemId = SystemId.fromCode(string4);
            int n2 = Integer.parseInt(string3.substring(20, 22));
            int n3 = 22 + n2;
            string2 = string3.substring(22, n3);
            String string5 = string3.substring(n3, n3 += 6);
            date = F.parse("20" + string5);
        }
        catch (Exception exception) {
            throw new InvalidSystemDataException("Corrupt activation code");
        }
        return new ActivationCode(n, systemId, string2, date, string);
    }

    private ActivationCode(int n, SystemId systemId, String string, Date date, String string2) {
        this.E = n;
        this.A = systemId;
        this.B = string;
        this.C = date;
        this.D = string2;
    }

    public int getFormat() {
        return this.E;
    }

    public SystemId getSystemId() {
        return this.A;
    }

    public String getLicenseCode() {
        return this.B;
    }

    public Date getExpirationDate() {
        return this.C;
    }

    public boolean isExpired() {
        return this.isExpired(new Date());
    }

    public boolean isExpired(Date date) {
        return date.getTime() > this.getExpirationDate().getTime();
    }

    public String getActivationServerResponse() {
        return this.D;
    }
}

