/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui.internal;

import com.genuitec.eclipse.j2eedt.core.version.IJEEVersionInfo;
import com.genuitec.eclipse.j2eedt.core.version.JEE;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import com.genuitec.eclipse.j2eedt.ui.wizard.EARProjectWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class EarSelectionPanel
implements IWebFacetInstallDataModelProperties {
    private final Button addToEar;
    private final Combo combo;
    private final Button newButton;
    private final Label label;
    private final IDataModel model;
    private DataModelSynchHelper synchhelper;

    public EarSelectionPanel(IDataModel model, Composite parent) {
        this.model = model;
        this.synchhelper = new DataModelSynchHelper(model);
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)EarSelectionPanel.gdhfill());
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("EAR membership");
        this.addToEar = new Button((Composite)group, 32);
        this.addToEar.setText("&Add project to an EAR");
        GridDataFactory.defaultsFor((Control)this.addToEar).span(3, 1).applyTo((Control)this.addToEar);
        this.synchhelper.synchCheckbox(this.addToEar, "IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", null);
        this.label = new Label((Composite)group, 0);
        this.label.setText("&EAR project name:");
        this.combo = new Combo((Composite)group, 0);
        this.combo.setLayoutData((Object)EarSelectionPanel.gdhfill());
        this.newButton = new Button((Composite)group, 8);
        this.newButton.setText("New &Project...");
        GridDataFactory.defaultsFor((Control)this.newButton).applyTo((Control)this.newButton);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EarSelectionPanel.this.handleAddButton();
            }
        });
        this.synchhelper.synchCombo(this.combo, "IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", new Control[]{this.label, this.newButton});
        Dialog.applyDialogFont((Control)parent);
    }

    private void handleAddButton() {
        EARProjectWizard wizard = new EARProjectWizard();
        WizardDialog dialog = new WizardDialog(this.newButton.getShell(), (IWizard)wizard);
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)wizard.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = map.getFacetDataModel("jst.ear");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)this.getJEEVersion().getEAR().getFacetVersion());
        wizard.getDataModel().setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
        if (dialog.open() != 1) {
            this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", 4);
            String earproj = wizard.getProjectName();
            this.model.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earproj);
        }
    }

    private JEE getJEEVersion() {
        IProjectFacetVersion fv = (IProjectFacetVersion)this.model.getProperty("IFacetDataModelPropeties.FACET_VERSION");
        JEEProjectType[] jEEProjectTypeArray = JEEProjectType.values();
        int n = jEEProjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JEEProjectType t = jEEProjectTypeArray[n2];
            IJEEVersionInfo info = t.getVersionInfo(fv);
            if (info != null) {
                return info.getJEE();
            }
            ++n2;
        }
        return null;
    }

    private static GridData gdhfill() {
        return new GridData(768);
    }

    public static final GridData gdhspan(GridData gd, int span) {
        gd.horizontalSpan = span;
        return gd;
    }

    public void dispose() {
        if (this.synchhelper != null) {
            this.synchhelper.dispose();
            this.synchhelper = null;
        }
    }

    public String getComboText() {
        return this.combo.getText();
    }
}

