/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.core;

import com.genuitec.eclipse.core.ui.dialog.LinkDialog;
import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.web.core.internal.project.JsNatureInstaller;
import org.osgi.framework.Bundle;

public class JavaScriptProjectUtil {
    private static final String JSDT_JS_NATURE = "org.eclipse.wst.jsdt.core.jsNature";
    public static final String PREF_ASK_PROJECT_UPGRADE = "myeclipse.projectupgrade.prompt2";
    private static Boolean genuitecJSNature;

    private static boolean ignoringProject(String name) {
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        String projects = preferenceStore.getString(PREF_ASK_PROJECT_UPGRADE);
        Object[] split = projects.split("/");
        Arrays.sort(split);
        return Arrays.binarySearch(split, name) >= 0;
    }

    public static void addJavaScriptCaps(IProject theProject) {
        if (!JavaScriptProjectUtil.isJavaScriptProject(theProject)) {
            try {
                IProjectDescription description = theProject.getDescription();
                String[] natureIds = description.getNatureIds();
                ArrayList<String> ids = new ArrayList<String>(Arrays.asList(natureIds));
                if (!ids.contains(JSDT_JS_NATURE)) {
                    ids.add(JSDT_JS_NATURE);
                }
                description.setNatureIds(ids.toArray(new String[ids.size()]));
                theProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                new JsNatureInstaller().installNature(theProject, (IProgressMonitor)new NullProgressMonitor());
                description = theProject.getDescription();
                String[] stringArray = description.getNatureIds();
            }
            catch (CoreException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static boolean hasGenuitecJSSupport() {
        if (genuitecJSNature == null) {
            Bundle bundle = Platform.getBundle((String)JSDT_JS_NATURE);
            try {
                bundle.loadClass("org.eclipse.wst.jsdt.core.JavaScriptJSDTNature");
                genuitecJSNature = Boolean.TRUE;
            }
            catch (Exception ex) {
                J2EEUICore.getDefault().log("Genuitec JS support N/A", ex);
                genuitecJSNature = Boolean.FALSE;
            }
        }
        return genuitecJSNature;
    }

    public static boolean isJavaScriptProject(IProject theProject) {
        try {
            return theProject.hasNature(JSDT_JS_NATURE) && JavaScriptProjectUtil.hasJSDTWebNature(theProject);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static LinkDialog createQuestionDialog(Shell shell, String checkboxText) {
        LinkDialog dialog = new LinkDialog(shell, Messages.JavaScriptProjectUtil_JS_upgrade_title, null, Messages.JavaScriptProjectUtil_JS_upgrade_prompt, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, (Runnable)new LinkDialog.HelpRunnable("https://www.genuitec.com/products/myeclipse/learning-center/web/myeclipse-javascript-development-overview/#appendix-a"));
        if (checkboxText != null) {
            dialog.setCheckboxLabel(checkboxText);
        }
        return dialog;
    }

    private static boolean shouldUpgrade(IProject project, Shell shell) {
        if (JavaScriptProjectUtil.ignoringProject(project.getName())) {
            return false;
        }
        LinkDialog dialog = JavaScriptProjectUtil.createQuestionDialog(shell, Messages.JavaScriptProjectUtil_remember_JS_setting_label);
        if (dialog.open() == 0) {
            return true;
        }
        if (dialog.getToggleState()) {
            JavaScriptProjectUtil.storeProject(project.getName());
        }
        return false;
    }

    private static void storeProject(String theName) {
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        String val = String.valueOf(preferenceStore.getString(PREF_ASK_PROJECT_UPGRADE)) + "/" + theName;
        preferenceStore.setValue(PREF_ASK_PROJECT_UPGRADE, val);
    }

    public static void upgradeProjectIfNeeded(Shell shell, IAdaptable adaptable) {
        IProject project;
        if (shell == null || adaptable == null) {
            return;
        }
        if (!shell.isVisible()) {
            shell.addControlListener((ControlListener)new DelayedProjectUpdater(shell, adaptable));
            return;
        }
        IResource file = (IResource)adaptable.getAdapter(IResource.class);
        if (file != null && file.getType() == 1 && !JavaScriptProjectUtil.isJavaScriptProject(project = file.getProject()) && JavaScriptProjectUtil.shouldUpgrade(project, shell)) {
            try {
                J2EEUICore.getWorkspace().run((IWorkspaceRunnable)new ProjectUpdateWorkspaceRunnable(file), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                J2EEUICore.getDefault().log(ex);
            }
        }
    }

    private static boolean hasJSDTWebNature(IProject project) {
        Path fullPath = new Path(".settings");
        fullPath = fullPath.append("org.eclipse.wst.jsdt.ui.superType.name");
        return project.getFile((IPath)fullPath).exists();
    }

    private static final class DelayedProjectUpdater
    extends ControlAdapter
    implements Runnable {
        private final Shell shell;
        private final IAdaptable adaptable;

        private DelayedProjectUpdater(Shell shell, IAdaptable adaptable) {
            this.shell = shell;
            this.adaptable = adaptable;
        }

        public void controlMoved(ControlEvent e) {
            this.shell.removeControlListener((ControlListener)this);
            e.display.asyncExec((Runnable)this);
        }

        @Override
        public void run() {
            JavaScriptProjectUtil.upgradeProjectIfNeeded(this.shell, this.adaptable);
        }
    }

    private static final class ProjectUpdateWorkspaceRunnable
    implements IWorkspaceRunnable {
        private final IResource file;

        private ProjectUpdateWorkspaceRunnable(IResource file) {
            this.file = file;
        }

        public void run(IProgressMonitor theMonitor) throws CoreException {
            JavaScriptProjectUtil.addJavaScriptCaps(this.file.getProject());
        }
    }
}

