/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.legacy;

import com.genuitec.eclipse.server.core.BaseServerLaunchConfig;
import com.genuitec.eclipse.server.core.legacy.EASIEServerManager;
import com.genuitec.eclipse.server.core.legacy.LegacyGenuitecServer;
import com.genuitec.eclipse.server.core.legacy.LegacyGenuitecServerBehaviour;
import com.genuitec.eclipse.server.core.legacy.ParameterizedArgument;

public class LegacyGenuitecServerLaunchConfig
extends BaseServerLaunchConfig {
    private LegacyGenuitecServer server;
    private EASIEServerManager manager;
    private EASIEServerManager.Mode mode;

    public LegacyGenuitecServerLaunchConfig(LegacyGenuitecServerBehaviour behaviour, boolean isShutdown) {
        super(behaviour.getLegacyGenuitecServer());
        this.server = behaviour.getLegacyGenuitecServer();
        this.manager = behaviour.getEASIEServerManager();
        this.mode = isShutdown ? EASIEServerManager.Mode.SHUTDOWN : EASIEServerManager.Mode.STARTUP;
    }

    @Override
    protected String[] internalGetLaunchClasspath() {
        return ParameterizedArgument.convertToStringArray(this.manager.getClasspathArgs(this.mode), this.server);
    }

    @Override
    public String[] getLaunchVMArguments() {
        return ParameterizedArgument.convertToStringArray(this.manager.getVMArgs(this.mode), this.server);
    }

    @Override
    public String[] getLaunchProgramArguments() {
        return ParameterizedArgument.convertToStringArray(this.manager.getProgramArgs(this.mode), this.server);
    }

    @Override
    public String getLaunchWorkingDirectory() {
        return this.manager.getDirectory(this.mode).getParameterString(this.server);
    }

    @Override
    public String getLaunchMainClass() {
        return this.manager.getClassName(this.mode);
    }

    @Override
    public boolean launchRequiresToolsJar() {
        return true;
    }
}

