/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.dialog;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PreferenceNodeFilter;

public class FilteredComboTree
extends Composite {
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DCLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private String cachedTitle;
    private TableCombo filterCombo;
    private Composite filterParent;
    private ToolBarManager filterToolBar;
    protected String initialText = "";
    private FocusListener listener;
    private PatternFilter patternFilter;
    private TreeViewer treeViewer;
    private TableComboViewer filterComboViewer;

    public FilteredComboTree(Composite parent, int treeStyle) {
        this(parent, treeStyle, new PatternFilter());
    }

    public FilteredComboTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, 0);
        this.patternFilter = filter;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.filterParent = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout();
        filterLayout.numColumns = 3;
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        this.filterParent.setLayout((Layout)filterLayout);
        this.filterParent.setFont(parent.getFont());
        this.filterParent.setLayoutData((Object)new GridData(768));
        this.createComboLabel(this.filterParent);
        this.createFilterControl(this.filterParent);
        this.getFilterControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    if (!(FilteredComboTree.this.getFilterControl() instanceof TableCombo)) {
                        FilteredComboTree.this.treeViewer.getTree().setFocus();
                    }
                } else {
                    FilteredComboTree.this.textChanged();
                }
            }
        });
        GridData data = new GridData(768);
        this.getFilterControl().setLayoutData((Object)data);
        ToolBar toolBar = new ToolBar(this.filterParent, 0x800100);
        this.filterToolBar = new ToolBarManager(toolBar);
        this.createClearText(this.filterToolBar);
        this.filterToolBar.update(false);
        this.filterToolBar.getControl().setVisible(false);
        this.treeViewer = new TreeViewer((Composite)this, treeStyle);
        data = new GridData(1808);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
    }

    public void addFilter(PreferenceNodeFilter filter) {
        this.getViewer().addFilter((ViewerFilter)filter);
        this.setInitialText("filtered");
        if (this.getFilterControl() != null) {
            this.setFilterText("filtered");
            this.textChanged();
        }
        this.cachedTitle = this.getShell().getText();
        this.getShell().setText(NLS.bind((String)WorkbenchMessages.FilteredTree_FilteredDialogTitle, (Object)this.cachedTitle));
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    private void createClearText(ToolBarManager filterToolBar) {
        Action clearTextAction = new Action("", 1){

            public void run() {
                FilteredComboTree.this.clearText();
            }
        };
        clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
        clearTextAction.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON));
        clearTextAction.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(DCLEAR_ICON));
        filterToolBar.add((IAction)clearTextAction);
    }

    protected void createComboLabel(Composite parent) {
    }

    protected void createFilterControl(Composite parent) {
        this.filterComboViewer = new TableComboViewer(parent);
        this.filterCombo = this.filterComboViewer.getTableCombo();
        this.filterCombo.setFont(parent.getFont());
        this.filterCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (FilteredComboTree.this.getViewer().getTree().getItemCount() == 0) {
                        Display.getCurrent().beep();
                        FilteredComboTree.this.setFilterText("");
                    } else {
                        FilteredComboTree.this.getViewer().getTree().setFocus();
                    }
                }
            }
        });
        this.filterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredComboTree.this.textChanged();
            }
        });
        this.filterCombo.getAccessible().addAccessibleListener((AccessibleListener)this.getAccessibleListener());
        this.filterCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = FilteredComboTree.this.filterCombo.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!FilteredComboTree.this.filterCombo.isDisposed() && FilteredComboTree.this.getInitialText().equals(FilteredComboTree.this.filterCombo.getText().trim())) {
                            FilteredComboTree.this.selectAll();
                        }
                    }
                });
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.filterCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredComboTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredComboTree.this.treeViewer.getTree().setFocus();
                    return;
                }
            }
        });
    }

    protected AccessibleAdapter getAccessibleListener() {
        return new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredComboTree.this.getFilterText();
                e.result = filterTextString.length() == 0 ? FilteredComboTree.this.initialText : filterTextString;
            }
        };
    }

    public TableCombo getFilterCombo() {
        return this.filterCombo;
    }

    public TableComboViewer getFilterComboViewer() {
        return this.filterComboViewer;
    }

    public Control getFilterControl() {
        return this.filterCombo;
    }

    protected String getFilterText() {
        return this.filterCombo.getText();
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected void selectAll() {
        this.filterCombo.setSelection(new Point(0, this.filterCombo.getText().length()));
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.filterParent.setBackground(background);
        this.getFilterControl().setBackground(background);
        this.filterToolBar.getControl().setBackground(background);
    }

    protected void setFilterText(String string) {
        this.filterCombo.setText(string);
        this.selectAll();
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.filterCombo != null) {
            this.filterCombo.setText(text);
            if (this.filterCombo.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!FilteredComboTree.this.filterCombo.isDisposed() && FilteredComboTree.this.filterCombo.isFocusControl()) {
                            FilteredComboTree.this.setFilterText(FilteredComboTree.this.initialText);
                            FilteredComboTree.this.textChanged();
                        }
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    public void textChanged() {
        boolean initial;
        String filterText = this.getFilterText();
        boolean bl = initial = this.initialText != null && filterText.equals(this.initialText);
        if (initial) {
            this.patternFilter.setPattern(null);
        } else {
            this.patternFilter.setPattern(this.getFilterText());
        }
        this.treeViewer.refresh(true);
        if (filterText.length() > 0 && !initial) {
            this.treeViewer.expandAll();
            this.filterToolBar.getControl().setVisible(true);
        } else {
            this.filterToolBar.getControl().setVisible(false);
        }
    }
}

