/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.property;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.property.MetricsCalculator;
import com.genuitec.eclipse.core.util.JavaMetaUtils;
import com.genuitec.eclipse.core.util.Util;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.framework.Bundle;

public class InfoProjectPropertiesPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    public static final String METRICS_NODE = "com.genuitec.eclipse.core";
    private Label srcFolderCntLabel;
    private Label pkgCntLabel;
    private Label classCntLabel;
    private Label locLabel;
    private CheckboxTableViewer deploymentsViewer;
    private Button updateBtn;
    private Label updateTime;
    private WorkingCopyManager wcManager;

    public InfoProjectPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite theParent) {
        Composite composite = new Composite(theParent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        Label lbl = new Label(composite, 0);
        lbl.setText(Messages.InfoProjectPropertiesPage_label_project);
        lbl = new Label(composite, 0);
        lbl.setText(this.getProjectName());
        Bundle pBundle = Platform.getBundle((String)"com.genuitec.myeclipse.perspective");
        if (pBundle != null) {
            try {
                Class pageClass = pBundle.loadClass("com.genuitec.myeclipse.ui.properties.InfoProjectPropertiesPage");
                Method contents = pageClass.getMethod("createContents", IProject.class, Composite.class);
                contents.invoke(null, this.getProject(), composite);
            }
            catch (Exception exception) {
                CommonUI.getDefault().log("Could not create capability and deployment area");
            }
        }
        this.createMetricsGroup(composite);
        return theParent;
    }

    private void createMetricsGroup(Composite composite) {
        Group mGroup1 = new Group(composite, 0);
        mGroup1.setText(Messages.InfoProjectPropertiesPage_group_javaStatistics);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        mGroup1.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 20;
        mGroup1.setLayout((Layout)new GridLayout(2, false));
        Composite mGroup = new Composite((Composite)mGroup1, 0);
        mGroup.setLayout((Layout)new GridLayout(3, false));
        Label lbl = new Label(mGroup, 0);
        lbl.setImage(JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packagefolder_obj.gif"));
        lbl = new Label(mGroup, 0);
        lbl.setText(Messages.InfoProjectPropertiesPage_label_sourceFolders);
        this.srcFolderCntLabel = new Label(mGroup, 0);
        lbl = new Label(mGroup, 0);
        lbl.setImage(JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif"));
        lbl = new Label(mGroup, 0);
        lbl.setText(Messages.InfoProjectPropertiesPage_label_packages);
        this.pkgCntLabel = new Label(mGroup, 0);
        lbl = new Label(mGroup, 0);
        lbl.setImage(JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif"));
        lbl = new Label(mGroup, 0);
        lbl.setText(Messages.InfoProjectPropertiesPage_label_classesAndInterfaces);
        this.classCntLabel = new Label(mGroup, 0);
        lbl = new Label(mGroup, 0);
        lbl.setImage(CommonUI.getDefault().getImage("icons/loc.gif"));
        lbl = new Label(mGroup, 0);
        lbl.setText(Messages.InfoProjectPropertiesPage_label_linesOfCode);
        this.locLabel = new Label(mGroup, 0);
        Composite uGroup = new Composite((Composite)mGroup1, 0);
        uGroup.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(1808);
        gd.verticalAlignment = 16;
        uGroup.setLayoutData((Object)gd);
        this.updateTime = new Label(uGroup, 0);
        this.updateBtn = new Button(uGroup, 8);
        this.updateBtn.setText(Messages.InfoProjectPropertiesPage_button_update);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.updateBtn.setLayoutData((Object)gd);
        this.updateBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InfoProjectPropertiesPage.this.computeMetrics();
            }
        });
        this.loadMetrics();
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        return (IProject)(element instanceof JavaProject ? ((JavaProject)element).getProject() : element);
    }

    private String getProjectName() {
        IAdaptable element = this.getElement();
        if (element instanceof JavaProject) {
            element = ((JavaProject)element).getProject();
        }
        if (element instanceof IProject) {
            return ((IProject)element).getName();
        }
        return "";
    }

    private void loadMetrics() {
        ProjectScope projectScope = new ProjectScope(this.getProject());
        IEclipsePreferences projectNode = projectScope.getNode(METRICS_NODE);
        projectNode = this.getWorkingCopyManager().getWorkingCopy(projectNode);
        if (projectNode == null) {
            return;
        }
        String temp = projectNode.get("sTime", "");
        if (Util.isNullOrEmpty((String)temp)) {
            this.updateTime.setText(Messages.InfoProjectPropertiesPage_label_lastUpdateUnavailable);
        } else {
            this.updateTime.setText(MessageFormat.format(Messages.InfoProjectPropertiesPage_label_date_lastUpdated, temp));
        }
        temp = projectNode.get("srcCnt", Messages.InfoProjectPropertiesPage_label_zero);
        this.srcFolderCntLabel.setText(temp);
        temp = projectNode.get("pkgCnt", Messages.InfoProjectPropertiesPage_label_zero);
        this.pkgCntLabel.setText(temp);
        temp = projectNode.get("clsCnt", Messages.InfoProjectPropertiesPage_label_zero);
        this.classCntLabel.setText(temp);
        temp = projectNode.get("locCnt", Messages.InfoProjectPropertiesPage_label_zero);
        this.locLabel.setText(temp);
    }

    private WorkingCopyManager getWorkingCopyManager() {
        if (this.wcManager == null) {
            this.wcManager = new WorkingCopyManager();
        }
        return this.wcManager;
    }

    protected void computeMetrics() {
        IJavaProject javaProject = null;
        IAdaptable element = this.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof IProject) {
            javaProject = JavaMetaUtils.getJavaProject((IProject)((IProject)element));
        } else if (element instanceof IJavaProject) {
            javaProject = (IJavaProject)element;
        }
        if (javaProject != null) {
            MetricsCalculator calc = new MetricsCalculator(javaProject, this, this.getWorkingCopyManager());
            calc.schedule();
        }
    }

    public void setSrcFolderCount(int value) {
        this.srcFolderCntLabel.setText(String.valueOf(value));
    }

    public void setPkgCount(int value) {
        this.pkgCntLabel.setText(String.valueOf(value));
    }

    public void setClassCount(int value) {
        this.classCntLabel.setText(String.valueOf(value));
    }

    public void setLocCount(int value) {
        this.locLabel.setText(String.valueOf(value));
    }

    public void setUpdateTime(String time) {
        this.updateTime.setText(MessageFormat.format(Messages.InfoProjectPropertiesPage_label_date_lastUpdated, time));
    }

    public void setMetricsRunning(boolean running) {
        this.updateBtn.setText(running ? Messages.InfoProjectPropertiesPage_button_updating : Messages.InfoProjectPropertiesPage_button_update);
        this.updateBtn.setEnabled(!running);
        if (!running) {
            this.updateBtn.getParent().getParent().layout(true, true);
        } else {
            this.updateBtn.getParent().layout();
        }
    }
}

